/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.scripts.nn.layers;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.sysml.api.mlcontext.MLResults;
import org.apache.sysml.api.mlcontext.Matrix;
import org.apache.sysml.api.mlcontext.Script;

public class Softmax2d
extends Script {
    public Softmax2d() {
        String string = "scripts/nn/layers/softmax2d.dml";
        InputStream inputStream = Script.class.getResourceAsStream(new StringBuffer().append("/").append(string).toString());
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        char[] cArray = new char[1024];
        StringBuilder stringBuilder = new StringBuilder();
        try {
            int n;
            while ((n = inputStreamReader.read(cArray)) > 0) {
                stringBuilder.append(cArray, 0, n);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.setScriptString(stringBuilder.toString());
    }

    public Matrix forward(Object object, Object object2) {
        String string = "source('scripts/nn/layers/softmax2d.dml') as mlcontextns;probs = mlcontextns::forward(scores, C);";
        Script script = new Script(string);
        script.in("scores", object).in("C", object2).out("probs");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("probs");
        return matrix;
    }

    public String forward__docs() {
        String string = " forward = function(matrix[double] scores, int C)\n    return (matrix[double] probs) {\n  /*\n   * Computes the forward pass for a softmax2d classifier.  The input\n   * has four dimensions (N, C, Hin, Win), that means it has N\n   * 2d-examples with a shape (Hin, Win), each pixel in the 2d\n   * example has C values that are interpreted as unnormalized,\n   * log-probabilities for each of C classes.  The softmax function\n   * transforms these values to normalized probabilities across the C\n   * classes, for every example.\n   *\n   * This can be interpreted as a generalization of the sigmoid\n   * function to multiple classes.\n   *\n   *   `probs_ijk = e^scores_ijk / sum(e^scores_ijk)`\n   *\n   * In these equations, `probs_ijk` is the C-dimensional vector of the\n   * normalized probabilities for the pixel `j, k` in the example `i`\n   *\n   * Inputs:\n   *  - scores: Inputs, of shape (N, C*Hin*Win).\n   *  - C: Number of input channels (dimensionality of input depth).\n   *\n   * Outputs:\n   *  - probs: Outputs, of shape (N, C*Hin*Win).\n   */\n";
        return string;
    }

    public String forward__source() {
        String string = " forward = function(matrix[double] scores, int C)\n    return (matrix[double] probs) {\n  /*\n   * Computes the forward pass for a softmax2d classifier.  The input\n   * has four dimensions (N, C, Hin, Win), that means it has N\n   * 2d-examples with a shape (Hin, Win), each pixel in the 2d\n   * example has C values that are interpreted as unnormalized,\n   * log-probabilities for each of C classes.  The softmax function\n   * transforms these values to normalized probabilities across the C\n   * classes, for every example.\n   *\n   * This can be interpreted as a generalization of the sigmoid\n   * function to multiple classes.\n   *\n   *   `probs_ijk = e^scores_ijk / sum(e^scores_ijk)`\n   *\n   * In these equations, `probs_ijk` is the C-dimensional vector of the\n   * normalized probabilities for the pixel `j, k` in the example `i`\n   *\n   * Inputs:\n   *  - scores: Inputs, of shape (N, C*Hin*Win).\n   *  - C: Number of input channels (dimensionality of input depth).\n   *\n   * Outputs:\n   *  - probs: Outputs, of shape (N, C*Hin*Win).\n   */\n  # For numerical stability, we subtract the max score of an example from all scores for that\n  # example.  This is equivalent to the original formulation:\n  # e^scores_ijk / sum(e^scores_ijk) == C*e^scores_ijk / C*sum(e^scores_ijk)\n  #                              == e^(scores_ijk+log(C)) / sum(e^(scores_ijk+log(C))\n  # set log(C) = -max(scores_ijk):\n  #                              == e^(scores_ijk-max(scores_ijk)) / sum(e^(scores_ijk-max(scores_ijk))\n\n  N = nrow(scores)\n\n  #Transpose the matrix from (N, C*H*W) to (N*H*W, C)\n  scores_C_NHW = util::transpose_NCHW_to_CNHW(scores, C)\n  scores_NHW_C = t(scores_C_NHW)\n\n  probs_NHW_C = softmax::forward(scores_NHW_C)\n\n  #Transpose the matrix from (N*H*W, C) to (N, C*H*W)\n  probs_C_NHW = t(probs_NHW_C)\n  probs = util::transpose_NCHW_to_CNHW(probs_C_NHW, N)\n}\n";
        return string;
    }

    public Matrix backward(Object object, Object object2, Object object3) {
        String string = "source('scripts/nn/layers/softmax2d.dml') as mlcontextns;dscores = mlcontextns::backward(dprobs, scores, C);";
        Script script = new Script(string);
        script.in("dprobs", object).in("scores", object2).in("C", object3).out("dscores");
        MLResults mLResults = script.execute();
        Matrix matrix = mLResults.getMatrix("dscores");
        return matrix;
    }

    public String backward__docs() {
        String string = "backward = function(matrix[double] dprobs, matrix[double] scores, int C)\n    return (matrix[double] dscores) {\n  /*\n   * Computes the backward pass for a softmax2d classifier.\n   *\n   * Note that dscores_ij has multiple source branches:\n   *\n   *   ```\n   *   dprobs_ij/dscores_ij = probs_ij * (1 - probs_ij)\n   *   dprobs_ik/dscores_ij = -probs_ik * probs_ij, for all k != j\n   *\n   *   dloss/dscores_ij =\n   *      (dloss/dprobs_ij * dprobs_ij/dscores_ij)\n   *      + sum_{k!=j}(dloss/dprobs_ik * dprobs_ik/dscores_ij)\n   *   ```\n   *\n   * Inputs:\n   *  - dprobs: Gradient wrt `probs` from upstream, of shape (N, C*Hin*Win).\n   *  - scores: Inputs, of shape (N, C*Hin*Win).\n   *  - C: Number of input channels (dimensionality of input depth).\n   *\n   * Outputs:\n   *  - dscores: Gradient wrt `scores`, of shape (N, C*Win*Hin).\n   */\n";
        return string;
    }

    public String backward__source() {
        String string = "backward = function(matrix[double] dprobs, matrix[double] scores, int C)\n    return (matrix[double] dscores) {\n  /*\n   * Computes the backward pass for a softmax2d classifier.\n   *\n   * Note that dscores_ij has multiple source branches:\n   *\n   *   ```\n   *   dprobs_ij/dscores_ij = probs_ij * (1 - probs_ij)\n   *   dprobs_ik/dscores_ij = -probs_ik * probs_ij, for all k != j\n   *\n   *   dloss/dscores_ij =\n   *      (dloss/dprobs_ij * dprobs_ij/dscores_ij)\n   *      + sum_{k!=j}(dloss/dprobs_ik * dprobs_ik/dscores_ij)\n   *   ```\n   *\n   * Inputs:\n   *  - dprobs: Gradient wrt `probs` from upstream, of shape (N, C*Hin*Win).\n   *  - scores: Inputs, of shape (N, C*Hin*Win).\n   *  - C: Number of input channels (dimensionality of input depth).\n   *\n   * Outputs:\n   *  - dscores: Gradient wrt `scores`, of shape (N, C*Win*Hin).\n   */\n  N = nrow(scores)\n\n  #Transpose the matrix from (N, C*H*W) to (N*H*W, C)\n  dprobs_C_NHW = util::transpose_NCHW_to_CNHW(dprobs, C)\n  dprobs_NHW_C = t(dprobs_C_NHW)\n\n  #Transpose the matrix from (N, C*H*W) to (N*H*W, C)\n  scores_C_NHW = util::transpose_NCHW_to_CNHW(scores, C)\n  scores_NHW_C = t(scores_C_NHW)\n\n  dscores_NHW_C = softmax::backward(dprobs_NHW_C, scores_NHW_C)\n\n  #Transpose the matrix from (N*H*W, C) to (N, C*H*W)\n  dscores_C_NHW = t(dscores_NHW_C)\n  dscores = util::transpose_NCHW_to_CNHW(dscores_C_NHW, N)\n}\n";
        return string;
    }
}

