/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.cp;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.data.TensorBlock;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CPInstruction;
import org.apache.sysds.runtime.instructions.cp.CPOperand;

public class SqlCPInstruction
extends CPInstruction {
    private CPOperand _conn;
    private CPOperand _user;
    private CPOperand _pass;
    private CPOperand _query;
    private CPOperand _output;

    public SqlCPInstruction(CPOperand conn, CPOperand user, CPOperand pass, CPOperand query, CPOperand out, String opcode, String instr) {
        super(CPInstruction.CPType.Sql, opcode, instr);
        this._conn = conn;
        this._user = user;
        this._pass = pass;
        this._query = query;
        this._output = out;
    }

    public static SqlCPInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        if (parts.length != 6) {
            throw new DMLRuntimeException("Invalid number of operands in sql instruction: " + str);
        }
        CPOperand conn = new CPOperand(parts[1]);
        CPOperand user = new CPOperand(parts[2]);
        CPOperand pass = new CPOperand(parts[3]);
        CPOperand query = new CPOperand(parts[4]);
        CPOperand out = new CPOperand(parts[5]);
        return new SqlCPInstruction(conn, user, pass, query, out, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        String conn = ec.getScalarInput(this._conn).getStringValue();
        String user = ec.getScalarInput(this._user).getStringValue();
        String pass = ec.getScalarInput(this._pass).getStringValue();
        String query = ec.getScalarInput(this._query).getStringValue();
        try (Connection connection = user.isEmpty() ? DriverManager.getConnection(conn) : DriverManager.getConnection(conn, user, pass);){
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT COUNT(*) FROM (" + query + ") AS sub");
            resultSet.next();
            int rows = resultSet.getInt(1);
            resultSet = statement.executeQuery(query);
            ResultSetMetaData meta = resultSet.getMetaData();
            int cols = meta.getColumnCount();
            Types.ValueType[] schema = SqlCPInstruction.getSchemaFromMetaData(meta);
            int[] dims = new int[]{rows, cols};
            TensorBlock outBlock = new TensorBlock(schema, dims);
            int row = 0;
            while (resultSet.next()) {
                for (int i = 0; i < cols; ++i) {
                    SqlCPInstruction.setCell(outBlock, resultSet, schema[i], new int[]{row, i});
                }
                ++row;
            }
            ec.setTensorOutput(this._output.getName(), outBlock);
            ec.getDataCharacteristics(this._output.getName()).setDim(0, rows).setDim(1, cols);
        }
        catch (SQLException e) {
            throw new DMLRuntimeException("SQL Error: " + e.getMessage());
        }
    }

    private static void setCell(TensorBlock outBlock, ResultSet resultSet, Types.ValueType valueType, int[] ix) throws SQLException {
        int sqlCol = ix[1] + 1;
        switch (valueType) {
            case FP64: {
                outBlock.set(ix, resultSet.getDouble(sqlCol));
                break;
            }
            case FP32: {
                outBlock.set(ix, Float.valueOf(resultSet.getFloat(sqlCol)));
                break;
            }
            case INT64: {
                outBlock.set(ix, resultSet.getLong(sqlCol));
                break;
            }
            case INT32: {
                outBlock.set(ix, resultSet.getInt(sqlCol));
                break;
            }
            case BOOLEAN: {
                outBlock.set(ix, resultSet.getBoolean(sqlCol));
                break;
            }
            case STRING: {
                outBlock.set(ix, resultSet.getString(sqlCol));
                break;
            }
            default: {
                throw new DMLRuntimeException("Cell can not be set to valuetype " + valueType.name());
            }
        }
    }

    private static Types.ValueType[] getSchemaFromMetaData(ResultSetMetaData meta) throws SQLException {
        Types.ValueType[] schema = new Types.ValueType[meta.getColumnCount()];
        block7: for (int i = 0; i < meta.getColumnCount(); ++i) {
            int type = meta.getColumnType(i + 1);
            switch (type) {
                case 2: 
                case 3: 
                case 6: 
                case 8: {
                    schema[i] = Types.ValueType.FP64;
                    continue block7;
                }
                case 7: {
                    schema[i] = Types.ValueType.FP32;
                    continue block7;
                }
                case -5: {
                    schema[i] = Types.ValueType.INT64;
                    continue block7;
                }
                case -6: 
                case 4: 
                case 5: {
                    schema[i] = Types.ValueType.INT32;
                    continue block7;
                }
                case -7: {
                    schema[i] = Types.ValueType.BOOLEAN;
                    continue block7;
                }
                default: {
                    schema[i] = Types.ValueType.STRING;
                }
            }
        }
        return schema;
    }

    public String getOutputVariableName() {
        return this._output.getName();
    }

    public CPOperand getOutput() {
        return this._output;
    }
}

