/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.util;

import java.io.Serializable;

public class IndexRange
implements Serializable {
    private static final long serialVersionUID = 5746526303666494601L;
    public long rowStart = 0L;
    public long rowEnd = 0L;
    public long colStart = 0L;
    public long colEnd = 0L;

    public IndexRange(long rs, long re, long cs, long ce) {
        this.set(rs, re, cs, ce);
    }

    public void set(long rs, long re, long cs, long ce) {
        this.rowStart = rs;
        this.rowEnd = re;
        this.colStart = cs;
        this.colEnd = ce;
    }

    public boolean isScalar() {
        return this.rowStart == this.rowEnd && this.colStart == this.colEnd;
    }

    public IndexRange add(int delta) {
        return new IndexRange(this.rowStart + (long)delta, this.rowEnd + (long)delta, this.colStart + (long)delta, this.colEnd + (long)delta);
    }

    public boolean inColRange(long col) {
        return col >= this.colStart && col < this.colEnd;
    }

    public boolean inRowRange(long row) {
        return row >= this.rowStart && row < this.rowEnd;
    }

    public long colSpan() {
        return this.colEnd - this.colStart;
    }

    public long rowSpan() {
        return this.rowEnd - this.rowStart;
    }

    public String toString() {
        return "[" + this.rowStart + ":" + this.rowEnd + "," + this.colStart + ":" + this.colEnd + "]";
    }
}

