/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.gpu.context;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.LongAdder;
import java.util.stream.Collectors;
import jcuda.CudaException;
import jcuda.Pointer;
import jcuda.runtime.JCuda;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.instructions.gpu.context.CudaMemoryAllocator;
import org.apache.sysds.runtime.instructions.gpu.context.GPUContext;
import org.apache.sysds.runtime.instructions.gpu.context.GPUContextPool;
import org.apache.sysds.runtime.instructions.gpu.context.GPULazyCudaFreeMemoryManager;
import org.apache.sysds.runtime.instructions.gpu.context.GPUMatrixMemoryManager;
import org.apache.sysds.runtime.instructions.gpu.context.GPUMemoryAllocator;
import org.apache.sysds.runtime.instructions.gpu.context.GPUObject;
import org.apache.sysds.runtime.instructions.gpu.context.UnifiedMemoryAllocator;
import org.apache.sysds.runtime.lineage.LineageCacheConfig;
import org.apache.sysds.runtime.lineage.LineageCacheEntry;
import org.apache.sysds.runtime.lineage.LineageCacheStatistics;
import org.apache.sysds.runtime.lineage.LineageGPUCacheEviction;
import org.apache.sysds.utils.GPUStatistics;

public class GPUMemoryManager {
    protected static final Log LOG = LogFactory.getLog((String)GPUMemoryManager.class.getName());
    private static final boolean DEBUG_MEMORY_LEAK = false;
    private static final int[] DEBUG_MEMORY_LEAK_STACKTRACE_DEPTH = new int[]{5, 6, 7, 8, 9, 10};
    protected final GPUMemoryAllocator allocator;
    protected final GPUMatrixMemoryManager matrixMemoryManager;
    protected final GPULazyCudaFreeMemoryManager lazyCudaFreeMemoryManager;
    protected final HashMap<Pointer, PointerInfo> allPointers = new HashMap();
    private static final double WARN_UTILIZATION_FACTOR = 0.7;

    public GPUMatrixMemoryManager getGPUMatrixMemoryManager() {
        return this.matrixMemoryManager;
    }

    public GPULazyCudaFreeMemoryManager getGPULazyCudaFreeMemoryManager() {
        return this.lazyCudaFreeMemoryManager;
    }

    private Set<Pointer> getNonMatrixLockedPointers() {
        Set<Pointer> managedPointers = this.matrixMemoryManager.getPointers();
        managedPointers.addAll(this.lazyCudaFreeMemoryManager.getAllPointers());
        return GPUMemoryManager.nonIn(this.allPointers.keySet(), managedPointers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSizeAllocatedGPUPointer(Pointer ptr) {
        HashMap<Pointer, PointerInfo> hashMap = this.allPointers;
        synchronized (hashMap) {
            if (this.allPointers.containsKey(ptr)) {
                return this.allPointers.get(ptr).getSizeInBytes();
            }
        }
        return -1L;
    }

    public GPUMemoryManager(GPUContext gpuCtx) {
        this.matrixMemoryManager = new GPUMatrixMemoryManager(this);
        this.lazyCudaFreeMemoryManager = new GPULazyCudaFreeMemoryManager(this);
        if (DMLScript.GPU_MEMORY_ALLOCATOR.equals("cuda")) {
            this.allocator = new CudaMemoryAllocator();
        } else if (DMLScript.GPU_MEMORY_ALLOCATOR.equals("unified_memory")) {
            this.allocator = new UnifiedMemoryAllocator();
        } else {
            throw new RuntimeException("Unsupported value (" + DMLScript.GPU_MEMORY_ALLOCATOR + ") for the configuration " + "sysds.gpu.memory.allocator" + ". Supported values are cuda, unified_memory.");
        }
        long[] free = new long[]{0L};
        long[] total = new long[]{0L};
        JCuda.cudaMemGetInfo((long[])free, (long[])total);
        if ((double)free[0] < 0.7 * (double)total[0]) {
            LOG.warn((Object)("Potential under-utilization: GPU memory - Total: " + (double)total[0] * 1.0E-6 + " MB, Available: " + (double)free[0] * 1.0E-6 + " MB on " + gpuCtx + ". This can happen if there are other processes running on the GPU at the same time."));
        } else {
            LOG.info((Object)("GPU memory - Total: " + (double)total[0] * 1.0E-6 + " MB, Available: " + (double)free[0] * 1.0E-6 + " MB on " + gpuCtx));
        }
        if ((double)GPUContextPool.initialGPUMemBudget() > OptimizerUtils.getLocalMemBudget()) {
            LOG.warn((Object)("Potential under-utilization: GPU memory (" + GPUContextPool.initialGPUMemBudget() + ") > driver memory budget (" + OptimizerUtils.getLocalMemBudget() + "). Consider increasing the driver memory budget."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pointer cudaMallocNoWarn(Pointer A, long size, String printDebugMessage) {
        long t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
        try {
            this.allocator.allocate(A, size);
            HashMap<Pointer, PointerInfo> hashMap = this.allPointers;
            synchronized (hashMap) {
                this.allPointers.put(A, new PointerInfo(size));
            }
            if (DMLScript.STATISTICS) {
                long totalTime = System.nanoTime() - t0;
                GPUStatistics.cudaAllocSuccessTime.add(totalTime);
                GPUStatistics.cudaAllocSuccessCount.increment();
                GPUStatistics.cudaAllocTime.add(totalTime);
                GPUStatistics.cudaAllocCount.increment();
            }
            if (printDebugMessage != null && (DMLScript.PRINT_GPU_MEMORY_INFO || LOG.isTraceEnabled())) {
                LOG.info((Object)("Success: " + printDebugMessage + ":" + GPUMemoryManager.byteCountToDisplaySize(size)));
            }
            return A;
        }
        catch (CudaException e) {
            if (DMLScript.STATISTICS) {
                long totalTime = System.nanoTime() - t0;
                GPUStatistics.cudaAllocFailedTime.add(System.nanoTime() - t0);
                GPUStatistics.cudaAllocFailedCount.increment();
                GPUStatistics.cudaAllocTime.add(totalTime);
                GPUStatistics.cudaAllocCount.increment();
            }
            if (printDebugMessage != null && (DMLScript.PRINT_GPU_MEMORY_INFO || LOG.isTraceEnabled())) {
                LOG.info((Object)("Failed: " + printDebugMessage + ":" + GPUMemoryManager.byteCountToDisplaySize(size)));
                LOG.info((Object)("GPU Memory info " + printDebugMessage + ":" + this.toString()));
            }
            return null;
        }
    }

    private static String getCallerInfo(StackTraceElement[] stackTrace, int index) {
        if (stackTrace.length <= index) {
            return "->";
        }
        return "->" + stackTrace[index].getClassName() + "." + stackTrace[index].getMethodName() + "(" + stackTrace[index].getFileName() + ":" + stackTrace[index].getLineNumber() + ")";
    }

    private static String byteCountToDisplaySize(long numBytes) {
        if (numBytes < 1024L) {
            return numBytes + " bytes";
        }
        int exp = (int)(Math.log(numBytes) / 6.931471805599453);
        return String.format("%.3f %sB", (double)numBytes / Math.pow(1024.0, exp), Character.valueOf("KMGTP".charAt(exp - 1)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pointer malloc(String opcode, long size) {
        Object le;
        long t0;
        Pointer tmpA;
        if (size < 0L) {
            throw new DMLRuntimeException("Cannot allocate memory of size " + GPUMemoryManager.byteCountToDisplaySize(size));
        }
        Pointer A = this.lazyCudaFreeMemoryManager.getRmvarPointer(opcode, size);
        Pointer pointer = tmpA = A == null ? new Pointer() : null;
        if (A == null && this.allocator.canAllocate(size)) {
            A = this.cudaMallocNoWarn(tmpA, size, "allocate a new pointer");
        }
        if (A == null && (A = this.lazyCudaFreeMemoryManager.getRmvarPointerMinSize(opcode, size)) != null) {
            this.guardedCudaFree(A);
            A = this.cudaMallocNoWarn(tmpA, size, "reuse non-exact match of rmvarGPUPointers");
            if (A == null) {
                LOG.warn((Object)"cudaMalloc failed after clearing one of rmvarGPUPointers.");
            }
        }
        if (A == null) {
            this.lazyCudaFreeMemoryManager.clearAll();
            if (this.allocator.canAllocate(size)) {
                A = this.cudaMallocNoWarn(tmpA, size, "allocate a new pointer after eager free");
            }
        }
        if (A == null) {
            t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
            HashSet<GPUObject> hashSet = this.matrixMemoryManager.gpuObjects;
            synchronized (hashSet) {
                Optional<GPUObject> sizeBasedUnlockedGPUObjects = this.matrixMemoryManager.gpuObjects.stream().filter(gpuObj -> !gpuObj.isLocked() && !gpuObj.isLinCached() && this.matrixMemoryManager.getWorstCaseContiguousMemorySize((GPUObject)gpuObj) >= size).min((o1, o2) -> this.worstCaseContiguousMemorySizeCompare((GPUObject)o1, (GPUObject)o2));
                if (sizeBasedUnlockedGPUObjects.isPresent()) {
                    GPUMemoryManager.evictOrClear(sizeBasedUnlockedGPUObjects.get(), opcode);
                    A = this.cudaMallocNoWarn(tmpA, size, null);
                    if (A == null) {
                        LOG.warn((Object)"cudaMalloc failed after clearing/evicting based on size.");
                    }
                    if (DMLScript.STATISTICS) {
                        long totalTime = System.nanoTime() - t0;
                        GPUStatistics.cudaEvictTime.add(totalTime);
                        GPUStatistics.cudaEvictSizeTime.add(totalTime);
                        GPUStatistics.cudaEvictCount.increment();
                        GPUStatistics.cudaEvictSizeCount.increment();
                    }
                }
            }
        }
        if (A == null && !LineageCacheConfig.ReuseCacheType.isNone()) {
            long t02;
            long currentAvailableMemory = this.allocator.getAvailableMemory();
            ArrayList<LineageCacheEntry> lockedEntries = new ArrayList<LineageCacheEntry>();
            long l = t02 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
            while (A == null && !LineageGPUCacheEviction.isGPUCacheEmpty()) {
                le = LineageGPUCacheEviction.pollFirstEntry();
                GPUObject cachedGpuObj = ((LineageCacheEntry)le).getGPUObject();
                GPUObject headGpuObj = cachedGpuObj.lineageCachedChainHead != null ? cachedGpuObj.lineageCachedChainHead : cachedGpuObj;
                boolean locked = false;
                GPUObject nextgpuObj = headGpuObj;
                while (nextgpuObj != null) {
                    if (nextgpuObj.isLocked()) {
                        locked = true;
                    }
                    nextgpuObj = nextgpuObj.nextLineageCachedEntry;
                }
                if (locked) {
                    lockedEntries.add((LineageCacheEntry)le);
                    continue;
                }
                currentAvailableMemory += headGpuObj.getSizeOnDevice();
                boolean copied = false;
                nextgpuObj = headGpuObj;
                while (nextgpuObj != null) {
                    if (!nextgpuObj.isrmVarPending() && nextgpuObj.isDirty()) {
                        nextgpuObj.copyFromDeviceToHost(opcode, true, true);
                        copied = true;
                    }
                    nextgpuObj.setIsLinCached(false);
                    nextgpuObj = nextgpuObj.nextLineageCachedEntry;
                }
                LineageGPUCacheEviction.copyToHostCache((LineageCacheEntry)le, opcode, copied);
                if (DMLScript.STATISTICS) {
                    LineageCacheStatistics.incrementGpuSyncEvicts();
                }
                nextgpuObj = headGpuObj;
                boolean freed = false;
                while (nextgpuObj != null) {
                    if (nextgpuObj.isrmVarPending() || !nextgpuObj.isDirty()) {
                        if (!freed) {
                            nextgpuObj.clearData(opcode, true);
                            freed = true;
                        } else {
                            nextgpuObj.clearGPUObject();
                        }
                    }
                    nextgpuObj = nextgpuObj.nextLineageCachedEntry;
                }
                GPUObject currgpuObj = headGpuObj;
                while (currgpuObj.nextLineageCachedEntry != null) {
                    nextgpuObj = currgpuObj.nextLineageCachedEntry;
                    currgpuObj.lineageCachedChainHead = null;
                    currgpuObj.nextLineageCachedEntry = null;
                    nextgpuObj.lineageCachedChainHead = null;
                    currgpuObj = nextgpuObj;
                }
                if (currentAvailableMemory < size) continue;
                A = this.cudaMallocNoWarn(tmpA, size, null);
            }
            if (!lockedEntries.isEmpty()) {
                LineageGPUCacheEviction.addEntryList(lockedEntries);
            }
            if (DMLScript.STATISTICS) {
                GPUStatistics.cudaEvictTime.add(System.nanoTime() - t02);
            }
            if (A == null) {
                LOG.warn((Object)"cudaMalloc failed after Lineage GPU cache eviction.");
            }
        }
        if (A == null) {
            t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
            long currentAvailableMemory = this.allocator.getAvailableMemory();
            boolean canFit = false;
            le = this.matrixMemoryManager.gpuObjects;
            synchronized (le) {
                List unlockedGPUObjects = this.matrixMemoryManager.gpuObjects.stream().filter(gpuObj -> !gpuObj.isLocked() && !gpuObj.isLinCached()).collect(Collectors.toList());
                Collections.sort(unlockedGPUObjects, new EvictionPolicyBasedComparator(size));
                while (A == null && unlockedGPUObjects.size() > 0) {
                    GPUObject evictedGPUObject = (GPUObject)unlockedGPUObjects.remove(unlockedGPUObjects.size() - 1);
                    GPUMemoryManager.evictOrClear(evictedGPUObject, opcode);
                    if (!canFit && (currentAvailableMemory += evictedGPUObject.getSizeOnDevice()) >= size) {
                        canFit = true;
                    }
                    if (canFit) {
                        A = this.cudaMallocNoWarn(tmpA, size, null);
                    }
                    if (!DMLScript.STATISTICS) continue;
                    GPUStatistics.cudaEvictCount.increment();
                }
            }
            if (DMLScript.STATISTICS) {
                long totalTime = System.nanoTime() - t0;
                GPUStatistics.cudaEvictTime.add(totalTime);
            }
        }
        if (A == null) {
            LOG.warn((Object)"Potential fragmentation of the GPU memory. Forcibly evicting all ...");
            LOG.info((Object)("Before clearAllUnlocked, GPU Memory info:" + this.toString()));
            this.matrixMemoryManager.clearAllUnlocked(opcode);
            LOG.info((Object)("GPU Memory info after evicting all unlocked matrices:" + this.toString()));
            A = this.cudaMallocNoWarn(tmpA, size, null);
        }
        if (A == null) {
            throw new DMLRuntimeException("There is not enough memory on device for this matrix, requested = " + GPUMemoryManager.byteCountToDisplaySize(size) + ". \n " + this.toString());
        }
        t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
        JCuda.cudaMemset((Pointer)A, (int)0, (long)size);
        GPUMemoryManager.addMiscTime(opcode, GPUStatistics.cudaMemSet0Time, GPUStatistics.cudaMemSet0Count, "az", t0);
        return A;
    }

    private int worstCaseContiguousMemorySizeCompare(GPUObject o1, GPUObject o2) {
        long ret = this.matrixMemoryManager.getWorstCaseContiguousMemorySize(o1) - this.matrixMemoryManager.getWorstCaseContiguousMemorySize(o2);
        return ret < 0L ? -1 : (ret == 0L ? 0 : 1);
    }

    private static void evictOrClear(GPUObject gpuObj, String opcode) {
        boolean eagerDelete = true;
        if (gpuObj.isDirty()) {
            gpuObj.copyFromDeviceToHost(opcode, true, eagerDelete);
        } else {
            gpuObj.clearData(opcode, eagerDelete);
        }
    }

    private void printPointers(Set<Pointer> pointers, StringBuilder sb) {
        HashMap<String, Integer> frequency = new HashMap<String, Integer>();
        for (Pointer pointer : pointers) {
            PointerInfo ptrInfo = this.allPointers.get(pointer);
            String key = "";
            for (int index : DEBUG_MEMORY_LEAK_STACKTRACE_DEPTH) {
                key = key + GPUMemoryManager.getCallerInfo(ptrInfo.stackTraceElements, index);
            }
            if (frequency.containsKey(key)) {
                frequency.put(key, (Integer)frequency.get(key) + 1);
                continue;
            }
            frequency.put(key, 1);
        }
        for (Map.Entry entry : frequency.entrySet()) {
            sb.append(">>" + (String)entry.getKey() + " => " + entry.getValue() + "\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void guardedCudaFree(Pointer toFree) {
        HashMap<Pointer, PointerInfo> hashMap = this.allPointers;
        synchronized (hashMap) {
            if (this.allPointers.containsKey(toFree)) {
                long size = this.allPointers.get(toFree).getSizeInBytes();
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Free-ing up the pointer of size " + GPUMemoryManager.byteCountToDisplaySize(size)));
                }
                this.allPointers.remove(toFree);
                this.lazyCudaFreeMemoryManager.removeIfPresent(size, toFree);
                this.allocator.free(toFree);
                if (DMLScript.SYNCHRONIZE_GPU) {
                    JCuda.cudaDeviceSynchronize();
                }
            } else {
                throw new RuntimeException("Attempting to free an unaccounted pointer:" + toFree);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void free(String opcode, Pointer toFree, boolean eager) throws DMLRuntimeException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Free-ing the pointer with eager=" + eager));
        }
        if (eager) {
            long t0 = DMLScript.STATISTICS ? System.nanoTime() : 0L;
            this.guardedCudaFree(toFree);
            GPUMemoryManager.addMiscTime(opcode, GPUStatistics.cudaDeAllocTime, GPUStatistics.cudaDeAllocCount, "f", t0);
        } else {
            long size = 0L;
            HashMap<Pointer, PointerInfo> hashMap = this.allPointers;
            synchronized (hashMap) {
                if (!this.allPointers.containsKey(toFree)) {
                    LOG.info((Object)("GPU memory info before failure:" + this.toString()));
                    throw new RuntimeException("ERROR : Internal state corrupted, cache block size map is not aware of a block it trying to free up");
                }
                size = this.allPointers.get(toFree).getSizeInBytes();
            }
            this.lazyCudaFreeMemoryManager.add(size, toFree);
        }
    }

    public void removeGPUObject(GPUObject gpuObj) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Removing the GPU object: " + gpuObj));
        }
        if (gpuObj.mat.getGPUObject(gpuObj.getGPUContext()) == gpuObj) {
            gpuObj.mat.removeGPUObject(gpuObj.getGPUContext());
        }
        this.matrixMemoryManager.gpuObjects.remove(gpuObj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearMemory() {
        for (GPUObject gpuObj : this.matrixMemoryManager.gpuObjects) {
            if (gpuObj.isDirty()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Attempted to free GPU Memory when a block[" + gpuObj + "] is still on GPU memory, copying it back to host."));
                }
                gpuObj.copyFromDeviceToHost(null, true, true);
                continue;
            }
            gpuObj.clearData(null, true);
        }
        this.matrixMemoryManager.gpuObjects.clear();
        HashMap<Pointer, PointerInfo> hashMap = this.allPointers;
        synchronized (hashMap) {
            HashSet<Pointer> remainingPtr = new HashSet<Pointer>(this.allPointers.keySet());
            for (Pointer toFree : remainingPtr) {
                this.guardedCudaFree(toFree);
            }
            this.allPointers.clear();
        }
    }

    private static Set<Pointer> nonIn(Set<Pointer> superset, Set<Pointer> subset) {
        HashSet<Pointer> ret = new HashSet<Pointer>();
        for (Pointer superPtr : superset) {
            if (subset.contains(superPtr)) continue;
            ret.add(superPtr);
        }
        return ret;
    }

    public void clearTemporaryMemory() {
        Set<Pointer> unlockedDirtyOrCachedPointers = this.matrixMemoryManager.getPointers(false, true, true);
        Set<Pointer> temporaryPointers = GPUMemoryManager.nonIn(this.allPointers.keySet(), unlockedDirtyOrCachedPointers);
        for (Pointer tmpPtr : temporaryPointers) {
            this.guardedCudaFree(tmpPtr);
        }
    }

    private static void addMiscTime(String opcode, LongAdder globalGPUTimer, LongAdder globalGPUCounter, String instructionLevelTimer, long startTime) {
        if (DMLScript.STATISTICS) {
            long totalTime = System.nanoTime() - startTime;
            globalGPUTimer.add(totalTime);
            globalGPUCounter.add(1L);
        }
    }

    public String toString() {
        long sizeOfLockedGPUObjects = 0L;
        int numLockedGPUObjects = 0;
        int numLockedPointers = 0;
        long sizeOfUnlockedDirtyGPUObjects = 0L;
        int numUnlockedDirtyGPUObjects = 0;
        int numUnlockedDirtyPointers = 0;
        long sizeOfUnlockedNonDirtyGPUObjects = 0L;
        int numUnlockedNonDirtyGPUObjects = 0;
        int numUnlockedNonDirtyPointers = 0;
        long sizeOfLockedCachedGPUObjects = 0L;
        int numLockedCachedGPUObjects = 0;
        int numLockedCachedPointers = 0;
        long sizeOfUnlockedCachedGPUObjects = 0L;
        int numUnlockedCachedGPUObjects = 0;
        int numUnlockedCachedPointers = 0;
        for (GPUObject gpuObj : this.matrixMemoryManager.gpuObjects) {
            if (gpuObj.isLocked()) {
                ++numLockedGPUObjects;
                sizeOfLockedGPUObjects += gpuObj.getSizeOnDevice();
                numLockedPointers += this.matrixMemoryManager.getPointers(gpuObj).size();
                if (!gpuObj.isLinCached()) continue;
                ++numLockedCachedGPUObjects;
                sizeOfLockedCachedGPUObjects += gpuObj.getSizeOnDevice();
                numLockedCachedPointers += this.matrixMemoryManager.getPointers(gpuObj).size();
                continue;
            }
            if (gpuObj.isDirty()) {
                ++numUnlockedDirtyGPUObjects;
                sizeOfUnlockedDirtyGPUObjects += gpuObj.getSizeOnDevice();
                numUnlockedDirtyPointers += this.matrixMemoryManager.getPointers(gpuObj).size();
            } else {
                ++numUnlockedNonDirtyGPUObjects;
                sizeOfUnlockedNonDirtyGPUObjects += gpuObj.getSizeOnDevice();
                numUnlockedNonDirtyPointers += this.matrixMemoryManager.getPointers(gpuObj).size();
            }
            if (!gpuObj.isLinCached()) continue;
            ++numUnlockedCachedGPUObjects;
            sizeOfUnlockedCachedGPUObjects += gpuObj.getSizeOnDevice();
            numUnlockedCachedPointers += this.matrixMemoryManager.getPointers(gpuObj).size();
        }
        long totalMemoryAllocated = 0L;
        for (PointerInfo ptrInfo : this.allPointers.values()) {
            totalMemoryAllocated += ptrInfo.getSizeInBytes();
        }
        Set<Pointer> potentiallyLeakyPointers = this.getNonMatrixLockedPointers();
        List sizePotentiallyLeakyPointers = potentiallyLeakyPointers.stream().map(ptr -> this.allPointers.get(ptr).sizeInBytes).collect(Collectors.toList());
        long totalSizePotentiallyLeakyPointers = 0L;
        Iterator iterator = sizePotentiallyLeakyPointers.iterator();
        while (iterator.hasNext()) {
            long size = (Long)iterator.next();
            totalSizePotentiallyLeakyPointers += size;
        }
        StringBuilder ret = new StringBuilder();
        ret.append("\n====================================================\n");
        ret.append(String.format("%-35s%-15s%-15s%-15s\n", "", "Num Objects", "Num Pointers", "Size"));
        ret.append(String.format("%-35s%-15s%-15s%-15s\n", "Unlocked Dirty GPU objects", numUnlockedDirtyGPUObjects, numUnlockedDirtyPointers, GPUMemoryManager.byteCountToDisplaySize(sizeOfUnlockedDirtyGPUObjects)));
        ret.append(String.format("%-35s%-15s%-15s%-15s\n", "Unlocked NonDirty GPU objects", numUnlockedNonDirtyGPUObjects, numUnlockedNonDirtyPointers, GPUMemoryManager.byteCountToDisplaySize(sizeOfUnlockedNonDirtyGPUObjects)));
        ret.append(String.format("%-35s%-15s%-15s%-15s\n", "Locked GPU objects", numLockedGPUObjects, numLockedPointers, GPUMemoryManager.byteCountToDisplaySize(sizeOfLockedGPUObjects)));
        ret.append(String.format("%-35s%-15s%-15s%-15s\n", "Locked Cached GPU objects", numLockedCachedGPUObjects, numLockedCachedPointers, GPUMemoryManager.byteCountToDisplaySize(sizeOfLockedCachedGPUObjects)));
        ret.append(String.format("%-35s%-15s%-15s%-15s\n", "Unlocked Cached GPU objects", numUnlockedCachedGPUObjects, numUnlockedCachedPointers, GPUMemoryManager.byteCountToDisplaySize(sizeOfUnlockedCachedGPUObjects)));
        ret.append(String.format("%-35s%-15s%-15s%-15s\n", "Cached rmvar-ed pointers", "-", this.lazyCudaFreeMemoryManager.getNumPointers(), GPUMemoryManager.byteCountToDisplaySize(this.lazyCudaFreeMemoryManager.getTotalMemoryAllocated())));
        ret.append(String.format("%-35s%-15s%-15s%-15s\n", "Non-matrix/non-cached pointers", "-", potentiallyLeakyPointers.size(), GPUMemoryManager.byteCountToDisplaySize(totalSizePotentiallyLeakyPointers)));
        ret.append(String.format("%-35s%-15s%-15s%-15s\n", "All pointers", "-", this.allPointers.size(), GPUMemoryManager.byteCountToDisplaySize(totalMemoryAllocated)));
        long[] free = new long[]{0L};
        long[] total = new long[]{0L};
        JCuda.cudaMemGetInfo((long[])free, (long[])total);
        ret.append(String.format("%-35s%-15s%-15s%-15s\n", "Free mem (from cudaMemGetInfo)", "-", "-", GPUMemoryManager.byteCountToDisplaySize(free[0])));
        ret.append(String.format("%-35s%-15s%-15s%-15s\n", "Total mem (from cudaMemGetInfo)", "-", "-", GPUMemoryManager.byteCountToDisplaySize(total[0])));
        ret.append("====================================================\n");
        return ret.toString();
    }

    public static class EvictionPolicyBasedComparator
    implements Comparator<GPUObject> {
        public EvictionPolicyBasedComparator(long neededSize) {
        }

        @Override
        public int compare(GPUObject p1, GPUObject p2) {
            if (p1.isLocked() && p2.isLocked()) {
                return 0;
            }
            if (p1.isLocked()) {
                return -1;
            }
            if (p2.isLocked()) {
                return 1;
            }
            return Long.compare(p2.timestamp.get(), p1.timestamp.get());
        }
    }

    static class PointerInfo {
        private long sizeInBytes;
        private StackTraceElement[] stackTraceElements;

        public PointerInfo(long sizeInBytes) {
            this.sizeInBytes = sizeInBytes;
        }

        public long getSizeInBytes() {
            return this.sizeInBytes;
        }
    }
}

