/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.utils;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.util.UtilFunctions;

public class Util {
    protected static final Log LOG = LogFactory.getLog((String)Util.class.getName());

    public static int[] join(int[] lhs, int[] rhs) {
        int[] joined = new int[lhs.length + rhs.length];
        int lp = 0;
        int rp = 0;
        for (int i = 0; i < joined.length && lp < lhs.length && rp < rhs.length; ++i) {
            joined[i] = lhs[lp] < rhs[rp] ? lhs[lp++] : rhs[rp++];
        }
        while (lp < lhs.length) {
            joined[i++] = lhs[lp++];
        }
        while (rp < rhs.length) {
            joined[i++] = rhs[rp++];
        }
        return joined;
    }

    public static int getPow2(int x) {
        int v = UtilFunctions.nextIntPow2(x + 1);
        return Math.max(v, 4);
    }
}

