/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.io;

import java.io.Serializable;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.io.FileFormatProperties;

public class FileFormatPropertiesCSV
extends FileFormatProperties
implements Serializable {
    protected static final Log LOG = LogFactory.getLog((String)FileFormatPropertiesCSV.class.getName());
    private static final long serialVersionUID = -2870393360885401604L;
    private boolean header = false;
    private String delim = ",";
    private boolean fill = true;
    private double fillValue = 0.0;
    private HashSet<String> naStrings;
    private boolean sparse = false;

    public FileFormatPropertiesCSV() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("FileFormatPropertiesCSV: " + this.toString()));
        }
    }

    public FileFormatPropertiesCSV(boolean hasHeader, String delim, boolean fill, double fillValue, String naStrings) {
        this();
        this.header = hasHeader;
        this.delim = delim;
        this.fill = fill;
        this.fillValue = fillValue;
        String[] naS = naStrings.split("\u00b7");
        if (!(naS.length <= 0 || naS.length == 1 && naS[0].isEmpty())) {
            this.naStrings = new HashSet();
            for (String s : naS) {
                this.naStrings.add(s);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("FileFormatPropertiesCSV full settings: " + this.toString()));
        }
    }

    public FileFormatPropertiesCSV(boolean hasHeader, String delim, boolean sparse) {
        this();
        this.header = hasHeader;
        this.delim = delim;
        this.sparse = sparse;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("FileFormatPropertiesCSV medium settings: " + this.toString()));
        }
    }

    public boolean hasHeader() {
        return this.header;
    }

    public void setHeader(boolean hasHeader) {
        this.header = hasHeader;
    }

    public String getDelim() {
        return this.delim;
    }

    public void setNAStrings(HashSet<String> naStrings) {
        this.naStrings = naStrings;
    }

    public HashSet<String> getNAStrings() {
        return this.naStrings;
    }

    public void setDelim(String delim) {
        this.delim = delim;
    }

    public boolean isFill() {
        return this.fill;
    }

    public void setFill(boolean fill) {
        this.fill = fill;
    }

    public double getFillValue() {
        return this.fillValue;
    }

    public void setFillValue(double fillValue) {
        this.fillValue = fillValue;
    }

    public boolean isSparse() {
        return this.sparse;
    }

    public void setSparse(boolean sparse) {
        this.sparse = sparse;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("header " + this.header);
        sb.append(" delim " + this.delim);
        sb.append(" fill " + this.fill);
        sb.append(" fillValue " + this.fillValue);
        sb.append(" naStrings " + this.naStrings);
        return sb.toString();
    }
}

