/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.NotImplementedException;
import org.apache.sysds.common.Builtins;
import org.apache.sysds.common.Types;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.parser.BooleanIdentifier;
import org.apache.sysds.parser.ConstIdentifier;
import org.apache.sysds.parser.DataIdentifier;
import org.apache.sysds.parser.DoubleIdentifier;
import org.apache.sysds.parser.Expression;
import org.apache.sysds.parser.ExpressionList;
import org.apache.sysds.parser.FunctionCallIdentifier;
import org.apache.sysds.parser.Identifier;
import org.apache.sysds.parser.IndexedIdentifier;
import org.apache.sysds.parser.IntIdentifier;
import org.apache.sysds.parser.LanguageException;
import org.apache.sysds.parser.MultiAssignmentStatement;
import org.apache.sysds.parser.ParameterExpression;
import org.apache.sysds.parser.ParseInfo;
import org.apache.sysds.parser.VariableSet;
import org.apache.sysds.runtime.meta.MatrixCharacteristics;
import org.apache.sysds.runtime.util.DnnUtils;
import org.apache.sysds.runtime.util.UtilFunctions;

public class BuiltinFunctionExpression
extends DataIdentifier {
    protected Expression[] _args = null;
    private Builtins _opcode;

    public BuiltinFunctionExpression(ParserRuleContext ctx, Builtins bifop, ArrayList<ParameterExpression> args, String fname) {
        this._opcode = bifop;
        this.setCtxValuesAndFilename(ctx, fname);
        args = this.expandDnnArguments(args);
        this._args = new Expression[args.size()];
        for (int i = 0; i < args.size(); ++i) {
            this._args[i] = args.get(i).getExpr();
        }
    }

    public BuiltinFunctionExpression(Builtins bifop, Expression[] args, ParseInfo parseInfo) {
        this._opcode = bifop;
        this._args = new Expression[args.length];
        for (int i = 0; i < args.length; ++i) {
            this._args[i] = args[i];
        }
        this.setParseInfo(parseInfo);
    }

    public BuiltinFunctionExpression(ParserRuleContext ctx, Builtins bifop, Expression[] args, String fname) {
        this._opcode = bifop;
        this._args = new Expression[args.length];
        for (int i = 0; i < args.length; ++i) {
            this._args[i] = args[i];
        }
        this.setCtxValuesAndFilename(ctx, fname);
    }

    @Override
    public Expression rewriteExpression(String prefix) {
        Expression[] newArgs = new Expression[this._args.length];
        for (int i = 0; i < this._args.length; ++i) {
            newArgs[i] = this._args[i].rewriteExpression(prefix);
        }
        BuiltinFunctionExpression retVal = new BuiltinFunctionExpression(this._opcode, newArgs, this);
        return retVal;
    }

    public Builtins getOpCode() {
        return this._opcode;
    }

    public Expression getFirstExpr() {
        return this._args.length >= 1 ? this._args[0] : null;
    }

    public Expression getSecondExpr() {
        return this._args.length >= 2 ? this._args[1] : null;
    }

    public Expression getThirdExpr() {
        return this._args.length >= 3 ? this._args[2] : null;
    }

    public Expression getFourthExpr() {
        return this._args.length >= 4 ? this._args[3] : null;
    }

    public Expression getFifthExpr() {
        return this._args.length >= 5 ? this._args[4] : null;
    }

    public Expression getSixthExpr() {
        return this._args.length >= 6 ? this._args[5] : null;
    }

    public Expression getSeventhExpr() {
        return this._args.length >= 7 ? this._args[6] : null;
    }

    public Expression getEighthExpr() {
        return this._args.length >= 8 ? this._args[7] : null;
    }

    public Expression[] getAllExpr() {
        return this._args;
    }

    public Expression getExpr(int i) {
        return this._args.length > i ? this._args[i] : null;
    }

    @Override
    public void validateExpression(MultiAssignmentStatement stmt, HashMap<String, DataIdentifier> ids, HashMap<String, ConstIdentifier> constVars, boolean conditional) {
        if (this.getFirstExpr() instanceof FunctionCallIdentifier) {
            this.raiseValidateError("UDF function call not supported as parameter to built-in function call", false);
        }
        this.getFirstExpr().validateExpression(ids, constVars, conditional);
        Expression[] expr = this.getAllExpr();
        if (expr != null && expr.length > 1) {
            for (int i = 1; i < expr.length; ++i) {
                if (expr[i] instanceof FunctionCallIdentifier) {
                    this.raiseValidateError("UDF function call not supported as parameter to built-in function call", false);
                }
                expr[i].validateExpression(ids, constVars, conditional);
            }
        }
        this._outputs = new Identifier[stmt.getTargetList().size()];
        int count = 0;
        for (DataIdentifier outParam : stmt.getTargetList()) {
            DataIdentifier tmp = new DataIdentifier(outParam);
            tmp.setParseInfo(this);
            this._outputs[count++] = tmp;
        }
        switch (this._opcode) {
            case QR: {
                this.checkNumParameters(1);
                this.checkMatrixParam(this.getFirstExpr());
                DataIdentifier qrOut1 = (DataIdentifier)this.getOutputs()[0];
                DataIdentifier qrOut2 = (DataIdentifier)this.getOutputs()[1];
                long rows = this.getFirstExpr().getOutput().getDim1();
                long cols = this.getFirstExpr().getOutput().getDim2();
                qrOut1.setDataType(Types.DataType.MATRIX);
                qrOut1.setValueType(Types.ValueType.FP64);
                qrOut1.setDimensions(rows, cols);
                qrOut1.setBlocksize(this.getFirstExpr().getOutput().getBlocksize());
                qrOut2.setDataType(Types.DataType.MATRIX);
                qrOut2.setValueType(Types.ValueType.FP64);
                qrOut2.setDimensions(rows, cols);
                qrOut2.setBlocksize(this.getFirstExpr().getOutput().getBlocksize());
                break;
            }
            case LU: {
                this.checkNumParameters(1);
                this.checkMatrixParam(this.getFirstExpr());
                DataIdentifier luOut1 = (DataIdentifier)this.getOutputs()[0];
                DataIdentifier luOut2 = (DataIdentifier)this.getOutputs()[1];
                DataIdentifier luOut3 = (DataIdentifier)this.getOutputs()[2];
                long inrows = this.getFirstExpr().getOutput().getDim1();
                long incols = this.getFirstExpr().getOutput().getDim2();
                if (inrows != incols) {
                    this.raiseValidateError("LU Decomposition requires a square matrix. Matrix " + this.getFirstExpr() + " is " + inrows + "x" + incols + ".", conditional);
                }
                luOut1.setDataType(Types.DataType.MATRIX);
                luOut1.setValueType(Types.ValueType.FP64);
                luOut1.setDimensions(inrows, inrows);
                luOut1.setBlocksize(this.getFirstExpr().getOutput().getBlocksize());
                luOut2.setDataType(Types.DataType.MATRIX);
                luOut2.setValueType(Types.ValueType.FP64);
                luOut2.setDimensions(inrows, inrows);
                luOut2.setBlocksize(this.getFirstExpr().getOutput().getBlocksize());
                luOut3.setDataType(Types.DataType.MATRIX);
                luOut3.setValueType(Types.ValueType.FP64);
                luOut3.setDimensions(inrows, inrows);
                luOut3.setBlocksize(this.getFirstExpr().getOutput().getBlocksize());
                break;
            }
            case LSTM: {
                this.checkNumParameters(6);
                this.checkMatrixParam(this.getFirstExpr());
                this.checkMatrixParam(this.getSecondExpr());
                this.checkMatrixParam(this.getThirdExpr());
                this.checkMatrixParam(this.getFourthExpr());
                this.checkMatrixParam(this.getFifthExpr());
                if (this.getOutputs() == null || this.getOutputs().length != 2) {
                    int numOutputs = this.getOutputs() == null ? 0 : this.getOutputs().length;
                    this.raiseValidateError("The builtin function lstm has two outputs, but instead found: " + numOutputs, conditional);
                }
                DataIdentifier out = (DataIdentifier)this.getOutputs()[0];
                DataIdentifier cy = (DataIdentifier)this.getOutputs()[1];
                out.setDataType(Types.DataType.MATRIX);
                out.setValueType(Types.ValueType.FP64);
                out.setDimensions(-1L, -1L);
                out.setBlocksize(this.getFirstExpr().getOutput().getBlocksize());
                cy.setDataType(Types.DataType.MATRIX);
                cy.setValueType(Types.ValueType.FP64);
                cy.setDimensions(this.getExpr(4).getOutput().getDim1(), this.getExpr(4).getOutput().getDim2());
                cy.setBlocksize(this.getExpr(4).getOutput().getBlocksize());
                break;
            }
            case LSTM_BACKWARD: {
                this.checkNumParameters(8);
                this.checkMatrixParam(this.getFirstExpr());
                this.checkMatrixParam(this.getSecondExpr());
                this.checkMatrixParam(this.getThirdExpr());
                this.checkMatrixParam(this.getFourthExpr());
                this.checkMatrixParam(this.getFifthExpr());
                this.checkMatrixParam(this.getSeventhExpr());
                this.checkMatrixParam(this.getEighthExpr());
                if (this.getOutputs().length != 5) {
                    this.raiseValidateError("lstm_backward has 5 outputs", false);
                }
                DataIdentifier dx = (DataIdentifier)this.getOutputs()[0];
                DataIdentifier dw = (DataIdentifier)this.getOutputs()[1];
                DataIdentifier db = (DataIdentifier)this.getOutputs()[2];
                DataIdentifier dout0 = (DataIdentifier)this.getOutputs()[3];
                DataIdentifier dc0 = (DataIdentifier)this.getOutputs()[4];
                BuiltinFunctionExpression.setDimensions(dx, this.getFirstExpr());
                BuiltinFunctionExpression.setDimensions(dw, this.getSecondExpr());
                BuiltinFunctionExpression.setDimensions(db, this.getThirdExpr());
                BuiltinFunctionExpression.setDimensions(dout0, this.getFourthExpr());
                BuiltinFunctionExpression.setDimensions(dc0, this.getFifthExpr());
                break;
            }
            case BATCH_NORM2D: {
                this.checkNumParameters(8);
                this.checkMatrixParam(this.getFirstExpr());
                this.checkMatrixParam(this.getSecondExpr());
                this.checkMatrixParam(this.getThirdExpr());
                this.checkMatrixParam(this.getFourthExpr());
                this.checkMatrixParam(this.getFifthExpr());
                if (this.getOutputs().length != 5) {
                    this.raiseValidateError("batch_norm2d has 5 outputs", false);
                }
                DataIdentifier ret = (DataIdentifier)this.getOutputs()[0];
                DataIdentifier retRunningMean = (DataIdentifier)this.getOutputs()[1];
                DataIdentifier retRunningVar = (DataIdentifier)this.getOutputs()[2];
                DataIdentifier resultSaveMean = (DataIdentifier)this.getOutputs()[3];
                DataIdentifier resultSaveInvVariance = (DataIdentifier)this.getOutputs()[4];
                BuiltinFunctionExpression.setDimensions(ret, this.getFirstExpr());
                BuiltinFunctionExpression.setDimensions(retRunningMean, this.getFourthExpr());
                BuiltinFunctionExpression.setDimensions(retRunningVar, this.getFourthExpr());
                BuiltinFunctionExpression.setDimensions(resultSaveMean, this.getFourthExpr());
                BuiltinFunctionExpression.setDimensions(resultSaveInvVariance, this.getFourthExpr());
                break;
            }
            case BATCH_NORM2D_BACKWARD: {
                this.checkNumParameters(6);
                this.checkMatrixParam(this.getFirstExpr());
                this.checkMatrixParam(this.getSecondExpr());
                this.checkMatrixParam(this.getThirdExpr());
                this.checkMatrixParam(this.getFifthExpr());
                this.checkMatrixParam(this.getSixthExpr());
                if (this.getOutputs().length != 3) {
                    this.raiseValidateError("batch_norm2d_backward has 3 outputs", false);
                }
                DataIdentifier dX = (DataIdentifier)this.getOutputs()[0];
                DataIdentifier dScale = (DataIdentifier)this.getOutputs()[1];
                DataIdentifier dBias = (DataIdentifier)this.getOutputs()[2];
                BuiltinFunctionExpression.setDimensions(dX, this.getFirstExpr());
                BuiltinFunctionExpression.setDimensions(dScale, this.getThirdExpr());
                BuiltinFunctionExpression.setDimensions(dBias, this.getThirdExpr());
                break;
            }
            case EIGEN: {
                this.checkNumParameters(1);
                this.checkMatrixParam(this.getFirstExpr());
                DataIdentifier eigenOut1 = (DataIdentifier)this.getOutputs()[0];
                DataIdentifier eigenOut2 = (DataIdentifier)this.getOutputs()[1];
                if (this.getFirstExpr().getOutput().getDim1() != this.getFirstExpr().getOutput().getDim2()) {
                    this.raiseValidateError("Eigen Decomposition can only be done on a square matrix. Input matrix is rectangular (rows=" + this.getFirstExpr().getOutput().getDim1() + ", cols=" + this.getFirstExpr().getOutput().getDim2() + ")", conditional);
                }
                eigenOut1.setDataType(Types.DataType.MATRIX);
                eigenOut1.setValueType(Types.ValueType.FP64);
                eigenOut1.setDimensions(this.getFirstExpr().getOutput().getDim1(), 1L);
                eigenOut1.setBlocksize(this.getFirstExpr().getOutput().getBlocksize());
                eigenOut2.setDataType(Types.DataType.MATRIX);
                eigenOut2.setValueType(Types.ValueType.FP64);
                eigenOut2.setDimensions(this.getFirstExpr().getOutput().getDim1(), this.getFirstExpr().getOutput().getDim2());
                eigenOut2.setBlocksize(this.getFirstExpr().getOutput().getBlocksize());
                break;
            }
            case REMOVE: {
                this.checkNumParameters(2);
                this.checkListParam(this.getFirstExpr());
                DataIdentifier out1 = (DataIdentifier)this.getOutputs()[0];
                DataIdentifier out2 = (DataIdentifier)this.getOutputs()[1];
                long nrow = this.getFirstExpr().getOutput().getDim1() > 0L ? this.getFirstExpr().getOutput().getDim1() + 1L : -1L;
                out1.setDataType(Types.DataType.LIST);
                out1.setValueType(this.getFirstExpr().getOutput().getValueType());
                out1.setDimensions(nrow, 1L);
                out1.setBlocksize(this.getFirstExpr().getOutput().getBlocksize());
                out2.setDataType(Types.DataType.LIST);
                out2.setValueType(this.getFirstExpr().getOutput().getValueType());
                out2.setDimensions(1L, 1L);
                out2.setBlocksize(this.getFirstExpr().getOutput().getBlocksize());
                break;
            }
            case SVD: {
                this.checkNumParameters(1);
                this.checkMatrixParam(this.getFirstExpr());
                long minMN = Math.min(this.getFirstExpr().getOutput().getDim1(), this.getFirstExpr().getOutput().getDim2());
                DataIdentifier svdOut1 = (DataIdentifier)this.getOutputs()[0];
                DataIdentifier svdOut2 = (DataIdentifier)this.getOutputs()[1];
                DataIdentifier svdOut3 = (DataIdentifier)this.getOutputs()[2];
                svdOut1.setDataType(Types.DataType.MATRIX);
                svdOut1.setValueType(Types.ValueType.FP64);
                svdOut1.setDimensions(this.getFirstExpr().getOutput().getDim1(), minMN);
                svdOut1.setBlocksize(this.getFirstExpr().getOutput().getBlocksize());
                svdOut2.setDataType(Types.DataType.MATRIX);
                svdOut2.setValueType(Types.ValueType.FP64);
                svdOut2.setDimensions(minMN, minMN);
                svdOut2.setBlocksize(this.getFirstExpr().getOutput().getBlocksize());
                svdOut3.setDataType(Types.DataType.MATRIX);
                svdOut3.setValueType(Types.ValueType.FP64);
                svdOut3.setDimensions(this.getFirstExpr().getOutput().getDim2(), minMN);
                svdOut3.setBlocksize(this.getFirstExpr().getOutput().getBlocksize());
                break;
            }
            default: {
                this.raiseValidateError("Unknown Builtin Function opcode: " + this._opcode, false);
            }
        }
    }

    private static void setDimensions(DataIdentifier out, Expression exp) {
        out.setDataType(Types.DataType.MATRIX);
        out.setValueType(Types.ValueType.FP64);
        out.setDimensions(exp.getOutput().getDim1(), exp.getOutput().getDim2());
        out.setBlocksize(exp.getOutput().getBlocksize());
    }

    private static ArrayList<ParameterExpression> orderDnnParams(ArrayList<ParameterExpression> paramExpression, int skip) {
        ArrayList<ParameterExpression> newParams = new ArrayList<ParameterExpression>();
        for (int i = 0; i < skip; ++i) {
            newParams.add(paramExpression.get(i));
        }
        String[] orderedParams = new String[]{"stride1", "stride2", "padding1", "padding2", "input_shape1", "input_shape2", "input_shape3", "input_shape4", "filter_shape1", "filter_shape2", "filter_shape3", "filter_shape4"};
        for (int i = 0; i < orderedParams.length; ++i) {
            boolean found = false;
            for (ParameterExpression param : paramExpression) {
                if (param.getName() == null || !param.getName().equals(orderedParams[i])) continue;
                found = true;
                newParams.add(param);
            }
            if (found) continue;
            throw new LanguageException("Incorrect parameters. Expected " + orderedParams[i] + " to be expanded.");
        }
        return newParams;
    }

    private static ArrayList<ParameterExpression> replaceListParams(ArrayList<ParameterExpression> paramExpression, String inputVarName, String outputVarName, int startIndex) {
        ArrayList<ParameterExpression> newParamExpression = new ArrayList<ParameterExpression>();
        int i = startIndex;
        int j = 1;
        for (ParameterExpression expr : paramExpression) {
            if (expr.getName() != null && expr.getName().equals(inputVarName + j)) {
                newParamExpression.add(new ParameterExpression(outputVarName + i, expr.getExpr()));
                ++i;
                ++j;
                continue;
            }
            newParamExpression.add(expr);
        }
        return newParamExpression;
    }

    private static ArrayList<ParameterExpression> expandListParams(ArrayList<ParameterExpression> paramExpression, HashSet<String> paramsToExpand) {
        ArrayList<ParameterExpression> newParamExpressions = new ArrayList<ParameterExpression>();
        for (ParameterExpression expr : paramExpression) {
            if (paramsToExpand.contains(expr.getName())) {
                if (!(expr.getExpr() instanceof ExpressionList)) continue;
                int i = 1;
                for (Expression e : ((ExpressionList)expr.getExpr()).getValue()) {
                    newParamExpressions.add(new ParameterExpression(expr.getName() + i, e));
                    ++i;
                }
                continue;
            }
            if (expr.getExpr() instanceof ExpressionList) {
                throw new LanguageException("The parameter " + expr.getName() + " cannot be list or is not supported for the given function");
            }
            newParamExpressions.add(expr);
        }
        return newParamExpressions;
    }

    private ArrayList<ParameterExpression> expandDnnArguments(ArrayList<ParameterExpression> paramExpression) {
        try {
            if (this._opcode == Builtins.CONV2D || this._opcode == Builtins.CONV2D_BACKWARD_FILTER || this._opcode == Builtins.CONV2D_BACKWARD_DATA) {
                HashSet<String> expand = new HashSet<String>();
                expand.add("input_shape");
                expand.add("filter_shape");
                expand.add("stride");
                expand.add("padding");
                paramExpression = BuiltinFunctionExpression.expandListParams(paramExpression, expand);
                paramExpression = BuiltinFunctionExpression.orderDnnParams(paramExpression, 2);
            } else if (this._opcode == Builtins.MAX_POOL || this._opcode == Builtins.AVG_POOL || this._opcode == Builtins.MAX_POOL_BACKWARD || this._opcode == Builtins.AVG_POOL_BACKWARD) {
                HashSet<String> expand = new HashSet<String>();
                expand.add("input_shape");
                expand.add("pool_size");
                expand.add("stride");
                expand.add("padding");
                paramExpression = BuiltinFunctionExpression.expandListParams(paramExpression, expand);
                paramExpression.add(new ParameterExpression("filter_shape1", new IntIdentifier(1L, (ParseInfo)this)));
                paramExpression.add(new ParameterExpression("filter_shape2", new IntIdentifier(1L, (ParseInfo)this)));
                paramExpression = BuiltinFunctionExpression.replaceListParams(paramExpression, "pool_size", "filter_shape", 3);
                paramExpression = this._opcode == Builtins.MAX_POOL_BACKWARD || this._opcode == Builtins.AVG_POOL_BACKWARD ? BuiltinFunctionExpression.orderDnnParams(paramExpression, 2) : BuiltinFunctionExpression.orderDnnParams(paramExpression, 1);
            }
        }
        catch (LanguageException e) {
            throw new RuntimeException(e);
        }
        return paramExpression;
    }

    private boolean isValidNoArgumentFunction() {
        return this.getOpCode() == Builtins.TIME || this.getOpCode() == Builtins.LIST;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void validateExpression(HashMap<String, DataIdentifier> ids, HashMap<String, ConstIdentifier> constVars, boolean conditional) {
        Identifier id;
        for (int i = 0; i < this._args.length; ++i) {
            if (this._args[i] instanceof FunctionCallIdentifier) {
                this.raiseValidateError("UDF function call not supported as parameter to built-in function call", false);
            }
            this._args[i].validateExpression(ids, constVars, conditional);
        }
        String outputName = BuiltinFunctionExpression.getTempName();
        DataIdentifier output = new DataIdentifier(outputName);
        output.setParseInfo(this);
        if (this.getFirstExpr() == null && !this.isValidNoArgumentFunction()) {
            this.raiseValidateError("Function " + this + " has no arguments.", false);
        }
        Identifier identifier = id = this._args.length != 0 ? this.getFirstExpr().getOutput() : null;
        if (this._args.length != 0) {
            output.setProperties(this.getFirstExpr().getOutput());
        }
        output.setNnz(-1L);
        this.setOutput(output);
        switch (this.getOpCode()) {
            case EVAL: 
            case EVALLIST: {
                if (this._args.length == 0) {
                    this.raiseValidateError("Function eval should provide at least one argument, i.e., the function name.", false);
                }
                this.checkValueTypeParam(this._args[0], Types.ValueType.STRING);
                boolean listReturn = this.getOpCode() == Builtins.EVALLIST;
                output.setDataType(listReturn ? Types.DataType.LIST : Types.DataType.MATRIX);
                output.setValueType(listReturn ? Types.ValueType.UNKNOWN : Types.ValueType.FP64);
                output.setDimensions(-1L, -1L);
                output.setBlocksize(ConfigurationManager.getBlocksize());
                return;
            }
            case COLSUM: 
            case COLMAX: 
            case COLMIN: 
            case COLMEAN: 
            case COLPROD: 
            case COLSD: 
            case COLVAR: {
                this.checkNumParameters(1);
                this.checkMatrixParam(this.getFirstExpr());
                output.setDataType(Types.DataType.MATRIX);
                output.setDimensions(1L, id.getDim2());
                output.setBlocksize(id.getBlocksize());
                output.setValueType(id.getValueType());
                return;
            }
            case ROWSUM: 
            case ROWMAX: 
            case ROWINDEXMAX: 
            case ROWMIN: 
            case ROWINDEXMIN: 
            case ROWMEAN: 
            case ROWPROD: 
            case ROWSD: 
            case ROWVAR: {
                this.checkNumParameters(1);
                this.checkMatrixParam(this.getFirstExpr());
                output.setDataType(Types.DataType.MATRIX);
                output.setDimensions(id.getDim1(), 1L);
                output.setBlocksize(id.getBlocksize());
                output.setValueType(id.getValueType());
                return;
            }
            case SUM: 
            case PROD: 
            case TRACE: 
            case SD: 
            case VAR: {
                this.checkNumParameters(1);
                this.checkMatrixTensorParam(this.getFirstExpr());
                output.setDataType(Types.DataType.SCALAR);
                output.setDimensions(0L, 0L);
                output.setBlocksize(0);
                switch (id.getValueType()) {
                    case STRING: 
                    case FP64: 
                    case FP32: {
                        output.setValueType(Types.ValueType.FP64);
                        return;
                    }
                    case INT64: 
                    case INT32: 
                    case UINT8: 
                    case BOOLEAN: {
                        output.setValueType(Types.ValueType.INT64);
                        return;
                    }
                    case UNKNOWN: {
                        throw new NotImplementedException();
                    }
                }
                return;
            }
            case MEAN: {
                if (this.getSecondExpr() != null) {
                    this.checkNumParameters(2);
                } else {
                    this.checkNumParameters(1);
                }
                this.checkMatrixParam(this.getFirstExpr());
                if (this.getSecondExpr() != null) {
                    this.checkMatchingDimensions(this.getFirstExpr(), this.getSecondExpr());
                }
                output.setDataType(Types.DataType.SCALAR);
                output.setDimensions(0L, 0L);
                output.setBlocksize(0);
                output.setValueType(id.getValueType());
                return;
            }
            case XOR: 
            case BITWAND: 
            case BITWOR: 
            case BITWXOR: 
            case BITWSHIFTL: 
            case BITWSHIFTR: {
                this.checkNumParameters(2);
                this.setBinaryOutputProperties(output);
                return;
            }
            case MIN: 
            case MAX: {
                if (this.getSecondExpr() == null) {
                    this.checkNumParameters(1);
                    this.checkMatrixParam(this.getFirstExpr());
                    output.setDataType(Types.DataType.SCALAR);
                    output.setValueType(id.getValueType());
                    output.setDimensions(0L, 0L);
                    output.setBlocksize(0);
                    return;
                }
                if (this.getAllExpr().length == 2) {
                    this.checkNumParameters(2);
                    this.setBinaryOutputProperties(output);
                    return;
                }
                for (Expression e : this.getAllExpr()) {
                    this.checkMatrixScalarParam(e);
                }
                this.setNaryOutputProperties(output);
                return;
            }
            case CUMSUM: 
            case CUMPROD: 
            case CUMSUMPROD: 
            case CUMMIN: 
            case CUMMAX: {
                this.checkNumParameters(1);
                this.checkMatrixParam(this.getFirstExpr());
                if (this.getOpCode() == Builtins.CUMSUMPROD && id.getDim2() > 2L) {
                    this.raiseValidateError("Cumsumprod only supported over two-column matrices", conditional);
                }
                output.setDataType(Types.DataType.MATRIX);
                output.setDimensions(id.getDim1(), id.getDim2());
                output.setBlocksize(id.getBlocksize());
                output.setValueType(id.getValueType());
                return;
            }
            case CAST_AS_SCALAR: {
                this.checkNumParameters(1);
                this.checkDataTypeParam(this.getFirstExpr(), Types.DataType.MATRIX, Types.DataType.FRAME, Types.DataType.LIST);
                if (this.getFirstExpr().getOutput().getDim1() != -1L && this.getFirstExpr().getOutput().getDim1() != 1L || this.getFirstExpr().getOutput().getDim2() != -1L && this.getFirstExpr().getOutput().getDim2() != 1L) {
                    this.raiseValidateError("dimension mismatch while casting matrix to scalar: dim1: " + this.getFirstExpr().getOutput().getDim1() + " dim2 " + this.getFirstExpr().getOutput().getDim2(), conditional, "Invalid Parameters");
                }
                output.setDataType(Types.DataType.SCALAR);
                output.setDimensions(0L, 0L);
                output.setBlocksize(0);
                output.setValueType(id.getValueType() != Types.ValueType.UNKNOWN || id.getDataType() == Types.DataType.LIST ? id.getValueType() : Types.ValueType.FP64);
                return;
            }
            case CAST_AS_MATRIX: {
                this.checkNumParameters(1);
                this.checkDataTypeParam(this.getFirstExpr(), Types.DataType.SCALAR, Types.DataType.FRAME, Types.DataType.LIST);
                output.setDataType(Types.DataType.MATRIX);
                output.setDimensions(id.getDim1(), id.getDim2());
                if (this.getFirstExpr().getOutput().getDataType() == Types.DataType.SCALAR) {
                    output.setDimensions(1L, 1L);
                }
                if (this.getFirstExpr().getOutput().getDataType() == Types.DataType.LIST) {
                    output.setDimensions(-1L, -1L);
                }
                output.setBlocksize(id.getBlocksize());
                output.setValueType(Types.ValueType.FP64);
                return;
            }
            case CAST_AS_LIST: {
                this.checkNumParameters(1);
                this.checkDataTypeParam(this.getFirstExpr(), Types.DataType.LIST);
                output.setDataType(Types.DataType.LIST);
                output.setDimensions(-1L, 1L);
                output.setBlocksize(id.getBlocksize());
                output.setValueType(Types.ValueType.UNKNOWN);
                return;
            }
            case TYPEOF: 
            case DETECTSCHEMA: 
            case COLNAMES: {
                this.checkNumParameters(1);
                this.checkMatrixFrameParam(this.getFirstExpr());
                output.setDataType(Types.DataType.FRAME);
                output.setDimensions(1L, id.getDim2());
                output.setBlocksize(id.getBlocksize());
                output.setValueType(Types.ValueType.STRING);
                return;
            }
            case CAST_AS_FRAME: {
                this.checkNumParameters(1);
                this.checkDataTypeParam(this.getFirstExpr(), Types.DataType.SCALAR, Types.DataType.MATRIX, Types.DataType.LIST);
                output.setDataType(Types.DataType.FRAME);
                output.setDimensions(id.getDim1(), id.getDim2());
                if (this.getFirstExpr().getOutput().getDataType() == Types.DataType.SCALAR) {
                    output.setDimensions(1L, 1L);
                }
                if (this.getFirstExpr().getOutput().getDataType() == Types.DataType.LIST) {
                    output.setDimensions(-1L, -1L);
                }
                output.setBlocksize(id.getBlocksize());
                output.setValueType(id.getValueType());
                return;
            }
            case CAST_AS_DOUBLE: {
                this.checkNumParameters(1);
                this.checkScalarParam(this.getFirstExpr());
                output.setDataType(Types.DataType.SCALAR);
                output.setDimensions(0L, 0L);
                output.setBlocksize(0);
                output.setValueType(Types.ValueType.FP64);
                return;
            }
            case CAST_AS_INT: {
                this.checkNumParameters(1);
                this.checkScalarParam(this.getFirstExpr());
                output.setDataType(Types.DataType.SCALAR);
                output.setDimensions(0L, 0L);
                output.setBlocksize(0);
                output.setValueType(Types.ValueType.INT64);
                return;
            }
            case CAST_AS_BOOLEAN: {
                this.checkNumParameters(1);
                this.checkScalarParam(this.getFirstExpr());
                output.setDataType(Types.DataType.SCALAR);
                output.setDimensions(0L, 0L);
                output.setBlocksize(0);
                output.setValueType(Types.ValueType.BOOLEAN);
                return;
            }
            case IFELSE: {
                this.checkNumParameters(3);
                this.setTernaryOutputProperties(output, conditional);
                return;
            }
            case CBIND: 
            case RBIND: {
                if (this.getFirstExpr().getOutput().getDataType() == Types.DataType.SCALAR) {
                    this.checkNumParameters(2);
                    this.checkScalarParam(this.getFirstExpr());
                    this.checkScalarParam(this.getSecondExpr());
                    this.checkValueTypeParam(this.getFirstExpr(), Types.ValueType.STRING);
                    this.checkValueTypeParam(this.getSecondExpr(), Types.ValueType.STRING);
                } else if (this.getAllExpr().length == 1) {
                    this.checkDataTypeParam(this.getFirstExpr(), Types.DataType.LIST);
                } else {
                    int i;
                    if (this.getAllExpr().length < 2) {
                        this.raiseValidateError("Invalid number of arguments for " + this.getOpCode(), conditional);
                    }
                    if (this.getFirstExpr().getOutput().getDataType().isList()) {
                        for (i = 1; i < this.getAllExpr().length; ++i) {
                            this.checkDataTypeParam(this.getExpr(i), Types.DataType.SCALAR, Types.DataType.MATRIX, Types.DataType.FRAME, Types.DataType.LIST);
                        }
                    } else {
                        for (i = 0; i < this.getAllExpr().length; ++i) {
                            this.checkMatrixFrameParam(this.getExpr(i));
                        }
                    }
                }
                output.setDataType(id.getDataType());
                output.setValueType(id.getValueType());
                if (id.getDataType() == Types.DataType.LIST && this.getAllExpr().length == 1) {
                    output.setDataType(Types.DataType.MATRIX);
                    output.setValueType(Types.ValueType.FP64);
                }
                long m1rlen = this.getFirstExpr().getOutput().getDim1();
                long m1clen = this.getFirstExpr().getOutput().getDim2();
                long appendDim1 = m1rlen;
                long appendDim2 = m1clen;
                if (id.getDataType() == Types.DataType.LIST) {
                    appendDim1 = -1L;
                    appendDim2 = -1L;
                } else {
                    for (int i = 1; i < this.getAllExpr().length; ++i) {
                        long m2rlen = this.getExpr(i).getOutput().getDim1();
                        long m2clen = this.getExpr(i).getOutput().getDim2();
                        if (this.getOpCode() == Builtins.CBIND) {
                            if (m1rlen >= 0L && m2rlen >= 0L && m1rlen != m2rlen) {
                                this.raiseValidateError("inputs to cbind must have same number of rows: input 1 rows: " + m1rlen + ", input 2 rows: " + m2rlen, conditional, "Invalid Parameters");
                            }
                            appendDim1 = m2rlen >= 0L ? m2rlen : appendDim1;
                            appendDim2 = appendDim2 >= 0L && m2clen >= 0L ? appendDim2 + m2clen : -1L;
                            continue;
                        }
                        if (this.getOpCode() != Builtins.RBIND) continue;
                        if (m1clen >= 0L && m2clen >= 0L && m1clen != m2clen) {
                            this.raiseValidateError("inputs to rbind must have same number of columns: input 1 columns: " + m1clen + ", input 2 columns: " + m2clen, conditional, "Invalid Parameters");
                        }
                        appendDim1 = appendDim1 >= 0L && m2rlen >= 0L ? appendDim1 + m2rlen : -1L;
                        appendDim2 = m2clen >= 0L ? m2clen : appendDim2;
                    }
                }
                output.setDimensions(appendDim1, appendDim2);
                output.setBlocksize(id.getBlocksize());
                return;
            }
            case PPRED: {
                this.raiseValidateError("ppred() has been deprecated. Please use the operator directly.", true);
                this.checkNumParameters(3);
                Types.DataType dt1 = this.getFirstExpr().getOutput().getDataType();
                Types.DataType dt2 = this.getSecondExpr().getOutput().getDataType();
                if (dt1 == Types.DataType.SCALAR && dt2 == Types.DataType.SCALAR) {
                    this.raiseValidateError("ppred() requires at least one matrix input.", conditional, "Invalid Parameters");
                }
                if (dt1 == Types.DataType.MATRIX) {
                    this.checkMatrixParam(this.getFirstExpr());
                }
                if (dt2 == Types.DataType.MATRIX) {
                    this.checkMatrixParam(this.getSecondExpr());
                }
                if (this.getThirdExpr().getOutput().getDataType() != Types.DataType.SCALAR || this.getThirdExpr().getOutput().getValueType() != Types.ValueType.STRING) {
                    this.raiseValidateError("Third argument in ppred() is not an operator ", conditional, "Invalid Parameters");
                }
                this.setBinaryOutputProperties(output);
                return;
            }
            case TRANS: {
                this.checkNumParameters(1);
                this.checkMatrixParam(this.getFirstExpr());
                output.setDataType(Types.DataType.MATRIX);
                output.setDimensions(id.getDim2(), id.getDim1());
                output.setBlocksize(id.getBlocksize());
                output.setValueType(id.getValueType());
                return;
            }
            case REV: {
                this.checkNumParameters(1);
                this.checkMatrixParam(this.getFirstExpr());
                output.setDataType(Types.DataType.MATRIX);
                output.setDimensions(id.getDim1(), id.getDim2());
                output.setBlocksize(id.getBlocksize());
                output.setValueType(id.getValueType());
                return;
            }
            case DIAG: {
                this.checkNumParameters(1);
                this.checkMatrixParam(this.getFirstExpr());
                output.setDataType(Types.DataType.MATRIX);
                if (id.getDim2() != -1L) {
                    if (id.getDim2() == 1L) {
                        output.setDimensions(id.getDim1(), id.getDim1());
                    } else {
                        if (id.getDim1() != id.getDim2()) {
                            this.raiseValidateError("diag can either: (1) create diagonal matrix from (n x 1) matrix, or (2) take diagonal from a square matrix. Error invoking diag on matrix with dimensions (" + id.getDim1() + "," + id.getDim2() + ") in " + this.toString(), conditional, "Invalid Parameters");
                        }
                        output.setDimensions(id.getDim1(), 1L);
                    }
                }
                output.setBlocksize(id.getBlocksize());
                output.setValueType(id.getValueType());
                return;
            }
            case NROW: 
            case NCOL: 
            case LENGTH: {
                this.checkNumParameters(1);
                this.checkDataTypeParam(this.getFirstExpr(), Types.DataType.FRAME, Types.DataType.LIST, Types.DataType.MATRIX);
                output.setDataType(Types.DataType.SCALAR);
                output.setDimensions(0L, 0L);
                output.setBlocksize(0);
                output.setValueType(Types.ValueType.INT64);
                return;
            }
            case COUNT_DISTINCT: {
                this.checkNumParameters(1);
                this.checkDataTypeParam(this.getFirstExpr(), Types.DataType.MATRIX);
                output.setDataType(Types.DataType.SCALAR);
                output.setDimensions(0L, 0L);
                output.setBlocksize(0);
                output.setValueType(Types.ValueType.INT64);
                return;
            }
            case LINEAGE: {
                this.checkNumParameters(1);
                this.checkDataTypeParam(this.getFirstExpr(), Types.DataType.MATRIX, Types.DataType.FRAME, Types.DataType.LIST);
                output.setDataType(Types.DataType.SCALAR);
                output.setDimensions(0L, 0L);
                output.setBlocksize(0);
                output.setValueType(Types.ValueType.STRING);
                return;
            }
            case LIST: {
                output.setDataType(Types.DataType.LIST);
                output.setValueType(Types.ValueType.UNKNOWN);
                output.setDimensions(this.getAllExpr().length, 1L);
                output.setBlocksize(-1);
                return;
            }
            case EXISTS: {
                this.checkNumParameters(1);
                this.checkStringOrDataIdentifier(this.getFirstExpr());
                output.setDataType(Types.DataType.SCALAR);
                output.setDimensions(0L, 0L);
                output.setBlocksize(0);
                output.setValueType(Types.ValueType.BOOLEAN);
                return;
            }
            case TABLE: {
                this.checkMatrixParam(this.getFirstExpr());
                if (this.getSecondExpr() == null) {
                    this.raiseValidateError("Invalid number of arguments to table(). The table() function requires 2, 3, 4, 5, or 6 arguments.", conditional);
                }
                if (this.getSecondExpr().getOutput().getDataType() == Types.DataType.MATRIX) {
                    this.checkMatchingDimensions(this.getFirstExpr(), this.getSecondExpr());
                }
                long outputDim1 = -1L;
                long outputDim2 = -1L;
                switch (this._args.length) {
                    case 2: {
                        break;
                    }
                    case 3: {
                        if (this.getThirdExpr().getOutput().getDataType() != Types.DataType.MATRIX) break;
                        this.checkMatchingDimensions(this.getFirstExpr(), this.getThirdExpr());
                        break;
                    }
                    case 4: {
                        if (this.getThirdExpr().getOutput().getDataType() != Types.DataType.SCALAR || this._args[3].getOutput().getDataType() != Types.DataType.SCALAR) {
                            this.raiseValidateError("Invalid argument types to table(): output dimensions must be of type scalar: " + this.toString(), conditional, "Invalid Parameters");
                            break;
                        }
                        if (this.getThirdExpr() instanceof DataIdentifier && constVars.containsKey(((DataIdentifier)this.getThirdExpr()).getName()) && !conditional) {
                            this._args[2] = constVars.get(((DataIdentifier)this.getThirdExpr()).getName());
                        }
                        if (this._args[3] instanceof DataIdentifier && constVars.containsKey(((DataIdentifier)this._args[3]).getName()) && !conditional) {
                            this._args[3] = constVars.get(((DataIdentifier)this._args[3]).getName());
                        }
                        if (this.getThirdExpr().getOutput() instanceof ConstIdentifier) {
                            outputDim1 = ((ConstIdentifier)this.getThirdExpr().getOutput()).getLongValue();
                        }
                        if (!(this._args[3].getOutput() instanceof ConstIdentifier)) break;
                        outputDim2 = ((ConstIdentifier)this._args[3].getOutput()).getLongValue();
                        break;
                    }
                    case 5: 
                    case 6: {
                        if (this.getThirdExpr().getOutput().getDataType() == Types.DataType.MATRIX) {
                            this.checkMatchingDimensions(this.getFirstExpr(), this.getThirdExpr());
                        }
                        if (this._args[3].getOutput().getDataType() != Types.DataType.SCALAR || this._args[4].getOutput().getDataType() != Types.DataType.SCALAR) {
                            this.raiseValidateError("Invalid argument types to table(): output dimensions must be of type scalar: " + this.toString(), conditional, "Invalid Parameters");
                        } else {
                            if (this._args[3] instanceof DataIdentifier && constVars.containsKey(((DataIdentifier)this._args[3]).getName()) && !conditional) {
                                this._args[3] = constVars.get(((DataIdentifier)this._args[3]).getName());
                            }
                            if (this._args[4] instanceof DataIdentifier && constVars.containsKey(((DataIdentifier)this._args[4]).getName()) && !conditional) {
                                this._args[4] = constVars.get(((DataIdentifier)this._args[4]).getName());
                            }
                            if (this._args[3].getOutput() instanceof ConstIdentifier) {
                                outputDim1 = ((ConstIdentifier)this._args[3].getOutput()).getLongValue();
                            }
                            if (this._args[4].getOutput() instanceof ConstIdentifier) {
                                outputDim2 = ((ConstIdentifier)this._args[4].getOutput()).getLongValue();
                            }
                        }
                        if (this._args.length != 6 || this._args[5].getOutput().isScalarBoolean()) break;
                        this.raiseValidateError("The 6th ctable parameter (outputEmptyBlocks) must be a boolean literal.", conditional);
                        break;
                    }
                    default: {
                        this.raiseValidateError("Invalid number of arguments to table(): " + this.toString(), conditional, "Invalid Parameters");
                    }
                }
                output.setDimensions(outputDim1, outputDim2);
                output.setBlocksize(-1);
                output.setDataType(Types.DataType.MATRIX);
                output.setValueType(Types.ValueType.FP64);
                return;
            }
            case MOMENT: {
                this.checkMatrixParam(this.getFirstExpr());
                if (this.getThirdExpr() != null) {
                    this.checkNumParameters(3);
                    this.checkMatrixParam(this.getSecondExpr());
                    this.checkMatchingDimensions(this.getFirstExpr(), this.getSecondExpr());
                    this.checkScalarParam(this.getThirdExpr());
                } else {
                    this.checkNumParameters(2);
                    this.checkScalarParam(this.getSecondExpr());
                }
                output.setDataType(Types.DataType.SCALAR);
                output.setValueType(Types.ValueType.FP64);
                output.setDimensions(0L, 0L);
                output.setBlocksize(0);
                return;
            }
            case COV: {
                if (this.getThirdExpr() != null) {
                    this.checkNumParameters(3);
                } else {
                    this.checkNumParameters(2);
                }
                this.checkMatrixParam(this.getFirstExpr());
                this.checkMatrixParam(this.getSecondExpr());
                this.checkMatchingDimensions(this.getFirstExpr(), this.getSecondExpr());
                if (this.getThirdExpr() != null) {
                    this.checkMatrixParam(this.getThirdExpr());
                    this.checkMatchingDimensions(this.getFirstExpr(), this.getThirdExpr());
                }
                output.setDataType(Types.DataType.SCALAR);
                output.setValueType(Types.ValueType.FP64);
                output.setDimensions(0L, 0L);
                output.setBlocksize(0);
                return;
            }
            case QUANTILE: {
                if (this.getThirdExpr() != null) {
                    this.checkNumParameters(3);
                } else {
                    this.checkNumParameters(2);
                }
                this.check1DMatrixParam(this.getFirstExpr());
                if (this.getThirdExpr() != null) {
                    this.checkMatrixParam(this.getSecondExpr());
                    this.checkMatchingDimensions(this.getFirstExpr(), this.getSecondExpr());
                }
                if (this.getThirdExpr() != null) {
                    output.setDimensions(this.getThirdExpr().getOutput().getDim1(), this.getThirdExpr().getOutput().getDim2());
                    output.setBlocksize(this.getThirdExpr().getOutput().getBlocksize());
                    output.setDataType(this.getThirdExpr().getOutput().getDataType());
                    return;
                }
                output.setDimensions(this.getSecondExpr().getOutput().getDim1(), this.getSecondExpr().getOutput().getDim2());
                output.setBlocksize(this.getSecondExpr().getOutput().getBlocksize());
                output.setDataType(this.getSecondExpr().getOutput().getDataType());
                return;
            }
            case INTERQUANTILE: {
                if (this.getThirdExpr() != null) {
                    this.checkNumParameters(3);
                } else {
                    this.checkNumParameters(2);
                }
                this.checkMatrixParam(this.getFirstExpr());
                if (this.getThirdExpr() != null) {
                    this.checkMatrixParam(this.getSecondExpr());
                    this.checkMatchingDimensionsQuantile();
                }
                if (this.getThirdExpr() == null && this.getSecondExpr().getOutput().getDataType() != Types.DataType.SCALAR && this.getThirdExpr() != null && this.getThirdExpr().getOutput().getDataType() != Types.DataType.SCALAR) {
                    this.raiseValidateError("Invalid parameters to " + this.getOpCode(), conditional, "Invalid Parameters");
                }
                output.setValueType(id.getValueType());
                output.setDimensions(-1L, -1L);
                output.setBlocksize(-1);
                output.setDataType(Types.DataType.MATRIX);
                return;
            }
            case IQM: {
                if (this.getSecondExpr() != null) {
                    this.checkNumParameters(2);
                } else {
                    this.checkNumParameters(1);
                }
                this.checkMatrixParam(this.getFirstExpr());
                if (this.getSecondExpr() != null) {
                    this.checkMatrixParam(this.getSecondExpr());
                    this.checkMatchingDimensions(this.getFirstExpr(), this.getSecondExpr());
                }
                output.setValueType(id.getValueType());
                output.setDimensions(0L, 0L);
                output.setBlocksize(0);
                output.setDataType(Types.DataType.SCALAR);
                return;
            }
            case ISNA: 
            case ISNAN: 
            case ISINF: {
                this.checkNumParameters(1);
                this.checkMatrixScalarParam(this.getFirstExpr());
                output.setDataType(id.getDataType());
                output.setDimensions(id.getDim1(), id.getDim2());
                output.setBlocksize(id.getBlocksize());
                output.setValueType(id.getValueType());
                return;
            }
            case MEDIAN: {
                this.checkNumParameters(this.getSecondExpr() != null ? 2 : 1);
                this.checkMatrixParam(this.getFirstExpr());
                if (this.getSecondExpr() != null) {
                    this.checkMatrixParam(this.getSecondExpr());
                    this.checkMatchingDimensions(this.getFirstExpr(), this.getSecondExpr());
                }
                output.setValueType(id.getValueType());
                output.setDimensions(0L, 0L);
                output.setBlocksize(0);
                output.setDataType(Types.DataType.SCALAR);
                return;
            }
            case SAMPLE: {
                long size;
                long range;
                Expression[] in;
                for (Expression e : in = this.getAllExpr()) {
                    this.checkScalarParam(e);
                }
                if (in[0].getOutput().getValueType() != Types.ValueType.FP64 && in[0].getOutput().getValueType() != Types.ValueType.INT64) {
                    throw new LanguageException("First argument to sample() must be a number.");
                }
                if (in[1].getOutput().getValueType() != Types.ValueType.FP64 && in[1].getOutput().getValueType() != Types.ValueType.INT64) {
                    throw new LanguageException("Second argument to sample() must be a number.");
                }
                boolean check = false;
                if (BuiltinFunctionExpression.isConstant(in[0]) && BuiltinFunctionExpression.isConstant(in[1]) && (range = ((ConstIdentifier)in[0]).getLongValue()) < (size = ((ConstIdentifier)in[1]).getLongValue())) {
                    check = true;
                }
                if (in.length == 4) {
                    this.checkNumParameters(4);
                    if (in[3].getOutput().getValueType() != Types.ValueType.INT64) {
                        throw new LanguageException("Fourth argument, seed, to sample() must be an integer value.");
                    }
                    if (in[2].getOutput().getValueType() != Types.ValueType.BOOLEAN) {
                        throw new LanguageException("Third argument to sample() must either denote replacement policy (boolean) or seed (integer).");
                    }
                } else if (in.length == 3) {
                    this.checkNumParameters(3);
                    if (in[2].getOutput().getValueType() != Types.ValueType.BOOLEAN && in[2].getOutput().getValueType() != Types.ValueType.INT64) {
                        throw new LanguageException("Third argument to sample() must either denote replacement policy (boolean) or seed (integer).");
                    }
                }
                if (check && in.length >= 3 && BuiltinFunctionExpression.isConstant(in[2]) && in[2].getOutput().getValueType() == Types.ValueType.BOOLEAN && !((BooleanIdentifier)in[2]).getValue()) {
                    throw new LanguageException("Sample (size=" + ((ConstIdentifier)in[0]).getLongValue() + ") larger than population (size=" + ((ConstIdentifier)in[1]).getLongValue() + ") can only be generated with replacement.");
                }
                output.setDataType(Types.DataType.MATRIX);
                output.setValueType(Types.ValueType.FP64);
                if (BuiltinFunctionExpression.isConstant(in[1])) {
                    output.setDimensions(((ConstIdentifier)in[1]).getLongValue(), 1L);
                } else {
                    output.setDimensions(-1L, 1L);
                }
                this.setBlocksize(id.getBlocksize());
                return;
            }
            case SEQ: {
                this.checkScalarParam(this.getFirstExpr());
                this.checkScalarParam(this.getSecondExpr());
                if (this.getThirdExpr() != null) {
                    this.checkNumParameters(3);
                    this.checkScalarParam(this.getThirdExpr());
                } else {
                    this.checkNumParameters(2);
                }
                if (!conditional) {
                    if (this.getFirstExpr() instanceof DataIdentifier && constVars.containsKey(((DataIdentifier)this.getFirstExpr()).getName())) {
                        this._args[0] = constVars.get(((DataIdentifier)this.getFirstExpr()).getName());
                    }
                    if (this.getSecondExpr() instanceof DataIdentifier && constVars.containsKey(((DataIdentifier)this.getSecondExpr()).getName())) {
                        this._args[1] = constVars.get(((DataIdentifier)this.getSecondExpr()).getName());
                    }
                    if (this.getThirdExpr() != null && this.getThirdExpr() instanceof DataIdentifier && constVars.containsKey(((DataIdentifier)this.getThirdExpr()).getName())) {
                        this._args[2] = constVars.get(((DataIdentifier)this.getThirdExpr()).getName());
                    }
                }
                long dim1 = -1L;
                long dim2 = 1L;
                if (BuiltinFunctionExpression.isConstant(this.getFirstExpr()) && BuiltinFunctionExpression.isConstant(this.getSecondExpr()) && (this.getThirdExpr() == null || BuiltinFunctionExpression.isConstant(this.getThirdExpr()))) {
                    double incr;
                    double to;
                    double from;
                    try {
                        from = BuiltinFunctionExpression.getDoubleValue(this.getFirstExpr());
                        to = BuiltinFunctionExpression.getDoubleValue(this.getSecondExpr());
                        if (this.getThirdExpr() == null) {
                            this.expandArguments();
                            this._args[2] = new DoubleIdentifier(from > to ? -1.0 : 1.0, (ParseInfo)this);
                        }
                        incr = BuiltinFunctionExpression.getDoubleValue(this.getThirdExpr());
                    }
                    catch (LanguageException e) {
                        throw new LanguageException("Arguments for seq() must be numeric.");
                    }
                    if (from > to && incr >= 0.0) {
                        throw new LanguageException("Wrong sign for the increment in a call to seq()");
                    }
                    dim1 = UtilFunctions.getSeqLength(from, to, incr);
                }
                output.setDataType(Types.DataType.MATRIX);
                output.setValueType(Types.ValueType.FP64);
                output.setDimensions(dim1, dim2);
                output.setBlocksize(0);
                return;
            }
            case SOLVE: {
                this.checkNumParameters(2);
                this.checkMatrixParam(this.getFirstExpr());
                this.checkMatrixParam(this.getSecondExpr());
                if (this.getSecondExpr().getOutput().dimsKnown() && !BuiltinFunctionExpression.is1DMatrix(this.getSecondExpr())) {
                    this.raiseValidateError("Second input to solve() must be a vector", conditional);
                }
                if (this.getFirstExpr().getOutput().dimsKnown() && this.getSecondExpr().getOutput().dimsKnown() && this.getFirstExpr().getOutput().getDim1() != this.getSecondExpr().getOutput().getDim1() && this.getFirstExpr().getOutput().getDim1() != this.getFirstExpr().getOutput().getDim2()) {
                    this.raiseValidateError("Dimension mismatch in a call to solve()", conditional);
                }
                output.setDataType(Types.DataType.MATRIX);
                output.setValueType(Types.ValueType.FP64);
                output.setDimensions(this.getFirstExpr().getOutput().getDim2(), 1L);
                output.setBlocksize(0);
                return;
            }
            case INVERSE: {
                this.checkNumParameters(1);
                this.checkMatrixParam(this.getFirstExpr());
                output.setDataType(Types.DataType.MATRIX);
                output.setValueType(Types.ValueType.FP64);
                Identifier in = this.getFirstExpr().getOutput();
                if (in.dimsKnown() && in.getDim1() != in.getDim2()) {
                    this.raiseValidateError("Input to inv() must be square matrix -- given: a " + in.getDim1() + "x" + in.getDim2() + " matrix.", conditional);
                }
                output.setDimensions(in.getDim1(), in.getDim2());
                output.setBlocksize(in.getBlocksize());
                return;
            }
            case CHOLESKY: {
                this.checkNumParameters(1);
                this.checkMatrixParam(this.getFirstExpr());
                output.setDataType(Types.DataType.MATRIX);
                output.setValueType(Types.ValueType.FP64);
                Identifier inA = this.getFirstExpr().getOutput();
                if (inA.dimsKnown() && inA.getDim1() != inA.getDim2()) {
                    this.raiseValidateError("Input to cholesky() must be square matrix -- given: a " + inA.getDim1() + "x" + inA.getDim2() + " matrix.", conditional);
                }
                output.setDimensions(inA.getDim1(), inA.getDim2());
                output.setBlocksize(inA.getBlocksize());
                return;
            }
            case OUTER: {
                Identifier id2 = this.getSecondExpr().getOutput();
                this.checkNumParameters(3);
                this.checkMatrixParam(this.getFirstExpr());
                this.checkMatrixParam(this.getSecondExpr());
                this.checkScalarParam(this.getThirdExpr());
                this.checkValueTypeParam(this.getThirdExpr(), Types.ValueType.STRING);
                if (id.getDim2() > 1L || id2.getDim1() > 1L) {
                    this.raiseValidateError("Outer vector operations require a common dimension of one: " + id.getDim1() + "x" + id.getDim2() + " o " + id2.getDim1() + "x" + id2.getDim2() + ".", false);
                }
                output.setDataType(id.getDataType());
                output.setDimensions(id.getDim1(), id2.getDim2());
                output.setBlocksize(id.getBlocksize());
                return;
            }
            case BIASADD: 
            case BIASMULT: {
                Expression input = this._args[0];
                Expression bias = this._args[1];
                output.setDataType(Types.DataType.MATRIX);
                output.setValueType(Types.ValueType.FP64);
                output.setDimensions(input.getOutput().getDim1(), input.getOutput().getDim2());
                output.setBlocksize(input.getOutput().getBlocksize());
                this.checkMatrixParam(input);
                this.checkMatrixParam(bias);
                return;
            }
            case CONV2D: 
            case CONV2D_BACKWARD_FILTER: 
            case CONV2D_BACKWARD_DATA: 
            case MAX_POOL: 
            case AVG_POOL: 
            case MAX_POOL_BACKWARD: 
            case AVG_POOL_BACKWARD: {
                Expression input = this._args[0];
                Expression input2 = null;
                if (this.getOpCode() != Builtins.MAX_POOL && this.getOpCode() != Builtins.AVG_POOL) {
                    input2 = this._args[1];
                    this.checkMatrixParam(input2);
                }
                output.setDataType(Types.DataType.MATRIX);
                output.setValueType(Types.ValueType.FP64);
                output.setBlocksize(input.getOutput().getBlocksize());
                if (this.getOpCode() == Builtins.MAX_POOL_BACKWARD || this.getOpCode() == Builtins.AVG_POOL_BACKWARD) {
                    output.setDimensions(input.getOutput().getDim1(), input.getOutput().getDim2());
                } else {
                    try {
                        int start = 2;
                        if (this.getOpCode() != Builtins.MAX_POOL && this.getOpCode() != Builtins.AVG_POOL) {
                            start = 1;
                        }
                        long stride_h = (long)BuiltinFunctionExpression.getDoubleValue(this._args[start++]);
                        long stride_w = (long)BuiltinFunctionExpression.getDoubleValue(this._args[start++]);
                        long pad_h = (long)BuiltinFunctionExpression.getDoubleValue(this._args[start++]);
                        long pad_w = (long)BuiltinFunctionExpression.getDoubleValue(this._args[start++]);
                        long N = (long)BuiltinFunctionExpression.getDoubleValue(this._args[start++]);
                        long C = (long)BuiltinFunctionExpression.getDoubleValue(this._args[start++]);
                        long H = (long)BuiltinFunctionExpression.getDoubleValue(this._args[start++]);
                        long W = (long)BuiltinFunctionExpression.getDoubleValue(this._args[start++]);
                        long K = -1L;
                        if (this.getOpCode() != Builtins.MAX_POOL && this.getOpCode() != Builtins.AVG_POOL) {
                            K = (long)BuiltinFunctionExpression.getDoubleValue(this._args[start]);
                        }
                        ++start;
                        int n = ++start;
                        long R = (long)BuiltinFunctionExpression.getDoubleValue(this._args[n]);
                        int n2 = ++start;
                        ++start;
                        long S = (long)BuiltinFunctionExpression.getDoubleValue(this._args[n2]);
                        if (this.getOpCode() == Builtins.CONV2D_BACKWARD_FILTER) {
                            output.setDimensions(K, C * R * S);
                        } else if (this.getOpCode() == Builtins.CONV2D_BACKWARD_DATA) {
                            output.setDimensions(N, C * H * W);
                        } else if (H > 0L && W > 0L && stride_h > 0L && stride_w > 0L && pad_h >= 0L && pad_w >= 0L && R > 0L && S > 0L) {
                            long P = DnnUtils.getP(H, R, stride_h, pad_h);
                            long Q = DnnUtils.getQ(W, S, stride_w, pad_w);
                            if (this.getOpCode() == Builtins.CONV2D) {
                                output.setDimensions(N, K * P * Q);
                            } else {
                                if (this.getOpCode() != Builtins.MAX_POOL && this.getOpCode() != Builtins.AVG_POOL) throw new LanguageException("");
                                output.setDimensions(N, C * P * Q);
                            }
                        } else if (this.getOpCode() == Builtins.CONV2D) {
                            output.setDimensions(input.getOutput().getDim1(), -1L);
                        } else {
                            if (this.getOpCode() != Builtins.MAX_POOL && this.getOpCode() != Builtins.AVG_POOL) throw new LanguageException("");
                            output.setDimensions(input.getOutput().getDim1(), -1L);
                        }
                    }
                    catch (Exception e) {
                        output.setDimensions(-1L, -1L);
                    }
                }
                this.checkMatrixParam(input);
                if (input2 == null) return;
                this.checkMatrixParam(input2);
                return;
            }
            case TIME: {
                this.checkNumParameters(0);
                output.setDataType(Types.DataType.SCALAR);
                output.setValueType(Types.ValueType.INT64);
                output.setDimensions(0L, 0L);
                output.setBlocksize(0);
                return;
            }
            case DROP_INVALID_TYPE: 
            case VALUE_SWAP: 
            case FRAME_ROW_REPLICATE: {
                this.checkNumParameters(2);
                this.checkMatrixFrameParam(this.getFirstExpr());
                this.checkMatrixFrameParam(this.getSecondExpr());
                output.setDataType(Types.DataType.FRAME);
                output.setDimensions(id.getDim1(), id.getDim2());
                output.setBlocksize(id.getBlocksize());
                output.setValueType(Types.ValueType.STRING);
                return;
            }
            case DROP_INVALID_LENGTH: {
                this.checkNumParameters(2);
                this.checkMatrixFrameParam(this.getFirstExpr());
                this.checkMatrixFrameParam(this.getSecondExpr());
                output.setDataType(Types.DataType.FRAME);
                output.setDimensions(id.getDim1(), id.getDim2());
                output.setBlocksize(id.getBlocksize());
                output.setValueType(id.getValueType());
                return;
            }
            case MAP: {
                this.checkNumParameters(this.getThirdExpr() != null ? 3 : 2);
                this.checkMatrixFrameParam(this.getFirstExpr());
                this.checkScalarParam(this.getSecondExpr());
                if (this.getThirdExpr() != null) {
                    this.checkScalarParam(this.getThirdExpr());
                }
                output.setDataType(Types.DataType.FRAME);
                if (this._args[1].getText().contains("jaccardSim")) {
                    output.setDimensions(id.getDim1(), id.getDim1());
                    output.setValueType(Types.ValueType.FP64);
                    return;
                }
                output.setDimensions(id.getDim1(), id.getDim2());
                output.setValueType(Types.ValueType.STRING);
                return;
            }
            case LOCAL: {
                if (OptimizerUtils.ALLOW_SCRIPT_LEVEL_LOCAL_COMMAND) {
                    this.checkNumParameters(1);
                    this.checkMatrixParam(this.getFirstExpr());
                    output.setDataType(Types.DataType.MATRIX);
                    output.setDimensions(id.getDim1(), id.getDim2());
                    output.setBlocksize(id.getBlocksize());
                    output.setValueType(id.getValueType());
                } else {
                    this.raiseValidateError("Local instruction not allowed in dml script");
                }
            }
            case COMPRESS: 
            case DECOMPRESS: {
                if (OptimizerUtils.ALLOW_SCRIPT_LEVEL_COMPRESS_COMMAND) {
                    this.checkNumParameters(1);
                    this.checkMatrixParam(this.getFirstExpr());
                    output.setDataType(Types.DataType.MATRIX);
                    output.setDimensions(id.getDim1(), id.getDim2());
                    output.setBlocksize(id.getBlocksize());
                    output.setValueType(id.getValueType());
                    return;
                }
                this.raiseValidateError("Compress/DeCompress instruction not allowed in dml script");
                return;
            }
            default: {
                if (this.isMathFunction()) {
                    this.checkMathFunctionParam();
                    if (this.getSecondExpr() == null) {
                        output.setDataType(id.getDataType());
                        output.setValueType(output.getDataType() == Types.DataType.SCALAR && this.getOpCode() == Builtins.ABS ? id.getValueType() : Types.ValueType.FP64);
                        output.setDimensions(id.getDim1(), id.getDim2());
                        output.setBlocksize(id.getBlocksize());
                        return;
                    }
                    this.setBinaryOutputProperties(output);
                    if (this.getOpCode() != Builtins.LOG) return;
                    output.setValueType(Types.ValueType.FP64);
                    return;
                }
                Builtins op = this.getOpCode();
                if (op == Builtins.EIGEN || op == Builtins.LU || op == Builtins.QR || op == Builtins.SVD || op == Builtins.LSTM || op == Builtins.LSTM_BACKWARD || op == Builtins.BATCH_NORM2D || op == Builtins.BATCH_NORM2D_BACKWARD) {
                    this.raiseValidateError("Function " + op + " needs to be called with multi-return assignment.", false, "Invalid Parameters");
                    return;
                }
                this.raiseValidateError("Unsupported function " + op, false, "Invalid Parameters");
            }
        }
    }

    private void setBinaryOutputProperties(DataIdentifier output) {
        Types.DataType dtOut;
        Types.DataType dt1 = this.getFirstExpr().getOutput().getDataType();
        Types.DataType dt2 = this.getSecondExpr().getOutput().getDataType();
        Types.DataType dataType = dtOut = dt1 == Types.DataType.MATRIX || dt2 == Types.DataType.MATRIX ? Types.DataType.MATRIX : Types.DataType.SCALAR;
        if (dt1 == Types.DataType.MATRIX && dt2 == Types.DataType.MATRIX) {
            this.checkMatchingDimensions(this.getFirstExpr(), this.getSecondExpr(), true);
        }
        MatrixCharacteristics dims = BuiltinFunctionExpression.getBinaryMatrixCharacteristics(this.getFirstExpr(), this.getSecondExpr());
        output.setDataType(dtOut);
        output.setValueType(dtOut == Types.DataType.MATRIX ? Types.ValueType.FP64 : BuiltinFunctionExpression.computeValueType(this.getFirstExpr(), this.getSecondExpr(), true));
        output.setDimensions(dims.getRows(), dims.getCols());
        output.setBlocksize(dims.getBlocksize());
    }

    private void setTernaryOutputProperties(DataIdentifier output, boolean conditional) {
        Types.DataType dtOut;
        Types.DataType dt1 = this.getFirstExpr().getOutput().getDataType();
        Types.DataType dt2 = this.getSecondExpr().getOutput().getDataType();
        Types.DataType dt3 = this.getThirdExpr().getOutput().getDataType();
        Types.DataType dataType = dtOut = dt1.isMatrix() || dt2.isMatrix() || dt3.isMatrix() ? Types.DataType.MATRIX : Types.DataType.SCALAR;
        if (dt1 == Types.DataType.MATRIX && dt2 == Types.DataType.MATRIX) {
            this.checkMatchingDimensions(this.getFirstExpr(), this.getSecondExpr(), false, conditional);
        }
        if (dt1 == Types.DataType.MATRIX && dt3 == Types.DataType.MATRIX) {
            this.checkMatchingDimensions(this.getFirstExpr(), this.getThirdExpr(), false, conditional);
        }
        if (dt2 == Types.DataType.MATRIX && dt3 == Types.DataType.MATRIX) {
            this.checkMatchingDimensions(this.getSecondExpr(), this.getThirdExpr(), false, conditional);
        }
        MatrixCharacteristics dims1 = BuiltinFunctionExpression.getBinaryMatrixCharacteristics(this.getFirstExpr(), this.getSecondExpr());
        MatrixCharacteristics dims2 = BuiltinFunctionExpression.getBinaryMatrixCharacteristics(this.getSecondExpr(), this.getThirdExpr());
        output.setDataType(dtOut);
        output.setValueType(dtOut == Types.DataType.MATRIX ? Types.ValueType.FP64 : BuiltinFunctionExpression.computeValueType(this.getSecondExpr(), this.getThirdExpr(), true));
        output.setDimensions(Math.max(dims1.getRows(), dims2.getRows()), Math.max(dims1.getCols(), dims2.getCols()));
        output.setBlocksize(Math.max(dims1.getBlocksize(), dims2.getBlocksize()));
    }

    private void setNaryOutputProperties(DataIdentifier output) {
        Types.DataType dt = Arrays.stream(this.getAllExpr()).allMatch(e -> e.getOutput().getDataType().isScalar()) ? Types.DataType.SCALAR : Types.DataType.MATRIX;
        Expression firstM = dt.isMatrix() ? Arrays.stream(this.getAllExpr()).filter(e -> e.getOutput().getDataType().isMatrix()).findFirst().get() : null;
        Types.ValueType vt = dt.isMatrix() ? Types.ValueType.FP64 : Types.ValueType.INT64;
        for (Expression e2 : this.getAllExpr()) {
            vt = BuiltinFunctionExpression.computeValueType(e2, e2.getOutput().getValueType(), vt, true);
            if (!e2.getOutput().getDataType().isMatrix()) continue;
            this.checkMatchingDimensions(firstM, e2, true);
        }
        output.setDataType(dt);
        output.setValueType(vt);
        output.setDimensions(dt.isMatrix() ? firstM.getOutput().getDim1() : 0L, dt.isMatrix() ? firstM.getOutput().getDim2() : 0L);
        output.setBlocksize(dt.isMatrix() ? firstM.getOutput().getBlocksize() : 0);
    }

    private void expandArguments() {
        if (this._args == null) {
            this._args = new Expression[1];
            return;
        }
        Expression[] temp = (Expression[])this._args.clone();
        this._args = new Expression[this._args.length + 1];
        System.arraycopy(temp, 0, this._args, 0, temp.length);
    }

    @Override
    public boolean multipleReturns() {
        return this._opcode.isMultiReturn();
    }

    private static boolean isConstant(Expression expr) {
        return expr != null && expr instanceof ConstIdentifier;
    }

    private static double getDoubleValue(Expression expr) {
        if (expr instanceof DoubleIdentifier) {
            return ((DoubleIdentifier)expr).getValue();
        }
        if (expr instanceof IntIdentifier) {
            return ((IntIdentifier)expr).getValue();
        }
        throw new LanguageException("Expecting a numeric value.");
    }

    private boolean isMathFunction() {
        switch (this.getOpCode()) {
            case XOR: 
            case BITWAND: 
            case BITWOR: 
            case BITWXOR: 
            case BITWSHIFTL: 
            case BITWSHIFTR: 
            case MEDIAN: 
            case COS: 
            case SIN: 
            case TAN: 
            case ACOS: 
            case ASIN: 
            case ATAN: 
            case COSH: 
            case SINH: 
            case TANH: 
            case SIGN: 
            case SQRT: 
            case ABS: 
            case LOG: 
            case EXP: 
            case ROUND: 
            case CEIL: 
            case FLOOR: {
                return true;
            }
        }
        return false;
    }

    private void checkMathFunctionParam() {
        switch (this.getOpCode()) {
            case MEDIAN: 
            case COS: 
            case SIN: 
            case TAN: 
            case ACOS: 
            case ASIN: 
            case ATAN: 
            case COSH: 
            case SINH: 
            case TANH: 
            case SIGN: 
            case SQRT: 
            case ABS: 
            case EXP: 
            case ROUND: 
            case CEIL: 
            case FLOOR: {
                this.checkNumParameters(1);
                break;
            }
            case LOG: {
                if (this.getSecondExpr() != null) {
                    this.checkNumParameters(2);
                    break;
                }
                this.checkNumParameters(1);
                break;
            }
            default: {
                this.raiseValidateError("Unknown math function " + this.getOpCode(), false);
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this._opcode.toString() + "(");
        if (this._args != null) {
            for (int i = 0; i < this._args.length; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(this._args[i].toString());
            }
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public VariableSet variablesRead() {
        VariableSet result = new VariableSet();
        for (int i = 0; i < this._args.length; ++i) {
            result.addVariables(this._args[i].variablesRead());
        }
        return result;
    }

    @Override
    public VariableSet variablesUpdated() {
        VariableSet result = new VariableSet();
        return result;
    }

    protected void checkNumParameters(int count) {
        if (this.getFirstExpr() == null && this._args.length > 0) {
            this.raiseValidateError("Missing argument for function " + this.getOpCode(), false, "Invalid Parameters");
        }
        if (count == 1 && (this.getSecondExpr() != null || this.getThirdExpr() != null) || count == 2 && this.getThirdExpr() != null) {
            this.raiseValidateError("Invalid number of arguments for function " + this.getOpCode().toString().toLowerCase() + "(). This function only takes 1 or 2 arguments.", false);
        } else if (count == 2 && this.getSecondExpr() == null || count == 3 && (this.getSecondExpr() == null || this.getThirdExpr() == null)) {
            this.raiseValidateError("Missing argument for function " + this.getOpCode(), false, "Invalid Parameters");
        } else if (count > 0 && (this._args == null || this._args.length < count)) {
            this.raiseValidateError("Missing argument for function " + this.getOpCode(), false, "Invalid Parameters");
        } else if (count == 0 && (this._args.length > 0 || this.getSecondExpr() != null || this.getThirdExpr() != null)) {
            this.raiseValidateError("Missing argument for function " + this.getOpCode() + "(). This function doesn't take any arguments.", false);
        }
    }

    protected void checkMatrixParam(Expression e) {
        if (e.getOutput().getDataType() != Types.DataType.MATRIX) {
            this.raiseValidateError("Expected " + e.getText() + " to be a matrix argument for function " + this.getOpCode().toString().toLowerCase() + "().", false);
        }
    }

    protected void checkMatrixTensorParam(Expression e) {
        if (e.getOutput().getDataType() != Types.DataType.MATRIX && (e.getOutput().getDataType() != Types.DataType.TENSOR || this.getOpCode() != Builtins.SUM)) {
            this.raiseValidateError("Expected " + e.getText() + " to be a matrix or tensor argument for function " + this.getOpCode().toString().toLowerCase() + "().", false);
        }
    }

    protected void checkDataTypeParam(Expression e, Types.DataType ... dt) {
        if (!ArrayUtils.contains((Object[])dt, (Object)((Object)e.getOutput().getDataType()))) {
            this.raiseValidateError("Non-matching expected data type for function " + this.getOpCode(), false, "Unsupported Parameters");
        }
    }

    protected void checkMatrixFrameParam(Expression e) {
        if (e.getOutput().getDataType() != Types.DataType.MATRIX && e.getOutput().getDataType() != Types.DataType.FRAME) {
            this.raiseValidateError("Expecting matrix or frame parameter for function " + this.getOpCode(), false, "Unsupported Parameters");
        }
    }

    protected void checkMatrixScalarParam(Expression e) {
        if (e.getOutput().getDataType() != Types.DataType.MATRIX && e.getOutput().getDataType() != Types.DataType.SCALAR) {
            this.raiseValidateError("Expecting matrix or scalar parameter for function " + this.getOpCode(), false, "Unsupported Parameters");
        }
    }

    private void checkScalarParam(Expression e) {
        if (e.getOutput().getDataType() != Types.DataType.SCALAR) {
            this.raiseValidateError("Expecting scalar parameter for function " + this.getOpCode(), false, "Unsupported Parameters");
        }
    }

    private void checkListParam(Expression e) {
        if (e.getOutput().getDataType() != Types.DataType.LIST) {
            this.raiseValidateError("Expecting scalar parameter for function " + this.getOpCode(), false, "Unsupported Parameters");
        }
    }

    private void checkScalarFrameParam(Expression e) {
        if (e.getOutput().getDataType() != Types.DataType.SCALAR && e.getOutput().getDataType() != Types.DataType.FRAME) {
            this.raiseValidateError("Expecting scalar parameter for function " + this.getOpCode(), false, "Unsupported Parameters");
        }
    }

    private void checkValueTypeParam(Expression e, Types.ValueType vt) {
        if (e.getOutput().getValueType() != vt) {
            this.raiseValidateError("Expecting parameter of different value type " + this.getOpCode(), false, "Unsupported Parameters");
        }
    }

    protected void checkStringOrDataIdentifier(Expression e) {
        if (!(e.getOutput().getDataType().isScalar() && e.getOutput().getValueType() == Types.ValueType.STRING || e instanceof DataIdentifier && !(e instanceof IndexedIdentifier))) {
            this.raiseValidateError("Expecting variable name or data identifier " + this.getOpCode(), false, "Unsupported Parameters");
        }
    }

    private static boolean is1DMatrix(Expression e) {
        return e.getOutput().getDim1() == 1L || e.getOutput().getDim2() == 1L;
    }

    private static boolean dimsKnown(Expression e) {
        return e.getOutput().getDim1() != -1L && e.getOutput().getDim2() != -1L;
    }

    private void check1DMatrixParam(Expression e) {
        this.checkMatrixParam(e);
        if (BuiltinFunctionExpression.dimsKnown(e) && !BuiltinFunctionExpression.is1DMatrix(e)) {
            this.raiseValidateError("Expecting one-dimensional matrix parameter for function " + this.getOpCode(), false, "Unsupported Parameters");
        }
    }

    private void checkMatchingDimensions(Expression expr1, Expression expr2) {
        this.checkMatchingDimensions(expr1, expr2, false);
    }

    private void checkMatchingDimensions(Expression expr1, Expression expr2, boolean allowsMV) {
        this.checkMatchingDimensions(expr1, expr2, allowsMV, false);
    }

    private void checkMatchingDimensions(Expression expr1, Expression expr2, boolean allowsMV, boolean conditional) {
        if (expr1 != null && expr2 != null) {
            if (expr1.getOutput().getDim1() == -1L || expr2.getOutput().getDim1() == -1L || expr1.getOutput().getDim2() == -1L || expr2.getOutput().getDim2() == -1L) {
                return;
            }
            if (!allowsMV && expr1.getOutput().getDim1() != expr2.getOutput().getDim1() || allowsMV && expr1.getOutput().getDim1() != expr2.getOutput().getDim1() && expr2.getOutput().getDim1() != 1L || !allowsMV && expr1.getOutput().getDim2() != expr2.getOutput().getDim2() || allowsMV && expr1.getOutput().getDim2() != expr2.getOutput().getDim2() && expr2.getOutput().getDim2() != 1L) {
                this.raiseValidateError("Mismatch in matrix dimensions of parameters for function " + this.getOpCode(), conditional, "Invalid Parameters");
            }
        }
    }

    private void checkMatchingDimensionsQuantile() {
        if (this.getFirstExpr().getOutput().getDim1() != this.getSecondExpr().getOutput().getDim1()) {
            this.raiseValidateError("Mismatch in matrix dimensions for " + this.getOpCode(), false, "Invalid Parameters");
        }
    }

    public static BuiltinFunctionExpression getBuiltinFunctionExpression(ParserRuleContext ctx, String functionName, ArrayList<ParameterExpression> paramExprsPassed, String filename) {
        if (functionName == null || paramExprsPassed == null) {
            return null;
        }
        return Builtins.contains(functionName, false, false) && (paramExprsPassed.stream().anyMatch(p -> p.getName() == null) || paramExprsPassed.size() == 0) ? new BuiltinFunctionExpression(ctx, Builtins.get(functionName), paramExprsPassed, filename) : null;
    }

    public static Builtins getValueTypeCastOperator(Types.ValueType vt) {
        switch (vt) {
            case FP64: {
                return Builtins.CAST_AS_DOUBLE;
            }
            case INT64: {
                return Builtins.CAST_AS_INT;
            }
            case BOOLEAN: {
                return Builtins.CAST_AS_BOOLEAN;
            }
        }
        throw new LanguageException("No cast for value type " + vt);
    }
}

