/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.paramserv.homomorphicEncryption;

import java.util.Arrays;
import org.apache.sysds.common.Types;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.paramserv.NativeHEHelper;
import org.apache.sysds.runtime.controlprogram.paramserv.homomorphicEncryption.PublicKey;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.data.DenseBlockFactory;
import org.apache.sysds.runtime.instructions.cp.CiphertextMatrix;
import org.apache.sysds.runtime.instructions.cp.Encrypted;
import org.apache.sysds.runtime.instructions.cp.PlaintextMatrix;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.meta.DataCharacteristics;
import org.apache.sysds.runtime.meta.MetaDataFormat;

public class SEALServer {
    private final long ctx = NativeHEHelper.initServer();
    private byte[] _a;

    public synchronized byte[] generateA() {
        if (this._a == null) {
            this._a = NativeHEHelper.generateA(this.ctx);
        }
        return this._a;
    }

    public PublicKey aggregatePartialPublicKeys(PublicKey[] partial_public_keys) {
        return new PublicKey(NativeHEHelper.aggregatePartialPublicKeys(this.ctx, SEALServer.extractRawData(partial_public_keys)));
    }

    public CiphertextMatrix accumulateCiphertexts(CiphertextMatrix[] ciphertexts) {
        return new CiphertextMatrix(ciphertexts[0].getDims(), ciphertexts[0].getDataCharacteristics(), NativeHEHelper.accumulateCiphertexts(this.ctx, SEALServer.extractRawData(ciphertexts)));
    }

    public MatrixObject average(CiphertextMatrix encrypted_sum, PlaintextMatrix[] partial_plaintexts) {
        double[] raw_result = NativeHEHelper.average(this.ctx, encrypted_sum.getData(), SEALServer.extractRawData(partial_plaintexts));
        int[] dims = encrypted_sum.getDims();
        int result_len = Arrays.stream(dims).reduce(1, (x, y) -> x * y);
        DataCharacteristics dc = encrypted_sum.getDataCharacteristics();
        DenseBlock new_dense_block = DenseBlockFactory.createDenseBlock(Arrays.copyOf(raw_result, result_len), dims);
        MatrixBlock new_matrix_block = new MatrixBlock((int)dc.getRows(), (int)dc.getCols(), new_dense_block);
        MatrixObject new_mo = new MatrixObject(Types.ValueType.FP64, OptimizerUtils.getUniqueTempFileName(), new MetaDataFormat(dc, Types.FileFormat.BINARY));
        new_mo.acquireModify(new_matrix_block);
        new_mo.release();
        return new_mo;
    }

    private static byte[][] extractRawData(Encrypted[] data) {
        byte[][] raw_data = new byte[data.length][];
        for (int i = 0; i < data.length; ++i) {
            raw_data[i] = data[i].getData();
        }
        return raw_data;
    }

    private static byte[][] extractRawData(PublicKey[] data) {
        byte[][] raw_data = new byte[data.length][];
        for (int i = 0; i < data.length; ++i) {
            raw_data[i] = data[i].getData();
        }
        return raw_data;
    }
}

