/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.sysds.common.Types;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.io.FileFormatPropertiesCSV;
import org.apache.sysds.runtime.io.FrameReaderTextCSV;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.matrix.data.Pair;
import org.apache.sysds.runtime.util.CommonThreadPool;

public class FrameReaderTextCSVParallel
extends FrameReaderTextCSV {
    public FrameReaderTextCSVParallel(FileFormatPropertiesCSV props) {
        super(props);
    }

    @Override
    protected void readCSVFrameFromHDFS(Path path, JobConf job, FileSystem fs, FrameBlock dest, Types.ValueType[] schema, String[] names, long rlen, long clen) throws IOException {
        int numThreads = OptimizerUtils.getParallelTextReadParallelism();
        TextInputFormat informat = new TextInputFormat();
        informat.configure(job);
        InputSplit[] splits = informat.getSplits(job, numThreads);
        splits = IOUtilFunctions.sortInputSplits(splits);
        try {
            ExecutorService pool = CommonThreadPool.get(numThreads);
            ArrayList<CountRowsTask> tasks = new ArrayList<CountRowsTask>();
            for (int i = 0; i < splits.length; ++i) {
                tasks.add(new CountRowsTask(splits[i], informat, job, this._props.hasHeader() && i == 0, clen));
            }
            List cret = pool.invokeAll(tasks);
            long offset = 0L;
            ArrayList<Long> offsets = new ArrayList<Long>();
            for (Future count : cret) {
                offsets.add(offset);
                offset += (long)((Integer)count.get()).intValue();
            }
            ArrayList<ReadRowsTask> tasks2 = new ArrayList<ReadRowsTask>();
            for (int i = 0; i < splits.length; ++i) {
                tasks2.add(new ReadRowsTask(splits[i], informat, job, dest, ((Long)offsets.get(i)).intValue(), i == 0));
            }
            CommonThreadPool.invokeAndShutdown(pool, tasks2);
        }
        catch (Exception e) {
            throw new IOException("Failed parallel read of text csv input.", e);
        }
    }

    @Override
    protected Pair<Integer, Integer> computeCSVSize(Path path, JobConf job, FileSystem fs) throws IOException {
        int numThreads = OptimizerUtils.getParallelTextReadParallelism();
        TextInputFormat informat = new TextInputFormat();
        informat.configure(job);
        InputSplit[] splits = informat.getSplits(job, numThreads);
        int ncol = IOUtilFunctions.countNumColumnsCSV(splits, (InputFormat)informat, job, this._props.getDelim());
        long nrow = 0L;
        ExecutorService pool = CommonThreadPool.get(numThreads);
        try {
            ArrayList<CountRowsTask> tasks = new ArrayList<CountRowsTask>();
            for (int i = 0; i < splits.length; ++i) {
                tasks.add(new CountRowsTask(splits[i], informat, job, this._props.hasHeader() && i == 0, ncol));
            }
            List cret = pool.invokeAll(tasks);
            for (Future count : cret) {
                nrow += (long)((Integer)count.get()).intValue();
            }
        }
        catch (Exception e) {
            throw new IOException("Failed parallel read of text csv input.", e);
        }
        finally {
            pool.shutdown();
        }
        if (nrow > Integer.MAX_VALUE) {
            throw new DMLRuntimeException("invalid read with over Integer number of rows");
        }
        return new Pair<Integer, Integer>((int)nrow, ncol);
    }

    private class ReadRowsTask
    implements Callable<Object> {
        private InputSplit _split = null;
        private TextInputFormat _informat = null;
        private JobConf _job = null;
        private FrameBlock _dest = null;
        private int _offset = -1;
        private boolean _isFirstSplit = false;

        public ReadRowsTask(InputSplit split, TextInputFormat informat, JobConf job, FrameBlock dest, int offset, boolean first) {
            this._split = split;
            this._informat = informat;
            this._job = job;
            this._dest = dest;
            this._offset = offset;
            this._isFirstSplit = first;
        }

        @Override
        public Object call() throws Exception {
            try {
                FrameReaderTextCSVParallel.this.readCSVFrameFromInputSplit(this._split, (InputFormat<LongWritable, Text>)this._informat, this._job, this._dest, this._dest.getSchema(), this._dest.getColumnNames(), this._dest.getNumRows(), this._dest.getNumColumns(), this._offset, this._isFirstSplit);
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
    }

    private static class CountRowsTask
    implements Callable<Integer> {
        private final InputSplit _split;
        private final TextInputFormat _informat;
        private final JobConf _job;
        private final boolean _hasHeader;
        private final long _nCol;

        public CountRowsTask(InputSplit split, TextInputFormat informat, JobConf job, boolean hasHeader, long nCol) {
            this._split = split;
            this._informat = informat;
            this._job = job;
            this._hasHeader = hasHeader;
            this._nCol = nCol;
        }

        @Override
        public Integer call() throws Exception {
            return FrameReaderTextCSV.countLinesInReader(this._split, this._informat, this._job, this._nCol, this._hasHeader);
        }
    }
}

