/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.transform.tokenize;

import java.util.ArrayList;
import java.util.List;
import org.apache.sysds.runtime.DMLRuntimeException;

public class Token {
    public static final String EMPTY_TOKEN = "";
    private List<SubToken> subTokens;

    private Token(int subListSize) {
        this.subTokens = new ArrayList<SubToken>(subListSize);
    }

    public Token(String token, long startIndex) {
        this(1);
        this.subTokens.add(new SubToken(token, startIndex));
    }

    public Token(List<String> tokens, List<Long> startIndex) {
        this(tokens.size());
        if (tokens.size() != startIndex.size()) {
            throw new DMLRuntimeException("Cannot create token from mismatched input sizes");
        }
        for (int i = 0; i < tokens.size(); ++i) {
            this.subTokens.add(new SubToken(tokens.get(i), startIndex.get(i)));
        }
    }

    public Token(List<Token> subList) {
        this(Token.getNumSubTokens(subList));
        for (Token token : subList) {
            this.subTokens.addAll(token.subTokens);
        }
    }

    private static int getNumSubTokens(List<Token> tokens) {
        int sum = 0;
        for (Token token : tokens) {
            sum += token.getNumSubTokens();
        }
        return sum;
    }

    public int getNumSubTokens() {
        return this.subTokens.size();
    }

    public long getStartIndex(int subTokenIndex) {
        return this.subTokens.get((int)subTokenIndex).startIndex;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        if (this.subTokens.size() == 0) {
            return EMPTY_TOKEN;
        }
        if (this.subTokens.size() == 1) {
            return this.subTokens.get((int)0).text;
        }
        StringBuilder sb = new StringBuilder().append("\"('");
        for (int i = 0; i < this.subTokens.size(); ++i) {
            sb.append(this.subTokens.get((int)i).text);
            if (i >= this.subTokens.size() - 1) continue;
            sb.append("', '");
        }
        sb.append("')\"");
        return sb.toString();
    }

    public static class SubToken {
        private final String text;
        private final long startIndex;
        private final long endIndex;

        public SubToken(String token, long startIndex) {
            this.text = token;
            this.startIndex = startIndex;
            this.endIndex = startIndex + (long)token.length();
        }

        public String toString() {
            return "SubToken{textToken='" + this.text + "', startIndex=" + this.startIndex + ", endIndex=" + this.endIndex + "}";
        }
    }
}

