/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.iogen.template;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.io.MatrixReader;
import org.apache.sysds.runtime.iogen.CustomProperties;
import org.apache.sysds.runtime.iogen.RowIndexStructure;
import org.apache.sysds.runtime.iogen.template.TemplateUtil;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.data.Pair;

public abstract class MatrixGenerateReader
extends MatrixReader {
    protected static CustomProperties _props;
    protected TemplateUtil.SplitOffsetInfos _offsets;

    public MatrixGenerateReader(CustomProperties _props) {
        MatrixGenerateReader._props = _props;
    }

    @Override
    public MatrixBlock readMatrixFromHDFS(String fname, long rlen, long clen, int blen, long estnnz) throws IOException, DMLRuntimeException {
        JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
        Path path = new Path(fname);
        FileSystem fs = IOUtilFunctions.getFileSystem(path, (Configuration)job);
        FileInputFormat.addInputPath((JobConf)job, (Path)path);
        MatrixGenerateReader.checkValidInputFile(fs, path);
        TextInputFormat informat = new TextInputFormat();
        informat.configure(job);
        InputSplit[] splits = informat.getSplits(job, 1);
        splits = IOUtilFunctions.sortInputSplits(splits);
        MatrixBlock ret = rlen >= 0L && (_props.getRowIndexStructure().getProperties() != RowIndexStructure.IndexProperties.SeqScatter || _props.getRowIndexStructure().getProperties() == RowIndexStructure.IndexProperties.CellWiseExist || _props.getRowIndexStructure().getProperties() == RowIndexStructure.IndexProperties.RowWiseExist) ? MatrixGenerateReader.createOutputMatrixBlock(rlen, clen, (int)rlen, estnnz, true, false) : this.computeSizeAndCreateOutputMatrixBlock(informat, job, splits, estnnz);
        this.readMatrixFromHDFS(informat, splits, job, ret);
        return ret;
    }

    @Override
    public MatrixBlock readMatrixFromInputStream(InputStream is, long rlen, long clen, int blen, long estnnz) throws IOException, DMLRuntimeException {
        MatrixBlock ret = null;
        if (rlen >= 0L && clen >= 0L) {
            ret = MatrixGenerateReader.createOutputMatrixBlock(rlen, clen, (int)rlen, estnnz, true, false);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MatrixBlock computeSizeAndCreateOutputMatrixBlock(TextInputFormat informat, JobConf job, InputSplit[] splits, long estnnz) throws IOException, DMLRuntimeException {
        int row;
        block34: {
            row = 0;
            try {
                if (_props.getRowIndexStructure().getProperties() == RowIndexStructure.IndexProperties.Identity) {
                    for (InputSplit inputSplit : splits) {
                        RecordReader reader = informat.getRecordReader(inputSplit, job, Reporter.NULL);
                        LongWritable key = new LongWritable();
                        Text value = new Text();
                        try {
                            while (reader.next((Object)key, (Object)value)) {
                                ++row;
                            }
                        }
                        finally {
                            IOUtilFunctions.closeSilently(reader);
                        }
                    }
                    break block34;
                }
                if (_props.getRowIndexStructure().getProperties() == RowIndexStructure.IndexProperties.CellWiseExist || _props.getRowIndexStructure().getProperties() == RowIndexStructure.IndexProperties.RowWiseExist) {
                    int mxRow = 0;
                    for (InputSplit inputSplit : splits) {
                        RecordReader reader = informat.getRecordReader(inputSplit, job, Reporter.NULL);
                        LongWritable key = new LongWritable();
                        Text value = new Text();
                        try {
                            int endPos;
                            String strValue;
                            if (_props.getRowIndexStructure().getKeyPattern().size() == 1) {
                                if (_props.getRowIndexStructure().getKeyPattern().get(0).length() != 0) continue;
                                while (reader.next((Object)key, (Object)value)) {
                                    int rowValue;
                                    strValue = value.toString();
                                    endPos = TemplateUtil.getEndPos(strValue, strValue.length(), 0, _props.getRowIndexStructure().endWithValueString());
                                    try {
                                        rowValue = Integer.parseInt(strValue.substring(0, endPos));
                                    }
                                    catch (Exception ex) {
                                        rowValue = 0;
                                    }
                                    mxRow = Math.max(mxRow, rowValue);
                                }
                                continue;
                            }
                            while (reader.next((Object)key, (Object)value)) {
                                int rowValue;
                                strValue = value.toString();
                                int index = 0;
                                for (int i = 0; i < _props.getRowIndexStructure().getKeyPattern().size() && index != -1; ++i) {
                                    index = strValue.indexOf(_props.getRowIndexStructure().getKeyPattern().get(i), index);
                                }
                                if (index == -1) continue;
                                endPos = TemplateUtil.getEndPos(strValue, strValue.length(), _props.getRowIndexStructure().getKeyPattern().get(_props.getRowIndexStructure().getKeyPattern().size() - 1).length() + index, _props.getRowIndexStructure().endWithValueString());
                                try {
                                    rowValue = Integer.parseInt(strValue.substring(0, endPos));
                                }
                                catch (Exception ex) {
                                    rowValue = 0;
                                }
                                mxRow = Math.max(mxRow, rowValue);
                            }
                        }
                        finally {
                            IOUtilFunctions.closeSilently(reader);
                        }
                    }
                    row = mxRow;
                    break block34;
                }
                if (_props.getRowIndexStructure().getProperties() == RowIndexStructure.IndexProperties.SeqScatter) {
                    this._offsets = new TemplateUtil.SplitOffsetInfos(splits.length);
                    int splitIndex = 0;
                    for (InputSplit inputSplit : splits) {
                        int i;
                        ArrayList<Object> endIndexes;
                        int nrows = 0;
                        TemplateUtil.SplitInfo splitInfo = new TemplateUtil.SplitInfo();
                        ArrayList<Pair<Long, Integer>> beginIndexes = TemplateUtil.getTokenIndexOnMultiLineRecords(inputSplit, informat, job, _props.getRowIndexStructure().getSeqBeginString()).getKey();
                        int tokenLength = 0;
                        boolean diffBeginEndToken = false;
                        if (!_props.getRowIndexStructure().getSeqBeginString().equals(_props.getRowIndexStructure().getSeqEndString())) {
                            endIndexes = TemplateUtil.getTokenIndexOnMultiLineRecords(inputSplit, informat, job, _props.getRowIndexStructure().getSeqEndString()).getKey();
                            tokenLength = _props.getRowIndexStructure().getSeqEndString().length();
                            diffBeginEndToken = true;
                        } else {
                            endIndexes = new ArrayList();
                            for (i = 1; i < beginIndexes.size(); ++i) {
                                endIndexes.add(beginIndexes.get(i));
                            }
                        }
                        beginIndexes.remove(beginIndexes.size() - 1);
                        i = 0;
                        int j = 0;
                        if (beginIndexes.get(0).getKey() > (Long)((Pair)endIndexes.get(0)).getKey()) {
                            ++j;
                        }
                        while (i < beginIndexes.size() && j < endIndexes.size()) {
                            Pair<Long, Integer> p1 = beginIndexes.get(i);
                            Pair p2 = (Pair)endIndexes.get(j);
                            int n = 0;
                            while (p1.getKey() < (Long)p2.getKey() || p1.getKey() == p2.getKey() && p1.getValue() < (Integer)p2.getValue()) {
                                ++n;
                                if (++i == beginIndexes.size()) break;
                                p1 = beginIndexes.get(i);
                            }
                            splitInfo.addIndexAndPosition(beginIndexes.get(i - n).getKey(), (Long)((Pair)endIndexes.get(j += n - 1)).getKey(), beginIndexes.get(i - n).getValue(), (Integer)((Pair)endIndexes.get(j)).getValue() + tokenLength);
                            ++j;
                            ++nrows;
                        }
                        if (!diffBeginEndToken && i == beginIndexes.size() && j < endIndexes.size()) {
                            ++nrows;
                        }
                        if (beginIndexes.get(0).getKey() == 0L && beginIndexes.get(0).getValue() == 0) {
                            splitInfo.setRemainString("");
                        } else {
                            RecordReader reader = informat.getRecordReader(inputSplit, job, Reporter.NULL);
                            LongWritable key = new LongWritable();
                            Text value = new Text();
                            StringBuilder sb = new StringBuilder();
                            int ri = 0;
                            while ((long)ri < beginIndexes.get(0).getKey()) {
                                reader.next((Object)key, (Object)value);
                                String raw = value.toString();
                                sb.append(raw);
                                ++ri;
                            }
                            if (beginIndexes.get(0).getValue() != 0) {
                                reader.next((Object)key, (Object)value);
                                sb.append(value.toString().substring(0, beginIndexes.get(0).getValue()));
                            }
                            splitInfo.setRemainString(sb.toString());
                        }
                        splitInfo.setNrows(nrows);
                        this._offsets.setSeqOffsetPerSplit(splitIndex, splitInfo);
                        this._offsets.setOffsetPerSplit(splitIndex, row);
                        row += nrows;
                        ++splitIndex;
                    }
                }
            }
            catch (Exception e) {
                throw new IOException("Thread pool Error " + e.getMessage(), e);
            }
        }
        MatrixBlock ret = MatrixGenerateReader.createOutputMatrixBlock(row, _props.getNcols(), row, estnnz, true, false);
        return ret;
    }

    protected void readMatrixFromHDFS(TextInputFormat informat, InputSplit[] splits, JobConf job, MatrixBlock dest) throws IOException {
        MutableInt row = new MutableInt(0);
        long lnnz = 0L;
        for (int i = 0; i < splits.length; ++i) {
            RecordReader reader = informat.getRecordReader(splits[i], job, Reporter.NULL);
            LongWritable key = new LongWritable();
            Text value = new Text();
            TemplateUtil.SplitInfo splitInfo = null;
            if (_props.getRowIndexStructure().getProperties() == RowIndexStructure.IndexProperties.SeqScatter) {
                splitInfo = this._offsets.getSeqOffsetPerSplit(i);
                row.setValue(this._offsets.getOffsetPerSplit(i));
            }
            lnnz += this.readMatrixFromHDFS((RecordReader<LongWritable, Text>)reader, key, value, dest, row, splitInfo);
        }
        dest.setNonZeros(lnnz);
    }

    protected abstract long readMatrixFromHDFS(RecordReader<LongWritable, Text> var1, LongWritable var2, Text var3, MatrixBlock var4, MutableInt var5, TemplateUtil.SplitInfo var6) throws IOException;
}

