/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.scheme;

import org.apache.sysds.runtime.compress.DMLCompressionException;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.ColGroupDDC;
import org.apache.sysds.runtime.compress.colgroup.dictionary.DictionaryFactory;
import org.apache.sysds.runtime.compress.colgroup.indexes.ColIndexFactory;
import org.apache.sysds.runtime.compress.colgroup.indexes.IColIndex;
import org.apache.sysds.runtime.compress.colgroup.mapping.AMapToData;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToFactory;
import org.apache.sysds.runtime.compress.colgroup.scheme.DDCScheme;
import org.apache.sysds.runtime.compress.colgroup.scheme.ICLAScheme;
import org.apache.sysds.runtime.compress.readers.ReaderColumnSelection;
import org.apache.sysds.runtime.compress.utils.ACount;
import org.apache.sysds.runtime.compress.utils.DblArray;
import org.apache.sysds.runtime.compress.utils.DblArrayCountHashMap;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.data.Pair;

public class DDCSchemeMC
extends DDCScheme {
    private final DblArray emptyRow;
    private final DblArrayCountHashMap map;

    private DDCSchemeMC(IColIndex cols, DblArrayCountHashMap map) {
        super(cols);
        this.map = map;
        this.emptyRow = new DblArray(new double[cols.size()]);
    }

    protected DDCSchemeMC(ColGroupDDC g) {
        super(g.getColIndices());
        this.lastDict = g.getDictionary();
        MatrixBlock mbDict = this.lastDict.getMBDict(this.cols.size()).getMatrixBlock();
        int dictRows = mbDict.getNumRows();
        int dictCols = mbDict.getNumColumns();
        this.map = new DblArrayCountHashMap(dictRows * 2);
        ReaderColumnSelection r = ReaderColumnSelection.createReader(mbDict, ColIndexFactory.create(dictCols), false, 0, dictRows);
        DblArray d = null;
        while ((d = r.nextRow()) != null) {
            this.map.increment(d);
        }
        this.emptyRow = new DblArray(new double[dictCols]);
    }

    protected DDCSchemeMC(IColIndex cols) {
        super(cols);
        int nCol = cols.size();
        this.map = new DblArrayCountHashMap(4);
        this.emptyRow = new DblArray(new double[nCol]);
    }

    @Override
    protected final Object getMap() {
        return this.map;
    }

    @Override
    protected ICLAScheme updateV(MatrixBlock data, IColIndex columns) {
        int nRow = data.getNumRows();
        ReaderColumnSelection reader = ReaderColumnSelection.createReader(data, columns, false, 0, nRow);
        return this.update(data, reader, nRow, columns);
    }

    @Override
    protected AColGroup encodeV(MatrixBlock data, IColIndex columns) {
        int nRow = data.getNumRows();
        ReaderColumnSelection reader = ReaderColumnSelection.createReader(data, columns, false, 0, nRow);
        return this.encode(data, reader, nRow, columns);
    }

    @Override
    protected Pair<ICLAScheme, AColGroup> tryUpdateAndEncode(MatrixBlock data, IColIndex columns) {
        int nRow = data.getNumRows();
        ReaderColumnSelection reader = ReaderColumnSelection.createReader(data, columns, false, 0, nRow);
        return this.tryUpdateAndEncode(data, reader, nRow, columns);
    }

    @Override
    protected AColGroup encodeVT(MatrixBlock data, IColIndex columns) {
        int nRow = data.getNumColumns();
        ReaderColumnSelection reader = ReaderColumnSelection.createReader(data, columns, true, 0, nRow);
        return this.encode(data, reader, nRow, columns);
    }

    private AColGroup encode(MatrixBlock data, ReaderColumnSelection reader, int nRow, IColIndex columns) {
        AMapToData d = MapToFactory.create(nRow, this.map.size());
        ACount<DblArray> emptyIdx = this.map.getC(this.emptyRow);
        if (emptyIdx == null) {
            DblArray cellVals;
            while ((cellVals = reader.nextRow()) != null) {
                int row = reader.getCurrentRowIndex();
                int id = this.map.getId(cellVals);
                d.set(row, id);
            }
        } else {
            DblArray cellVals;
            int r = 0;
            while ((cellVals = reader.nextRow()) != null) {
                int row = reader.getCurrentRowIndex();
                if (row != r) {
                    while (r < row) {
                        d.set(r++, emptyIdx.id);
                    }
                }
                int id = this.map.getId(cellVals);
                d.set(row, id);
                ++r;
            }
            while (r < nRow) {
                d.set(r++, emptyIdx.id);
            }
        }
        if (this.lastDict == null || this.lastDict.getNumberOfValues(columns.size()) != this.map.size()) {
            this.lastDict = DictionaryFactory.create(this.map, columns.size(), false, data.getSparsity());
        }
        return ColGroupDDC.create(columns, this.lastDict, d, null);
    }

    @Override
    protected ICLAScheme updateVT(MatrixBlock data, IColIndex columns) {
        int nRow = data.getNumColumns();
        ReaderColumnSelection reader = ReaderColumnSelection.createReader(data, columns, true, 0, nRow);
        return this.update(data, reader, nRow, columns);
    }

    private ICLAScheme update(MatrixBlock data, ReaderColumnSelection reader, int nRow, IColIndex columns) {
        DblArray d = null;
        int r = 0;
        while ((d = reader.nextRow()) != null) {
            int cr = reader.getCurrentRowIndex();
            if (cr != r) {
                this.map.increment(this.emptyRow, cr - r);
                r = cr;
            }
            this.map.increment(d);
            ++r;
        }
        if (r < nRow) {
            this.map.increment(this.emptyRow, nRow - r - 1);
        }
        return this;
    }

    @Override
    protected Pair<ICLAScheme, AColGroup> tryUpdateAndEncodeT(MatrixBlock data, IColIndex columns) {
        int nRow = data.getNumColumns();
        ReaderColumnSelection reader = ReaderColumnSelection.createReader(data, columns, true, 0, nRow);
        return this.tryUpdateAndEncode(data, reader, nRow, columns);
    }

    private Pair<ICLAScheme, AColGroup> tryUpdateAndEncode(MatrixBlock data, ReaderColumnSelection reader, int nRow, IColIndex columns) {
        AMapToData d = MapToFactory.create(nRow, this.map.size());
        int max = d.getMaxPossible();
        ACount<DblArray> emptyIdx = this.map.getC(this.emptyRow);
        if (emptyIdx == null) {
            DblArray cellVals;
            while ((cellVals = reader.nextRow()) != null) {
                int row = reader.getCurrentRowIndex();
                int id = this.map.increment(cellVals);
                if (id >= max) {
                    throw new DMLCompressionException("Failed update and encode with " + max + " possible values");
                }
                d.set(row, id);
            }
        } else {
            DblArray cellVals;
            int r = 0;
            while ((cellVals = reader.nextRow()) != null) {
                int id;
                int row = reader.getCurrentRowIndex();
                if (row != r) {
                    this.map.increment(this.emptyRow, row - r);
                    while (r < row) {
                        d.set(r++, emptyIdx.id);
                    }
                }
                if ((id = this.map.increment(cellVals)) >= max) {
                    throw new DMLCompressionException("Failed update and encode with " + max + " possible values" + this.map + " " + this.map.size());
                }
                d.set(row, id);
                ++r;
            }
            if (r < nRow) {
                this.map.increment(this.emptyRow, nRow - r);
            }
            while (r < nRow) {
                d.set(r++, emptyIdx.id);
            }
        }
        if (this.lastDict == null || this.lastDict.getNumberOfValues(columns.size()) != this.map.size()) {
            this.lastDict = DictionaryFactory.create(this.map, columns.size(), false, data.getSparsity());
        }
        AColGroup g = ColGroupDDC.create(columns, this.lastDict, d, null);
        DDCSchemeMC s = this;
        return new Pair<ICLAScheme, AColGroup>(s, g);
    }

    @Override
    public DDCSchemeMC clone() {
        return new DDCSchemeMC(this.cols, this.map.clone());
    }
}

