/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.lineage;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.sysds.api.DMLScript;
import org.apache.sysds.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysds.runtime.instructions.spark.data.LineageObject;
import org.apache.sysds.runtime.instructions.spark.data.RDDObject;
import org.apache.sysds.runtime.lineage.LineageCacheConfig;
import org.apache.sysds.runtime.lineage.LineageCacheEntry;
import org.apache.sysds.runtime.lineage.LineageCacheEviction;
import org.apache.sysds.runtime.lineage.LineageCacheStatistics;
import org.apache.sysds.runtime.lineage.LineageItem;
import org.apache.sysds.runtime.util.CommonThreadPool;

public class LineageSparkCacheEviction {
    private static long SPARK_STORAGE_LIMIT = 0L;
    private static long _sparkStorageSize = 0L;
    private static TreeSet<LineageCacheEntry> weightedQueue = new TreeSet<LineageCacheEntry>(LineageCacheConfig.LineageCacheComparator);
    protected static final Map<LineageItem, Integer> RDDHitCountLocal = new HashMap<LineageItem, Integer>();

    protected static void resetEviction() {
        _sparkStorageSize = 0L;
        weightedQueue.clear();
        RDDHitCountLocal.clear();
    }

    protected static void addEntry(LineageCacheEntry entry, long estimatedSize) {
        if (entry.isNullVal()) {
            return;
        }
        entry.initiateScoreSpark(LineageCacheEviction._removelist, estimatedSize);
        weightedQueue.add(entry);
    }

    protected static void maintainOrder(LineageCacheEntry entry) {
        if (LineageCacheConfig.isTimeBased() && weightedQueue.remove(entry)) {
            entry.updateTimestamp();
            weightedQueue.add(entry);
        }
        if (LineageCacheConfig.isCostNsize() && weightedQueue.remove(entry)) {
            entry.updateScore(true);
            weightedQueue.add(entry);
        }
    }

    protected static void removeSingleEntry(Map<LineageItem, LineageCacheEntry> cache, LineageCacheEntry e) {
        e.setCacheStatus(LineageCacheConfig.LineageCacheStatus.TOPERSISTRDD);
        JavaPairRDD<?, ?> rdd = e.getRDDObject().getRDD();
        rdd.unpersist(false);
        _sparkStorageSize -= e.getSize();
        LineageCacheEviction._removelist.merge(e._key, 1, Integer::sum);
        if (DMLScript.STATISTICS) {
            LineageCacheStatistics.incrementRDDUnpersists();
        }
    }

    private static void removeEntry(Map<LineageItem, LineageCacheEntry> cache, LineageCacheEntry e) {
        if (e._origItem == null) {
            LineageSparkCacheEviction.removeSingleEntry(cache, e);
            return;
        }
        e.setCacheStatus(LineageCacheConfig.LineageCacheStatus.TODELETE);
        boolean del = false;
        LineageCacheEntry tmp = cache.get(e._origItem);
        while (tmp != null) {
            if (tmp.getCacheStatus() != LineageCacheConfig.LineageCacheStatus.TODELETE) {
                return;
            }
            del |= tmp.getCacheStatus() == LineageCacheConfig.LineageCacheStatus.TODELETE;
            tmp = tmp._nextEntry;
        }
        if (del) {
            tmp = cache.get(e._origItem);
            while (tmp != null) {
                LineageSparkCacheEviction.removeSingleEntry(cache, tmp);
                tmp = tmp._nextEntry;
            }
        }
    }

    private static void setSparkStorageLimit() {
        if (SPARK_STORAGE_LIMIT == 0L) {
            long unifiedSparkMem = (long)SparkExecutionContext.getDataMemoryBudget(false, true);
            SPARK_STORAGE_LIMIT = (long)((double)unifiedSparkMem * 0.7);
        }
    }

    protected static double getSparkStorageLimit() {
        if (SPARK_STORAGE_LIMIT == 0L) {
            LineageSparkCacheEviction.setSparkStorageLimit();
        }
        return SPARK_STORAGE_LIMIT;
    }

    protected static void updateSize(long space, boolean addspace) {
        _sparkStorageSize += addspace ? space : -space;
    }

    protected static boolean isBelowThreshold(long estimateSize) {
        boolean available;
        boolean bl = available = (double)(estimateSize + _sparkStorageSize) <= LineageSparkCacheEviction.getSparkStorageLimit();
        if (!available) {
            _sparkStorageSize = SparkExecutionContext.getStorageSpaceUsed();
        }
        return (double)(estimateSize + _sparkStorageSize) <= LineageSparkCacheEviction.getSparkStorageLimit();
    }

    protected static void makeSpace(Map<LineageItem, LineageCacheEntry> cache, long estimatedSize) {
        LineageCacheEntry e;
        while ((double)(estimatedSize + _sparkStorageSize) > LineageSparkCacheEviction.getSparkStorageLimit() && (e = weightedQueue.pollFirst()) != null) {
            LineageSparkCacheEviction.removeEntry(cache, e);
        }
    }

    protected static void cleanupChildRDDs(LineageCacheEntry e) {
        if (e.getCacheStatus() == LineageCacheConfig.LineageCacheStatus.PERSISTEDRDD) {
            for (LineageObject c : e.getRDDObject().getLineageChilds()) {
                c.decrementNumReferences();
                LineageSparkCacheEviction.rCleanupChildRDDs(c);
            }
            e.getRDDObject().removeAllChild();
        }
    }

    protected static void rCleanupChildRDDs(LineageObject lob) {
        if (lob.getNumReferences() > 0) {
            return;
        }
        if (lob.hasBackReference()) {
            return;
        }
        if (lob instanceof RDDObject && lob.isInLineageCache() && SparkExecutionContext.isRDDCached(((RDDObject)lob).getRDD().id())) {
            return;
        }
        SparkExecutionContext.cleanupSingleLineageObject(lob);
        for (LineageObject c : lob.getLineageChilds()) {
            c.decrementNumReferences();
            LineageSparkCacheEviction.rCleanupChildRDDs(c);
        }
    }

    protected static void moveToSpark(LineageCacheEntry e) {
        RDDHitCountLocal.merge(e._key, 1, Integer::sum);
        int localHitCount = RDDHitCountLocal.get(e._key);
        if (localHitCount > 3) {
            RDDHitCountLocal.remove(e._key);
            CommonThreadPool.getDynamicPool().submit(new TriggerRemoteTask(e.getRDDObject().getRDD()));
        }
    }

    private static class TriggerRemoteTask
    implements Runnable {
        JavaPairRDD<?, ?> rdd;

        public TriggerRemoteTask(JavaPairRDD<?, ?> persistRDD) {
            this.rdd = persistRDD;
        }

        @Override
        public void run() {
            this.rdd.count();
        }
    }
}

