/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.sysds.common.Types;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.io.FrameWriterJSONL;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.util.CommonThreadPool;
import org.apache.sysds.runtime.util.HDFSTool;
import org.apache.sysds.utils.stats.InfrastructureAnalyzer;
import org.apache.wink.json4j.JSONException;

public class FrameWriterJSONLParallel
extends FrameWriterJSONL {
    @Override
    protected void writeJSONLFrameToHDFS(Path path, JobConf jobConf, FrameBlock src, long rlen, long clen, Map<String, Integer> schemaMap) throws IOException, JSONException {
        int numPartFiles = Math.max((int)(OptimizerUtils.estimateSizeTextOutput(rlen, clen, rlen * clen, Types.FileFormat.JSONL) / InfrastructureAnalyzer.getHDFSBlockSize()), 1);
        int numThreads = OptimizerUtils.getParallelTextWriteParallelism();
        if ((numThreads = Math.min(numThreads, numPartFiles)) <= 1) {
            super.writeJSONLFrameToHDFS(path, jobConf, src, rlen, clen, schemaMap);
            return;
        }
        HDFSTool.createDirIfNotExistOnHDFS(path, "777");
        FileSystem fileSystem = IOUtilFunctions.getFileSystem(path, (Configuration)jobConf);
        ExecutorService pool = CommonThreadPool.get(numThreads);
        try {
            ArrayList<WriteFileTask> tasks = new ArrayList<WriteFileTask>();
            int blklen = (int)Math.ceil((double)rlen / (double)numThreads);
            int i = 0;
            while (i < numThreads & (long)(i * blklen) < rlen) {
                Path newPath = new Path(path, IOUtilFunctions.getPartFileName(i));
                tasks.add(new WriteFileTask(newPath, fileSystem, src, i * blklen, (int)Math.min((long)((i + 1) * blklen), rlen), schemaMap));
                ++i;
            }
            for (Future task : pool.invokeAll(tasks)) {
                task.get();
            }
            if (fileSystem instanceof LocalFileSystem) {
                i = 0;
                while (i < numThreads & (long)(i * blklen) < rlen) {
                    IOUtilFunctions.deleteCrcFilesFromLocalFileSystem(fileSystem, new Path(path, IOUtilFunctions.getPartFileName(i)));
                    ++i;
                }
            }
        }
        catch (Exception e) {
            throw new IOException("Failed parallel write of JSONL output.", e);
        }
        finally {
            pool.shutdown();
        }
    }

    private class WriteFileTask
    implements Callable<Object> {
        private Path _path;
        private FileSystem _fileSystem;
        private FrameBlock _src;
        private int _lowerRowBound;
        private int _upperRowBound;
        Map<String, Integer> _schemaMap;

        public WriteFileTask(Path path, FileSystem fileSystem, FrameBlock src, int lowerRowBound, int upperRowBound, Map<String, Integer> schemaMap) {
            this._path = path;
            this._fileSystem = fileSystem;
            this._src = src;
            this._lowerRowBound = lowerRowBound;
            this._upperRowBound = upperRowBound;
            this._schemaMap = schemaMap;
        }

        @Override
        public Object call() throws Exception {
            FrameWriterJSONLParallel.this.writeJSONLFrameToFile(this._path, this._fileSystem, this._src, this._lowerRowBound, this._upperRowBound, this._schemaMap);
            return null;
        }
    }
}

