/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.mapping;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.sysds.runtime.compress.colgroup.IMapToDataGroup;
import org.apache.sysds.runtime.compress.colgroup.dictionary.IDictionary;
import org.apache.sysds.runtime.compress.colgroup.indexes.IColIndex;
import org.apache.sysds.runtime.compress.colgroup.mapping.AMapToData;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToBit;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToByte;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToChar;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToFactory;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToUByte;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToZero;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.utils.MemoryEstimates;

public class MapToCharPByte
extends AMapToData {
    private static final long serialVersionUID = 6315708056775476541L;
    public static final int max = 0x7FFFFF;
    private final char[] _data_c;
    private final byte[] _data_b;

    protected MapToCharPByte(int size) {
        this(65535, size);
    }

    public MapToCharPByte(int unique, int size) {
        super(Math.min(unique, 0x7FFFFF));
        this._data_c = new char[size];
        this._data_b = new byte[size];
    }

    public MapToCharPByte(int unique, char[] data_c, byte[] data_b) {
        super(unique);
        this._data_c = data_c;
        this._data_b = data_b;
        this.verify();
    }

    @Override
    public MapToFactory.MAP_TYPE getType() {
        return MapToFactory.MAP_TYPE.CHAR_BYTE;
    }

    @Override
    public int getIndex(int n) {
        return this._data_c[n] + (this._data_b[n] << 16);
    }

    @Override
    public void fill(int v) {
        int m = v & 0xFFFFFF;
        Arrays.fill(this._data_c, (char)m);
        Arrays.fill(this._data_b, (byte)(m >> 16));
    }

    @Override
    public long getInMemorySize() {
        return MapToCharPByte.getInMemorySize(this._data_c.length);
    }

    public static long getInMemorySize(int dataLength) {
        long size = 32L;
        size = (long)((double)size + MemoryEstimates.charArrayCost(dataLength));
        size = (long)((double)size + MemoryEstimates.byteArrayCost(dataLength));
        return size;
    }

    @Override
    public long getExactSizeOnDisk() {
        return 9 + this._data_c.length * 3;
    }

    @Override
    public void set(int n, int v) {
        int m = v & 0xFFFFFF;
        this._data_c[n] = (char)m;
        this._data_b[n] = (byte)(m >> 16);
    }

    @Override
    public void set(int l, int u, int off, AMapToData tm) {
        int i = l;
        while (i < u) {
            this.set(i, tm.getIndex(off));
            ++i;
            ++off;
        }
    }

    @Override
    public int setAndGet(int n, int v) {
        int m = v & 0xFFFFFF;
        this._data_c[n] = (char)m;
        this._data_b[n] = (byte)(m >> 16);
        return m;
    }

    @Override
    public int size() {
        return this._data_c.length;
    }

    @Override
    public void replace(int v, int r) {
        int m = v & 0xFFFFFF;
        int mr = r & 0xFFFFFF;
        char c = (char)m;
        char cr = (char)mr;
        byte b = (byte)(m >> 16);
        byte br = (byte)(mr >> 16);
        for (int i = 0; i < this._data_c.length; ++i) {
            if (this._data_b[i] != b || this._data_c[i] != c) continue;
            this._data_b[i] = br;
            this._data_c[i] = cr;
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeByte(MapToFactory.MAP_TYPE.CHAR_BYTE.ordinal());
        out.writeInt(this.getUnique());
        out.writeInt(this._data_c.length);
        MapToChar.writeChars(out, this._data_c);
        out.write(this._data_b);
    }

    protected static MapToCharPByte readFields(DataInput in) throws IOException {
        int unique = in.readInt();
        int length = in.readInt();
        char[] data_c = new char[length];
        for (int i = 0; i < length; ++i) {
            data_c[i] = in.readChar();
        }
        byte[] data_b = new byte[length];
        for (int i = 0; i < length; ++i) {
            data_b[i] = in.readByte();
        }
        return new MapToCharPByte(unique, data_c, data_b);
    }

    @Override
    public int getUpperBoundValue() {
        return 0x7FFFFF;
    }

    @Override
    public void copyInt(int[] d, int start, int end) {
        for (int i = start; i < end; ++i) {
            this.set(i, d[i]);
        }
    }

    @Override
    public int[] getCounts(int[] ret) {
        int h = this.size() % 8;
        for (int i = 0; i < h; ++i) {
            int n = this._data_c[i] + (this._data_b[i] << 16);
            ret[n] = ret[n] + 1;
        }
        this.getCountsBy8P(ret, h, this.size());
        return ret;
    }

    private void getCountsBy8P(int[] ret, int s, int e) {
        for (int i = s; i < e; i += 8) {
            int n = this.getIndex(i);
            ret[n] = ret[n] + 1;
            int n2 = this.getIndex(i + 1);
            ret[n2] = ret[n2] + 1;
            int n3 = this.getIndex(i + 2);
            ret[n3] = ret[n3] + 1;
            int n4 = this.getIndex(i + 3);
            ret[n4] = ret[n4] + 1;
            int n5 = this.getIndex(i + 4);
            ret[n5] = ret[n5] + 1;
            int n6 = this.getIndex(i + 5);
            ret[n6] = ret[n6] + 1;
            int n7 = this.getIndex(i + 6);
            ret[n7] = ret[n7] + 1;
            int n8 = this.getIndex(i + 7);
            ret[n8] = ret[n8] + 1;
        }
    }

    @Override
    public AMapToData resize(int unique) {
        AMapToData ret;
        int size = this._data_c.length;
        if (unique <= 1) {
            return new MapToZero(size);
        }
        if (unique == 2 && size > 32) {
            ret = new MapToBit(unique, size);
        } else if (unique <= 127) {
            ret = new MapToUByte(unique, size);
        } else if (unique < 256) {
            ret = new MapToByte(unique, size);
        } else if (unique < 65534) {
            ret = new MapToChar(unique, size);
        } else {
            this.setUnique(unique);
            return this;
        }
        ret.copy(this);
        return ret;
    }

    @Override
    public int countRuns() {
        int c = 1;
        char prev = this._data_c[0];
        byte prev_b = this._data_b[0];
        for (int i = 1; i < this._data_c.length; ++i) {
            c += prev == this._data_c[i] && prev_b == this._data_b[i] ? 0 : 1;
            prev = this._data_c[i];
            prev_b = this._data_b[i];
        }
        return c;
    }

    @Override
    public AMapToData slice(int l, int u) {
        return new MapToCharPByte(this.getUnique(), Arrays.copyOfRange(this._data_c, l, u), Arrays.copyOfRange(this._data_b, l, u));
    }

    @Override
    public AMapToData append(AMapToData t) {
        if (t instanceof MapToCharPByte) {
            MapToCharPByte tb = (MapToCharPByte)t;
            char[] tbb = tb._data_c;
            byte[] tbbb = tb._data_b;
            int newSize = this._data_c.length + t.size();
            int newDistinct = Math.max(this.getUnique(), t.getUnique());
            char[] ret_c = Arrays.copyOf(this._data_c, newSize);
            System.arraycopy(tbb, 0, ret_c, this._data_c.length, t.size());
            byte[] ret_b = Arrays.copyOf(this._data_b, newSize);
            System.arraycopy(tbbb, 0, ret_b, this._data_b.length, t.size());
            return new MapToCharPByte(newDistinct, ret_c, ret_b);
        }
        throw new NotImplementedException("Not implemented append on Bit map different type");
    }

    @Override
    public AMapToData appendN(IMapToDataGroup[] d) {
        int p = 0;
        for (IMapToDataGroup gd : d) {
            p += gd.getMapToData().size();
        }
        char[] ret = new char[p];
        byte[] retb = new byte[p];
        p = 0;
        for (int i = 0; i < d.length; ++i) {
            if (d[i].getMapToData().size() <= 0) continue;
            MapToCharPByte mm = (MapToCharPByte)d[i].getMapToData();
            int ms = mm.size();
            System.arraycopy(mm._data_c, 0, ret, p, ms);
            System.arraycopy(mm._data_b, 0, retb, p, ms);
            p += ms;
        }
        return new MapToCharPByte(this.getUnique(), ret, retb);
    }

    @Override
    public boolean equals(AMapToData e) {
        return e instanceof MapToCharPByte && e.getUnique() == this.getUnique() && Arrays.equals(((MapToCharPByte)e)._data_b, this._data_b) && Arrays.equals(((MapToCharPByte)e)._data_c, this._data_c);
    }

    @Override
    protected void preAggregateDenseToRowBy8(double[] mV, double[] preAV, int cl, int cu, int off) {
        int h = (cu - cl) % 8;
        off += cl;
        int rc = cl;
        while (rc < cl + h) {
            int n = this.getIndex(rc);
            preAV[n] = preAV[n] + mV[off];
            ++rc;
            ++off;
        }
        rc = cl + h;
        while (rc < cu) {
            this.preAggregateDenseToRowVec8(mV, preAV, rc, off);
            rc += 8;
            off += 8;
        }
    }

    @Override
    public void lmSparseMatrixRow(SparseBlock sb, int r, DenseBlock db, IColIndex colIndexes, IDictionary dict) {
        if (sb.isEmpty(r)) {
            return;
        }
        int pos = db.pos(r);
        double[] retV = db.values(r);
        int apos = sb.pos(r);
        int alen = sb.size(r) + apos;
        int[] aix = sb.indexes(r);
        double[] aval = sb.values(r);
        for (int i = apos; i < alen; ++i) {
            dict.multiplyScalar(aval[i], retV, pos, this.getIndex(aix[i]), colIndexes);
        }
    }

    @Override
    protected void preAggregateDenseToRowVec8(double[] mV, double[] preAV, int rc, int off) {
        int n = this.getIndex(rc);
        preAV[n] = preAV[n] + mV[off];
        int n2 = this.getIndex(rc + 1);
        preAV[n2] = preAV[n2] + mV[off + 1];
        int n3 = this.getIndex(rc + 2);
        preAV[n3] = preAV[n3] + mV[off + 2];
        int n4 = this.getIndex(rc + 3);
        preAV[n4] = preAV[n4] + mV[off + 3];
        int n5 = this.getIndex(rc + 4);
        preAV[n5] = preAV[n5] + mV[off + 4];
        int n6 = this.getIndex(rc + 5);
        preAV[n6] = preAV[n6] + mV[off + 5];
        int n7 = this.getIndex(rc + 6);
        preAV[n7] = preAV[n7] + mV[off + 6];
        int n8 = this.getIndex(rc + 7);
        preAV[n8] = preAV[n8] + mV[off + 7];
    }

    @Override
    protected void decompressToRangeNoOffBy8(double[] c, int r, double[] values) {
        int n = r;
        c[n] = c[n] + values[this.getIndex(r)];
        int n2 = r + 1;
        c[n2] = c[n2] + values[this.getIndex(r + 1)];
        int n3 = r + 2;
        c[n3] = c[n3] + values[this.getIndex(r + 2)];
        int n4 = r + 3;
        c[n4] = c[n4] + values[this.getIndex(r + 3)];
        int n5 = r + 4;
        c[n5] = c[n5] + values[this.getIndex(r + 4)];
        int n6 = r + 5;
        c[n6] = c[n6] + values[this.getIndex(r + 5)];
        int n7 = r + 6;
        c[n7] = c[n7] + values[this.getIndex(r + 6)];
        int n8 = r + 7;
        c[n8] = c[n8] + values[this.getIndex(r + 7)];
    }

    @Override
    public void decompressToRange(double[] c, int rl, int ru, int offR, double[] values) {
        if (offR == 0) {
            this.decompressToRangeNoOff(c, rl, ru, values);
        } else {
            this.decompressToRangeOff(c, rl, ru, offR, values);
        }
    }

    @Override
    public void decompressToRangeOff(double[] c, int rl, int ru, int offR, double[] values) {
        int offT = rl + offR;
        for (int i = rl; i < ru; ++i) {
            int n = offT++;
            c[n] = c[n] + values[this.getIndex(i)];
        }
    }

    @Override
    public void decompressToRangeNoOff(double[] c, int rl, int ru, double[] values) {
        int rc;
        int h = (ru - rl) % 8;
        for (rc = rl; rc < rl + h; ++rc) {
            int n = rc;
            c[n] = c[n] + values[this.getIndex(rc)];
        }
        for (rc = rl + h; rc < ru; rc += 8) {
            this.decompressToRangeNoOffBy8(c, rc, values);
        }
    }
}

