/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.cost;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.hops.AggUnaryOp;
import org.apache.sysds.hops.Hop;
import org.apache.sysds.hops.IndexingOp;
import org.apache.sysds.runtime.compress.cost.ACostEstimate;
import org.apache.sysds.runtime.compress.cost.ComputationCostEstimator;
import org.apache.sysds.runtime.compress.cost.HybridCostEstimator;
import org.apache.sysds.runtime.compress.cost.InstructionTypeCounter;
import org.apache.sysds.runtime.compress.workload.Op;
import org.apache.sysds.runtime.compress.workload.OpMetadata;
import org.apache.sysds.runtime.compress.workload.OpSided;
import org.apache.sysds.runtime.compress.workload.WTreeNode;
import org.apache.sysds.runtime.compress.workload.WTreeRoot;

public final class CostEstimatorBuilder
implements Serializable {
    private static final long serialVersionUID = 14L;
    protected static final Log LOG = LogFactory.getLog((String)CostEstimatorBuilder.class.getName());
    protected final InstructionTypeCounter counter;

    public CostEstimatorBuilder(WTreeRoot root) {
        this.counter = new InstructionTypeCounter();
        if (root.isDecompressing()) {
            this.counter.incDecompressions();
        }
        for (Op o : root.getOps()) {
            CostEstimatorBuilder.addOp(1, o, this.counter);
        }
        for (WTreeNode n : root.getChildNodes()) {
            CostEstimatorBuilder.addNode(1, n, this.counter);
        }
    }

    public CostEstimatorBuilder(InstructionTypeCounter counter) {
        this.counter = counter;
    }

    protected ACostEstimate create(boolean isInSpark) {
        return new ComputationCostEstimator(this.counter);
    }

    protected ACostEstimate createHybrid() {
        return new HybridCostEstimator(this.counter);
    }

    public InstructionTypeCounter getCounter() {
        return this.counter;
    }

    private static void addNode(int count, WTreeNode n, InstructionTypeCounter counter) {
        int mult = n.getReps();
        for (Op o : n.getOps()) {
            CostEstimatorBuilder.addOp(count * mult, o, counter);
        }
        for (WTreeNode nc : n.getChildNodes()) {
            CostEstimatorBuilder.addNode(count * mult, nc, counter);
        }
    }

    private static void addOp(int count, Op o, InstructionTypeCounter counter) {
        if (o.isDecompressing()) {
            if (o.isOverlapping()) {
                counter.incOverlappingDecompressions(count * o.dim());
            } else {
                counter.incDecompressions(count);
            }
        }
        if (o.isDensifying()) {
            counter.setDensifying(true);
        }
        if (o instanceof OpSided) {
            OpSided os = (OpSided)o;
            int d = o.dim();
            if (os.isLeftMM()) {
                counter.incLMM(count * d);
            } else if (os.isRightMM()) {
                counter.incRMM(count * d);
            } else {
                counter.incCMM(count * d);
            }
        } else if (!(o instanceof OpMetadata)) {
            Hop h = o.getHop();
            if (h instanceof AggUnaryOp) {
                AggUnaryOp agop = (AggUnaryOp)o.getHop();
                switch (agop.getDirection()) {
                    case Row: {
                        counter.incScans(count);
                        break;
                    }
                    default: {
                        counter.incDictOps(count);
                        break;
                    }
                }
            } else if (h instanceof IndexingOp) {
                IndexingOp idxO = (IndexingOp)h;
                if (idxO.isRowLowerEqualsUpper() && idxO.isColLowerEqualsUpper()) {
                    counter.incIndexOp(count);
                } else if (idxO.isAllRows()) {
                    counter.incDictOps(count);
                }
            } else {
                counter.incDictOps(count);
            }
        }
    }

    public boolean shouldTryToCompress() {
        int numberOps = 0;
        numberOps += this.counter.getScans() + this.counter.getLeftMultiplications() + this.counter.getRightMultiplications() + this.counter.getCompressedMultiplications() + this.counter.getDictionaryOps();
        return (numberOps -= this.counter.getDecompressions() + this.counter.getOverlappingDecompressions()) > 4;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CostVector: ");
        sb.append(this.counter);
        return sb.toString();
    }
}

