/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.estim;

import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.CompressionSettings;
import org.apache.sysds.runtime.compress.DMLCompressionException;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSizes;
import org.apache.sysds.runtime.compress.colgroup.indexes.IColIndex;
import org.apache.sysds.runtime.compress.estim.EstimationFactors;
import org.apache.sysds.runtime.compress.estim.encoding.IEncode;

public class CompressedSizeInfoColGroup {
    protected static final Log LOG = LogFactory.getLog((String)CompressedSizeInfoColGroup.class.getName());
    private final IColIndex _cols;
    private final EstimationFactors _facts;
    private final double _minSize;
    private final AColGroup.CompressionType _bestCompressionType;
    private final EnumMap<AColGroup.CompressionType, Double> _sizes;
    private IEncode _map;

    public CompressedSizeInfoColGroup(IColIndex cols, int nVal, int nRow, AColGroup.CompressionType bestCompressionType) {
        this._cols = cols;
        this._facts = new EstimationFactors(nVal, nRow);
        this._minSize = -1.0;
        this._bestCompressionType = bestCompressionType;
        this._sizes = new EnumMap(AColGroup.CompressionType.class);
        this._sizes.put(bestCompressionType, this._minSize);
    }

    public CompressedSizeInfoColGroup(IColIndex cols, EstimationFactors facts, AColGroup.CompressionType bestCompressionType) {
        this._cols = cols;
        this._facts = facts;
        this._minSize = -1.0;
        this._bestCompressionType = bestCompressionType;
        this._sizes = new EnumMap(AColGroup.CompressionType.class);
        this._sizes.put(bestCompressionType, this._minSize);
    }

    public CompressedSizeInfoColGroup(IColIndex cols, EstimationFactors facts, long minSize, AColGroup.CompressionType bestCompressionType) {
        this._cols = cols;
        this._facts = facts;
        this._minSize = minSize;
        this._bestCompressionType = bestCompressionType;
        this._sizes = new EnumMap(AColGroup.CompressionType.class);
        this._sizes.put(bestCompressionType, this._minSize);
    }

    public CompressedSizeInfoColGroup(IColIndex columns, EstimationFactors facts, long minSize, AColGroup.CompressionType bestCompression, IEncode map) {
        this._cols = columns;
        this._facts = facts;
        this._minSize = minSize;
        this._bestCompressionType = bestCompression;
        this._sizes = new EnumMap(AColGroup.CompressionType.class);
        this._sizes.put(bestCompression, this._minSize);
        this._map = map;
    }

    public CompressedSizeInfoColGroup(IColIndex columns, EstimationFactors facts, Set<AColGroup.CompressionType> validCompressionTypes, IEncode map) {
        this._cols = columns;
        this._facts = facts;
        this._sizes = CompressedSizeInfoColGroup.calculateCompressionSizes(this._cols, facts, validCompressionTypes);
        AColGroup.CompressionType tmpBestCompressionType = AColGroup.CompressionType.UNCOMPRESSED;
        double tmpBestCompressionSize = this._sizes.getOrDefault((Object)tmpBestCompressionType, (Double)Double.MAX_VALUE);
        for (Map.Entry<AColGroup.CompressionType, Double> ent : this._sizes.entrySet()) {
            if (!(ent.getValue() < tmpBestCompressionSize)) continue;
            tmpBestCompressionType = ent.getKey();
            tmpBestCompressionSize = ent.getValue();
        }
        this._bestCompressionType = tmpBestCompressionType;
        this._minSize = tmpBestCompressionSize;
        this._map = map;
    }

    public CompressedSizeInfoColGroup(IColIndex columns, int nRows, AColGroup.CompressionType ct) {
        this._cols = columns;
        this._facts = new EstimationFactors(0, nRows);
        this._sizes = new EnumMap(AColGroup.CompressionType.class);
        switch (ct) {
            case EMPTY: {
                this._sizes.put(ct, Double.valueOf(ColGroupSizes.estimateInMemorySizeEMPTY(columns.size(), columns.isContiguous())));
                break;
            }
            case CONST: {
                this._sizes.put(ct, Double.valueOf(ColGroupSizes.estimateInMemorySizeCONST(columns.size(), columns.isContiguous(), 1.0, false)));
                break;
            }
            case UNCOMPRESSED: {
                this._sizes.put(ct, Double.valueOf(ColGroupSizes.estimateInMemorySizeUncompressed(nRows, columns.isContiguous(), columns.size(), 1.0)));
                break;
            }
            default: {
                throw new DMLCompressionException("Invalid instantiation of const Cost");
            }
        }
        this._bestCompressionType = ct;
        this._minSize = this._sizes.get((Object)ct);
        this._map = null;
    }

    public double getCompressionSize(AColGroup.CompressionType ct) {
        if (this._sizes != null) {
            Double s = this._sizes.get((Object)ct);
            if (s == null) {
                throw new DMLCompressionException("Asked for valid " + ct + " but got null. contains:" + this._sizes);
            }
            return s;
        }
        throw new DMLCompressionException("There was no encodings analyzed");
    }

    public AColGroup.CompressionType getBestCompressionType(CompressionSettings cs) {
        return this._bestCompressionType;
    }

    public AColGroup.CompressionType getBestCompressionType() {
        return this._bestCompressionType;
    }

    public Map<AColGroup.CompressionType, Double> getAllCompressionSizes() {
        return this._sizes;
    }

    public double getMinSize() {
        return this._minSize;
    }

    public int getNumVals() {
        return this._facts != null ? this._facts.numVals : -1;
    }

    public int getNumOffs() {
        return this._facts.numOffs;
    }

    public IColIndex getColumns() {
        return this._cols;
    }

    public int getNumRows() {
        return this._facts.numRows;
    }

    public double getMostCommonFraction() {
        return (double)this._facts.largestOff / (double)this._facts.numRows;
    }

    public int getLargestOffInstances() {
        return this._facts.largestOff;
    }

    public double getTupleSparsity() {
        return this._facts.tupleSparsity;
    }

    public IEncode getMap() {
        return this._map;
    }

    public void setMap(IEncode map) {
        this._map = map;
    }

    public boolean containsZeros() {
        return this._facts.numOffs < this._facts.numRows;
    }

    private static EnumMap<AColGroup.CompressionType, Double> calculateCompressionSizes(IColIndex cols, EstimationFactors fact, Set<AColGroup.CompressionType> validCompressionTypes) {
        if (validCompressionTypes.size() > 10) {
            throw new DMLCompressionException("Invalid big number of compression types");
        }
        EnumMap<AColGroup.CompressionType, Double> res = new EnumMap<AColGroup.CompressionType, Double>(AColGroup.CompressionType.class);
        for (AColGroup.CompressionType ct : validCompressionTypes) {
            double compSize = CompressedSizeInfoColGroup.getCompressionSize(cols, ct, fact);
            if (!(compSize > 0.0)) continue;
            res.put(ct, compSize);
        }
        return res;
    }

    public boolean isEmpty() {
        return this._bestCompressionType == AColGroup.CompressionType.EMPTY || this._sizes.containsKey((Object)AColGroup.CompressionType.EMPTY);
    }

    public boolean isConst() {
        return this._bestCompressionType == AColGroup.CompressionType.CONST || this._sizes.containsKey((Object)AColGroup.CompressionType.CONST);
    }

    public boolean isIncompressable() {
        return this._bestCompressionType == AColGroup.CompressionType.UNCOMPRESSED;
    }

    private static double getCompressionSize(IColIndex cols, AColGroup.CompressionType ct, EstimationFactors fact) {
        int numCols = cols.size();
        boolean contiguousColumns = cols.isContiguous();
        switch (ct) {
            case LinearFunctional: {
                return ColGroupSizes.estimateInMemorySizeLinearFunctional(numCols, contiguousColumns);
            }
            case DeltaDDC: {
                throw new NotImplementedException();
            }
            case DDC: {
                int nv = fact.numVals + (fact.numOffs < fact.numRows ? 1 : 0);
                return ColGroupSizes.estimateInMemorySizeDDC(numCols, contiguousColumns, nv, fact.numRows, fact.tupleSparsity, fact.lossy);
            }
            case RLE: {
                return ColGroupSizes.estimateInMemorySizeRLE(numCols, contiguousColumns, fact.numVals, fact.numRuns, fact.numRows, fact.tupleSparsity, fact.lossy);
            }
            case OLE: {
                int nv = fact.numVals + (fact.zeroIsMostFrequent ? 1 : 0);
                return ColGroupSizes.estimateInMemorySizeOLE(numCols, contiguousColumns, nv, fact.numOffs + fact.numVals, fact.numRows, fact.tupleSparsity, fact.lossy);
            }
            case UNCOMPRESSED: {
                return ColGroupSizes.estimateInMemorySizeUncompressed(fact.numRows, contiguousColumns, numCols, fact.overAllSparsity);
            }
            case SDC: {
                return ColGroupSizes.estimateInMemorySizeSDC(numCols, contiguousColumns, fact.numVals, fact.numRows, fact.largestOff, fact.tupleSparsity, fact.zeroIsMostFrequent, fact.lossy);
            }
            case CONST: {
                if (fact.numOffs == fact.numRows && fact.numVals == 1) {
                    return ColGroupSizes.estimateInMemorySizeCONST(numCols, contiguousColumns, fact.tupleSparsity, fact.lossy);
                }
                return -1.0;
            }
            case EMPTY: {
                if (fact.numOffs == 0) {
                    return ColGroupSizes.estimateInMemorySizeEMPTY(numCols, contiguousColumns);
                }
                return -1.0;
            }
        }
        throw new NotImplementedException("The col compression Type is not yet supported");
    }

    public void clearMap() {
        this._map = null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(" cols: " + this._cols);
        sb.append(String.format(" common: %4.3f", this.getMostCommonFraction()));
        sb.append(" Sizes: " + this._sizes);
        sb.append(" facts: " + this._facts);
        sb.append(" mapIsNull: " + (this._map == null));
        if (this._map != null) {
            String s = this._map.toString();
            if (s.length() > 1000) {
                sb.append(s, 0, 1000);
            } else {
                sb.append(s);
            }
        }
        return sb.toString();
    }
}

