/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.webresources;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.commons.io.IOUtils;
import org.apache.tapestry5.ContentType;
import org.apache.tapestry5.annotations.Path;
import org.apache.tapestry5.internal.InternalConstants;
import org.apache.tapestry5.internal.webresources.RhinoExecutor;
import org.apache.tapestry5.internal.webresources.RhinoExecutorPool;
import org.apache.tapestry5.ioc.OperationTracker;
import org.apache.tapestry5.ioc.Resource;
import org.apache.tapestry5.ioc.internal.util.ClasspathResource;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.services.assets.ResourceDependencies;
import org.apache.tapestry5.services.assets.ResourceTransformer;
import org.mozilla.javascript.NativeObject;

public class TypeScriptCompiler
implements ResourceTransformer {
    private static final Charset UTF8 = StandardCharsets.UTF_8;
    private final RhinoExecutorPool executorPool;

    public ContentType getTransformedContentType() {
        return InternalConstants.JAVASCRIPT_CONTENT_TYPE;
    }

    public TypeScriptCompiler(OperationTracker tracker, @Path(value="classpath:org/apache/tapestry5/webresources/internal/typescript.js") Resource typescript) {
        this.executorPool = new RhinoExecutorPool(tracker, Arrays.asList(typescript, new ClasspathResource("org/apache/tapestry5/webresources/internal/invoke-typescript.js")));
    }

    private static String getString(NativeObject object, String key) {
        return object.get((Object)key).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream transform(Resource source, ResourceDependencies dependencies) throws IOException {
        String content;
        InputStream is = null;
        try {
            is = source.openStream();
            content = IOUtils.toString((InputStream)is, (Charset)UTF8);
        }
        finally {
            InternalUtils.close((Closeable)is);
        }
        RhinoExecutor executor = this.executorPool.get();
        try {
            NativeObject result = (NativeObject)executor.invokeFunction("transpile", content, source.toString());
            if (result.containsKey((Object)"exception")) {
                throw new RuntimeException(TypeScriptCompiler.getString(result, "exception"));
            }
            InputStream inputStream = IOUtils.toInputStream((String)TypeScriptCompiler.getString(result, "output"), (Charset)UTF8);
            return inputStream;
        }
        finally {
            executor.discard();
        }
    }
}

