/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.beaneditor;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.tapestry5.internal.services.BeanModelSourceImpl;
import org.apache.tapestry5.internal.services.PropertyConduitSourceImpl;
import org.apache.tapestry5.internal.services.StringInterner;
import org.apache.tapestry5.internal.services.StringInternerImpl;
import org.apache.tapestry5.ioc.AnnotationProvider;
import org.apache.tapestry5.ioc.Configuration;
import org.apache.tapestry5.ioc.ObjectLocator;
import org.apache.tapestry5.ioc.internal.BasicDataTypeAnalyzers;
import org.apache.tapestry5.ioc.internal.BasicTypeCoercions;
import org.apache.tapestry5.ioc.internal.services.PlasticProxyFactoryImpl;
import org.apache.tapestry5.ioc.internal.services.PropertyAccessImpl;
import org.apache.tapestry5.ioc.internal.services.TypeCoercerImpl;
import org.apache.tapestry5.ioc.internal.util.TapestryException;
import org.apache.tapestry5.ioc.services.CoercionTuple;
import org.apache.tapestry5.ioc.services.PlasticProxyFactory;
import org.apache.tapestry5.ioc.services.PropertyAccess;
import org.apache.tapestry5.ioc.services.TypeCoercer;
import org.apache.tapestry5.services.BeanModelSource;
import org.apache.tapestry5.services.DataTypeAnalyzer;
import org.apache.tapestry5.services.PropertyConduitSource;
import org.slf4j.LoggerFactory;

public class BeanModelSourceBuilder {
    private TypeCoercer typeCoercer;
    private PropertyAccess propertyAccess;
    private PropertyConduitSource propertyConduitSource;
    private PlasticProxyFactory plasticProxyFactory;
    private DataTypeAnalyzer dataTypeAnalyzer;
    private ObjectLocator objectLocator;
    private StringInterner stringInterner;

    public BeanModelSource build() {
        if (this.typeCoercer == null) {
            this.createTypeCoercer();
        }
        if (this.propertyAccess == null) {
            this.propertyAccess = new PropertyAccessImpl();
        }
        if (this.dataTypeAnalyzer == null) {
            this.dataTypeAnalyzer = BasicDataTypeAnalyzers.createDefaultDataTypeAnalyzer();
        }
        if (this.stringInterner == null) {
            this.stringInterner = new StringInternerImpl();
        }
        if (this.plasticProxyFactory == null) {
            this.plasticProxyFactory = new PlasticProxyFactoryImpl(this.getClass().getClassLoader(), LoggerFactory.getLogger(PlasticProxyFactory.class));
        }
        if (this.propertyConduitSource == null) {
            this.propertyConduitSource = new PropertyConduitSourceImpl(this.propertyAccess, this.plasticProxyFactory, this.typeCoercer, this.stringInterner);
        }
        if (this.objectLocator == null) {
            this.objectLocator = new AutobuildOnlyObjectLocator();
        }
        return new BeanModelSourceImpl(this.typeCoercer, this.propertyAccess, this.propertyConduitSource, this.plasticProxyFactory, this.dataTypeAnalyzer, this.objectLocator);
    }

    public BeanModelSourceBuilder setTypeCoercer(TypeCoercer typeCoercer) {
        this.typeCoercer = typeCoercer;
        return this;
    }

    public BeanModelSourceBuilder setPropertyAccess(PropertyAccess propertyAccess) {
        this.propertyAccess = propertyAccess;
        return this;
    }

    public BeanModelSourceBuilder setPropertyConduitSource(PropertyConduitSource propertyConduitSource) {
        this.propertyConduitSource = propertyConduitSource;
        return this;
    }

    public BeanModelSourceBuilder setPlasticProxyFactory(PlasticProxyFactory plasticProxyFactory) {
        this.plasticProxyFactory = plasticProxyFactory;
        return this;
    }

    public BeanModelSourceBuilder setDataTypeAnalyzer(DataTypeAnalyzer dataTypeAnalyzer) {
        this.dataTypeAnalyzer = dataTypeAnalyzer;
        return this;
    }

    public BeanModelSourceBuilder setObjectLocator(ObjectLocator objectLocator) {
        this.objectLocator = objectLocator;
        return this;
    }

    public BeanModelSourceBuilder setStringInterner(StringInterner stringInterner) {
        this.stringInterner = stringInterner;
        return this;
    }

    private void createTypeCoercer() {
        CoercionTupleConfiguration configuration = new CoercionTupleConfiguration();
        BasicTypeCoercions.provideBasicTypeCoercions((Configuration)configuration);
        BasicTypeCoercions.provideJSR310TypeCoercions((Configuration)configuration);
        this.typeCoercer = new TypeCoercerImpl(configuration.getTuples());
    }

    private static final class AutobuildOnlyObjectLocator
    implements ObjectLocator {
        private AutobuildOnlyObjectLocator() {
        }

        public <T> T getService(String serviceId, Class<T> serviceInterface) {
            throw new RuntimeException("Not implemented");
        }

        public <T> T getService(Class<T> serviceInterface) {
            throw new RuntimeException("Not implemented");
        }

        public <T> T getService(Class<T> serviceInterface, Class<? extends Annotation> ... markerTypes) {
            throw new RuntimeException("Not implemented");
        }

        public <T> T getObject(Class<T> objectType, AnnotationProvider annotationProvider) {
            throw new RuntimeException("Not implemented");
        }

        public <T> T autobuild(Class<T> clazz) {
            try {
                return clazz.newInstance();
            }
            catch (Exception e) {
                throw new TapestryException("Couldn't instantiate class " + clazz.getName(), (Throwable)e);
            }
        }

        public <T> T autobuild(String description, Class<T> clazz) {
            return this.autobuild(clazz);
        }

        public <T> T proxy(Class<T> interfaceClass, Class<? extends T> implementationClass) {
            throw new RuntimeException("Not implemented");
        }
    }

    private static final class CoercionTupleConfiguration
    implements Configuration<CoercionTuple> {
        private final Collection<CoercionTuple> tuples = new ArrayList<CoercionTuple>();

        private CoercionTupleConfiguration() {
        }

        public void add(CoercionTuple tuble) {
            this.tuples.add(tuble);
        }

        public void addInstance(Class<? extends CoercionTuple> clazz) {
            throw new RuntimeException("Not implemented");
        }

        public Collection<CoercionTuple> getTuples() {
            return this.tuples;
        }
    }
}

