/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.corelib.internal;

import java.util.List;
import org.apache.tapestry5.ComponentAction;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.Field;
import org.apache.tapestry5.commons.Locatable;
import org.apache.tapestry5.commons.Location;
import org.apache.tapestry5.commons.util.CollectionFactory;
import org.apache.tapestry5.corelib.internal.ComponentActionSink;
import org.apache.tapestry5.corelib.internal.InternalFormSupport;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.util.IdAllocator;

public class FormSupportImpl
implements InternalFormSupport,
Locatable {
    private final ComponentResources resources;
    private final boolean clientValidationEnabled;
    private final IdAllocator idAllocator;
    private final String clientId;
    private final ComponentActionSink actionSink;
    private final String formValidationId;
    private List<Runnable> commands;
    private String encodingType;

    public FormSupportImpl(ComponentResources resources, String formValidationId) {
        this(resources, null, null, false, null, formValidationId);
    }

    public FormSupportImpl(ComponentResources resources, String clientId, ComponentActionSink actionSink, boolean clientValidationEnabled, IdAllocator idAllocator, String formValidationId) {
        this.resources = resources;
        this.clientId = clientId;
        this.actionSink = actionSink;
        this.clientValidationEnabled = clientValidationEnabled;
        this.idAllocator = idAllocator;
        this.formValidationId = formValidationId;
    }

    public Location getLocation() {
        return this.resources.getLocation();
    }

    @Override
    public String getFormComponentId() {
        return this.resources.getCompleteId();
    }

    @Override
    public String allocateControlName(String id) {
        return this.idAllocator.allocateId(id);
    }

    @Override
    public <T> void store(T component, ComponentAction<T> action) {
        this.actionSink.store(component, action);
    }

    @Override
    public <T> void storeCancel(T component, ComponentAction<T> action) {
        this.actionSink.storeCancel(component, action);
    }

    @Override
    public <T> void storeAndExecute(T component, ComponentAction<T> action) {
        this.actionSink.store(component, action);
        action.execute(component);
    }

    @Override
    public void defer(Runnable command) {
        assert (command != null);
        if (this.commands == null) {
            this.commands = CollectionFactory.newList();
        }
        this.commands.add(command);
    }

    @Override
    public void executeDeferred() {
        if (this.commands == null) {
            return;
        }
        for (Runnable r : this.commands) {
            r.run();
        }
        this.commands.clear();
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public String getEncodingType() {
        return this.encodingType;
    }

    @Override
    public void setEncodingType(String encodingType) {
        assert (InternalUtils.isNonBlank((String)encodingType));
        if (this.encodingType != null && !this.encodingType.equals(encodingType)) {
            throw new IllegalStateException(String.format("Encoding type of form has already been set to '%s' and may not be changed to '%s'.", this.encodingType, encodingType));
        }
        this.encodingType = encodingType;
    }

    @Override
    public void addValidation(Field field, String validationName, String message, Object constraint) {
    }

    @Override
    public boolean isClientValidationEnabled() {
        return this.clientValidationEnabled;
    }

    @Override
    public String getFormValidationId() {
        return this.formValidationId;
    }
}

