/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.transform;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.tapestry5.Binding;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.annotations.Cached;
import org.apache.tapestry5.internal.TapestryInternalUtils;
import org.apache.tapestry5.internal.transform.MethodResultCache;
import org.apache.tapestry5.internal.transform.PropertyValueProviderWorker;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.ioc.services.PerThreadValue;
import org.apache.tapestry5.ioc.services.PerthreadManager;
import org.apache.tapestry5.model.MutableComponentModel;
import org.apache.tapestry5.plastic.ComputedValue;
import org.apache.tapestry5.plastic.FieldHandle;
import org.apache.tapestry5.plastic.InstanceContext;
import org.apache.tapestry5.plastic.MethodAdvice;
import org.apache.tapestry5.plastic.MethodDescription;
import org.apache.tapestry5.plastic.MethodInvocation;
import org.apache.tapestry5.plastic.PlasticClass;
import org.apache.tapestry5.plastic.PlasticField;
import org.apache.tapestry5.plastic.PlasticMethod;
import org.apache.tapestry5.plastic.PlasticUtils;
import org.apache.tapestry5.plastic.PropertyAccessType;
import org.apache.tapestry5.plastic.PropertyValueProvider;
import org.apache.tapestry5.runtime.PageLifecycleListener;
import org.apache.tapestry5.services.BindingSource;
import org.apache.tapestry5.services.TransformConstants;
import org.apache.tapestry5.services.transform.ComponentClassTransformWorker2;
import org.apache.tapestry5.services.transform.TransformationSupport;

public class CachedWorker
implements ComponentClassTransformWorker2 {
    private static final String FIELD_PREFIX = "cache$";
    private final BindingSource bindingSource;
    private final PerthreadManager perThreadManager;
    private final PropertyValueProviderWorker propertyValueProviderWorker;
    private final boolean multipleClassLoaders;
    private final MethodResultCacheFactory nonWatchFactory = new MethodResultCacheFactory(){

        @Override
        public MethodResultCache create(Object instance) {
            return new SimpleMethodResultCache();
        }
    };

    public CachedWorker(BindingSource bindingSource, PerthreadManager perthreadManager, PropertyValueProviderWorker propertyValueProviderWorker, @Inject @Symbol(value="tapestry.production-mode") boolean productionMode, @Inject @Symbol(value="tapestry.multiple-classloaders") boolean multipleClassloaders) {
        this.bindingSource = bindingSource;
        this.perThreadManager = perthreadManager;
        this.propertyValueProviderWorker = propertyValueProviderWorker;
        this.multipleClassLoaders = !productionMode && multipleClassloaders;
    }

    @Override
    public void transform(PlasticClass plasticClass, TransformationSupport support, MutableComponentModel model) {
        List methods = plasticClass.getMethodsWithAnnotation(Cached.class);
        HashSet<PlasticUtils.FieldInfo> fieldInfos = this.multipleClassLoaders ? new HashSet<PlasticUtils.FieldInfo>() : null;
        for (PlasticMethod method : methods) {
            this.validateMethod(method);
            this.adviseMethod(plasticClass, method, fieldInfos);
        }
        if (this.multipleClassLoaders && !fieldInfos.isEmpty()) {
            this.propertyValueProviderWorker.add(plasticClass, fieldInfos);
        }
    }

    private void adviseMethod(PlasticClass plasticClass, PlasticMethod method, Set<PlasticUtils.FieldInfo> fieldInfos) {
        PlasticField cacheField = plasticClass.introduceField(PerThreadValue.class, this.getFieldName(method));
        cacheField.injectComputed((ComputedValue)new ComputedValue<PerThreadValue>(){

            public PerThreadValue get(InstanceContext context) {
                return CachedWorker.this.perThreadManager.createValue();
            }
        });
        if (this.multipleClassLoaders) {
            fieldInfos.add(PlasticUtils.toFieldInfo((PlasticField)cacheField));
            cacheField.createAccessors(PropertyAccessType.READ_ONLY);
        }
        Cached annotation = (Cached)method.getAnnotation(Cached.class);
        MethodResultCacheFactory factory = this.createFactory(plasticClass, annotation.watch(), method);
        MethodAdvice advice = this.createAdvice(cacheField, factory);
        method.addAdvice(advice);
    }

    private String getFieldName(PlasticMethod method) {
        StringBuilder builder = new StringBuilder(FIELD_PREFIX);
        builder.append(method.getDescription().methodName);
        if (this.multipleClassLoaders) {
            builder.append("_");
            builder.append(method.getPlasticClass().getClassName().replace('.', '_'));
        }
        return builder.toString();
    }

    private MethodAdvice createAdvice(PlasticField cacheField, final MethodResultCacheFactory factory) {
        final FieldHandle fieldHandle = cacheField.getHandle();
        final String fieldName = this.multipleClassLoaders ? cacheField.getName() : null;
        return new MethodAdvice(){

            public void advise(MethodInvocation invocation) {
                MethodResultCache cache = this.getOrCreateCache(invocation);
                if (cache.isCached()) {
                    invocation.setReturnValue(cache.get());
                    return;
                }
                invocation.proceed();
                if (!invocation.didThrowCheckedException()) {
                    cache.set(invocation.getReturnValue());
                }
            }

            private MethodResultCache getOrCreateCache(MethodInvocation invocation) {
                Object instance = invocation.getInstance();
                PerThreadValue value = (PerThreadValue)(CachedWorker.this.multipleClassLoaders ? PropertyValueProvider.get((Object)instance, (String)fieldName) : fieldHandle.get(instance));
                if (value.exists()) {
                    return (MethodResultCache)value.get();
                }
                return (MethodResultCache)value.set((Object)factory.create(instance));
            }
        };
    }

    private MethodResultCacheFactory createFactory(PlasticClass plasticClass, final String watch, PlasticMethod method) {
        if (watch.equals("")) {
            return this.nonWatchFactory;
        }
        final FieldHandle bindingFieldHandle = plasticClass.introduceField(Binding.class, "cache$watchBinding$" + method.getDescription().methodName).getHandle();
        plasticClass.introduceInterface(PageLifecycleListener.class);
        plasticClass.introduceMethod(TransformConstants.CONTAINING_PAGE_DID_LOAD_DESCRIPTION).addAdvice(new MethodAdvice(){

            public void advise(MethodInvocation invocation) {
                ComponentResources resources = (ComponentResources)invocation.getInstanceContext().get(ComponentResources.class);
                Binding binding = CachedWorker.this.bindingSource.newBinding("@Cached watch", resources, "prop", watch);
                bindingFieldHandle.set(invocation.getInstance(), (Object)binding);
                invocation.proceed();
            }
        });
        return new MethodResultCacheFactory(){

            @Override
            public MethodResultCache create(Object instance) {
                Binding binding = (Binding)bindingFieldHandle.get(instance);
                return new WatchedBindingMethodResultCache(binding);
            }
        };
    }

    private void validateMethod(PlasticMethod method) {
        MethodDescription description = method.getDescription();
        if (description.returnType.equals("void")) {
            throw new IllegalArgumentException(String.format("Method %s may not be used with @Cached because it returns void.", method.getMethodIdentifier()));
        }
        if (description.argumentTypes.length != 0) {
            throw new IllegalArgumentException(String.format("Method %s may not be used with @Cached because it has parameters.", method.getMethodIdentifier()));
        }
    }

    private class WatchedBindingMethodResultCache
    extends SimpleMethodResultCache {
        private final Binding binding;
        private Object cachedBindingValue;

        public WatchedBindingMethodResultCache(Binding binding) {
            this.binding = binding;
        }

        @Override
        public boolean isCached() {
            Object currentBindingValue = this.binding.get();
            if (!TapestryInternalUtils.isEqual(this.cachedBindingValue, currentBindingValue)) {
                this.reset();
                this.cachedBindingValue = currentBindingValue;
            }
            return super.isCached();
        }
    }

    private class SimpleMethodResultCache
    implements MethodResultCache {
        private boolean cached;
        private Object cachedValue;

        private SimpleMethodResultCache() {
        }

        @Override
        public void set(Object cachedValue) {
            this.cached = true;
            this.cachedValue = cachedValue;
        }

        @Override
        public void reset() {
            this.cached = false;
            this.cachedValue = null;
        }

        @Override
        public boolean isCached() {
            return this.cached;
        }

        @Override
        public Object get() {
            return this.cachedValue;
        }
    }

    static interface MethodResultCacheFactory {
        public MethodResultCache create(Object var1);
    }
}

