/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.tika.pipes.fetcher.http.config;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;

public class HttpHeaders {
    @JsonIgnore
    private Multimap<String, String> headers = ArrayListMultimap.create();

    @JsonIgnore
    public Multimap<String, String> getHeaders() {
        return headers;
    }

    /**
     * @return the headers as a map; The map does not support {@code put} or {@code putAll}, nor do
     * its entries support {@link Entry#setValue setValue}, so you can't use this to add headers.
     */
    public Map<String, Collection<String>> getMap() {
        return headers.asMap();
    }

    public void setMap(Map<String, Collection<String>> map) {
        headers = ArrayListMultimap.create();
        map.forEach(headers::putAll);
    }

    public void setHeaders(Multimap<String, String> headers) {
        this.headers = headers;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        HttpHeaders that = (HttpHeaders) o;
        return Objects.equals(headers, that.headers);
    }

    @Override
    public int hashCode() {
        return Objects.hash(headers);
    }
}
