"use strict";
/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
var types_1 = require("./types");
var utils_1 = require("./utils");
var recreateQueryOnelinerFromSyntaxTree = function (localIndentation) {
    if (localIndentation === void 0) { localIndentation = 0; }
    return function (syntaxTree) {
        switch (syntaxTree.type) {
            // This case will never occur
            case types_1.TokenType.NonGremlinCode:
                return syntaxTree.code;
            case types_1.TokenType.Traversal:
                return (0, utils_1.spaces)(localIndentation) + syntaxTree.steps.map(recreateQueryOnelinerFromSyntaxTree()).join('.');
            case types_1.TokenType.Method:
                return ((0, utils_1.spaces)(localIndentation) +
                    recreateQueryOnelinerFromSyntaxTree()(syntaxTree.method) +
                    '(' +
                    syntaxTree.arguments.map(recreateQueryOnelinerFromSyntaxTree()).join(', ') +
                    ')');
            case types_1.TokenType.Closure:
                return ((0, utils_1.spaces)(localIndentation) +
                    recreateQueryOnelinerFromSyntaxTree()(syntaxTree.method) +
                    '{' +
                    (0, utils_1.last)(syntaxTree.closureCodeBlock.map(function (_a) {
                        var lineOfCode = _a.lineOfCode, relativeIndentation = _a.relativeIndentation;
                        return "".concat((0, utils_1.spaces)(Math.max(relativeIndentation, 0))).concat(lineOfCode);
                    })) +
                    '}');
            case types_1.TokenType.String:
                return (0, utils_1.spaces)(localIndentation) + syntaxTree.string;
            case types_1.TokenType.Word:
                return (0, utils_1.spaces)(localIndentation) + syntaxTree.word;
        }
    };
};
exports.default = recreateQueryOnelinerFromSyntaxTree;
