/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal;

import java.util.ArrayList;
import java.util.List;
import org.cloudfoundry.client.lib.domain.CloudService;
import org.eclipse.cft.server.core.ApplicationDeploymentInfo;
import org.eclipse.cft.server.core.internal.ApplicationUrlLookupService;
import org.eclipse.cft.server.core.internal.CloudErrorUtil;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.application.ManifestParser;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.cft.server.core.internal.client.DeploymentConfiguration;
import org.eclipse.cft.server.core.internal.client.DeploymentInfoWorkingCopy;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.cft.server.ui.internal.wizards.ApplicationWizardDelegate;
import org.eclipse.cft.server.ui.internal.wizards.ApplicationWizardRegistry;
import org.eclipse.cft.server.ui.internal.wizards.CloudFoundryApplicationWizard;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class ApplicationDeploymentUIHandler {
    public DeploymentConfiguration prepareForDeployment(final CloudFoundryServer server, final CloudFoundryApplicationModule appModule, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        if (!appModule.validateDeploymentInfo().isOK()) {
            DeploymentConfiguration[] configuration;
            IStatus[] status;
            boolean[] writeToManifest;
            ApplicationDeploymentInfo oldInfo;
            block15: {
                final ApplicationWizardDelegate providerDelegate = ApplicationWizardRegistry.getWizardProvider(appModule.getLocalModule());
                if (providerDelegate == null) {
                    throw CloudErrorUtil.toCoreException((String)("Failed to open application deployment wizard for: " + appModule.getDeployedApplicationName() + " when attempting to push application to " + server.getServer().getName() + ". No application provider found that corresponds to the application type: " + appModule.getLocalModule().getModuleType().getId()));
                }
                DeploymentInfoWorkingCopy workingCopy = null;
                try {
                    workingCopy = new ManifestParser(appModule, server).load(monitor);
                }
                catch (Throwable ce) {
                    CloudFoundryPlugin.logError((Throwable)ce);
                }
                if (workingCopy == null) {
                    workingCopy = appModule.resolveDeploymentInfoWorkingCopy(monitor);
                }
                oldInfo = workingCopy.copy();
                final boolean[] cancelled = new boolean[1];
                writeToManifest = new boolean[1];
                status = new IStatus[]{Status.OK_STATUS};
                final DeploymentInfoWorkingCopy finWorkingCopy = workingCopy;
                configuration = new DeploymentConfiguration[1];
                ApplicationUrlLookupService.update((CloudFoundryServer)server, (IProgressMonitor)monitor);
                final ArrayList addedServices = new ArrayList();
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        CloudFoundryApplicationWizard wizard = new CloudFoundryApplicationWizard(server, appModule, finWorkingCopy, providerDelegate);
                        try {
                            WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getModalDialogShellProvider().getShell(), (IWizard)wizard);
                            int dialogueStatus = dialog.open();
                            if (dialogueStatus == 0) {
                                List<CloudService> services = wizard.getCloudServicesToCreate();
                                if (services != null) {
                                    addedServices.addAll(services);
                                }
                                writeToManifest[0] = wizard.persistManifestChanges();
                                configuration[0] = wizard.getDeploymentConfiguration();
                            } else {
                                cancelled[0] = true;
                            }
                        }
                        catch (Throwable t) {
                            cancelled[0] = true;
                            status[0] = CloudFoundryPlugin.getErrorStatus((Throwable)t);
                        }
                    }
                });
                if (cancelled[0]) {
                    if (!status[0].isOK()) {
                        CloudFoundryPlugin.logError((String)("Failed to deploy application due to: " + status[0].getMessage()), (Throwable)status[0].getException());
                    }
                    throw new OperationCanceledException();
                }
                if (!addedServices.isEmpty()) {
                    try {
                        server.getBehaviour().operations().createServices(addedServices.toArray(new CloudService[0])).run(monitor);
                    }
                    catch (CoreException e) {
                        CloudFoundryPlugin.logError((Throwable)e);
                        if (CloudFoundryPlugin.getCallback().prompt(Messages.ApplicationDeploymentUIHandler_CONTINUE_DEPLOYMENT_SERVICE_ERROR_TITLE, NLS.bind((String)Messages.ApplicationDeploymentUIHandler_CONTINUE_DEPLOYMENT_SERVICE_ERROR_MESSAGE, (Object[])new String[]{finWorkingCopy.getDeploymentName(), server.getServer().getId(), e.getMessage()}))) break block15;
                        throw new OperationCanceledException();
                    }
                }
            }
            if (status[0].isOK()) {
                status[0] = appModule.validateDeploymentInfo();
            }
            if (!status[0].isOK()) {
                throw new CoreException(status[0]);
            }
            if (writeToManifest[0]) {
                try {
                    new ManifestParser(appModule, server).write(monitor, oldInfo);
                }
                catch (Throwable ce) {
                    CloudFoundryPlugin.logError((Throwable)ce);
                }
            }
            return configuration[0];
        }
        return null;
    }
}

