/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.actions;

import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.client.CloudFoundryApplicationModule;
import org.eclipse.cft.server.core.internal.client.ICloudFoundryOperation;
import org.eclipse.cft.server.ui.internal.actions.ModuleCommand;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

public abstract class UpdateMappingCommand
extends ModuleCommand {
    protected abstract String getJobNameString();

    @Override
    protected void run(CloudFoundryApplicationModule appModule, CloudFoundryServer cloudServer) {
        final ICloudFoundryOperation op = this.getCloudOperation(appModule, cloudServer);
        if (op != null) {
            Job job = new Job(NLS.bind((String)this.getJobNameString(), (Object)appModule.getDeployedApplicationName())){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        op.run(monitor);
                    }
                    catch (CoreException e) {
                        CloudFoundryPlugin.logError((Throwable)e);
                        if (e.getStatus() != null) {
                            return e.getStatus();
                        }
                        return Status.CANCEL_STATUS;
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        } else {
            CloudFoundryPlugin.logError((String)"No operation resolved to run in this action");
        }
    }

    protected abstract ICloudFoundryOperation getCloudOperation(CloudFoundryApplicationModule var1, CloudFoundryServer var2);
}

