/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.console;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cft.server.core.internal.CloudErrorUtil;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.client.CloudFoundryServerBehaviour;
import org.eclipse.cft.server.core.internal.log.CFApplicationLogListener;
import org.eclipse.cft.server.core.internal.log.CFStreamingLogToken;
import org.eclipse.cft.server.core.internal.log.CloudLog;
import org.eclipse.cft.server.core.internal.log.LogContentType;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.cft.server.ui.internal.console.ConsoleConfig;
import org.eclipse.cft.server.ui.internal.console.ConsoleStream;
import org.eclipse.cft.server.ui.internal.console.SingleConsoleStream;
import org.eclipse.cft.server.ui.internal.console.UILogConfig;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.console.IOConsoleOutputStream;

public class ApplicationLogConsoleStream
extends ConsoleStream {
    private CFStreamingLogToken streamingToken;
    private Map<LogContentType, ConsoleStream> logStreams = new HashMap<LogContentType, ConsoleStream>();
    private ConsoleConfig consoleDescriptor;

    @Override
    public synchronized void close() {
        if (this.logStreams != null) {
            for (Map.Entry<LogContentType, ConsoleStream> entry : this.logStreams.entrySet()) {
                entry.getValue().close();
            }
            this.logStreams.clear();
        }
        if (this.streamingToken != null) {
            this.streamingToken.cancel();
            this.streamingToken = null;
        }
    }

    @Override
    public synchronized void initialiseStream(ConsoleConfig descriptor) throws CoreException {
        if (descriptor == null) {
            throw CloudErrorUtil.toCoreException((String)Messages.ERROR_FAILED_INITIALISE_APPLICATION_LOG_STREAM);
        }
        this.consoleDescriptor = descriptor;
        if (this.streamingToken == null) {
            CloudFoundryServerBehaviour behaviour = this.consoleDescriptor.getCloudServer().getBehaviour();
            this.streamingToken = behaviour.startAppLogStreaming(this.consoleDescriptor.getCloudApplicationModule().getDeployedApplicationName(), (CFApplicationLogListener)new ApplicationLogConsoleListener(), (IProgressMonitor)new NullProgressMonitor());
        }
    }

    @Override
    public synchronized boolean isActive() {
        return this.streamingToken != null;
    }

    @Override
    protected IOConsoleOutputStream getOutputStream(LogContentType type) {
        ConsoleStream consoleStream = this.getApplicationLogStream(type);
        if (consoleStream != null && consoleStream.isActive()) {
            return consoleStream.getOutputStream(type);
        }
        return null;
    }

    protected synchronized ConsoleStream getApplicationLogStream(LogContentType type) {
        if (type == null) {
            return null;
        }
        ConsoleStream stream = this.logStreams.get(type);
        if (stream == null) {
            int swtColour = -1;
            if (LogContentType.APPLICATION_LOG_STS_ERROR.equals((Object)type)) {
                swtColour = 3;
            } else if (LogContentType.APPLICATION_LOG_STD_OUT.equals((Object)type)) {
                swtColour = 6;
            } else if (LogContentType.APPLICATION_LOG_UNKNOWN.equals((Object)type)) {
                swtColour = 2;
            }
            if (swtColour > -1) {
                try {
                    stream = new SingleConsoleStream(new UILogConfig(swtColour));
                    stream.initialiseStream(this.consoleDescriptor);
                    this.logStreams.put(type, stream);
                }
                catch (CoreException e) {
                    CloudFoundryPlugin.logError((Throwable)e);
                }
            }
        }
        return stream;
    }

    @Override
    public synchronized void write(CloudLog log) throws CoreException {
        if (log == null) {
            return;
        }
        IOConsoleOutputStream activeOutStream = this.getOutputStream(log.getLogType());
        if (activeOutStream != null && log.getMessage() != null) {
            try {
                activeOutStream.write(log.getMessage());
            }
            catch (IOException e) {
                throw CloudErrorUtil.toCoreException((Throwable)e);
            }
        }
    }

    public class ApplicationLogConsoleListener
    implements CFApplicationLogListener {
        public void onMessage(CloudLog appLog) {
            if (ApplicationLogConsoleStream.this.isActive()) {
                try {
                    ApplicationLogConsoleStream.this.write(appLog);
                }
                catch (CoreException e) {
                    this.onError(e);
                }
            }
        }

        public void onComplete() {
        }

        public void onError(Throwable exception) {
            if (ApplicationLogConsoleStream.this.isActive()) {
                CloudFoundryPlugin.logError((String)NLS.bind((String)Messages.ERROR_APPLICATION_LOG, (Object)ApplicationLogConsoleStream.this.consoleDescriptor.getCloudApplicationModule().getDeployedApplicationName(), (Object)exception.getMessage()), (Throwable)exception);
            }
        }
    }
}

