/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.actions;

import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.CodewindEclipseApplication;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.console.CodewindConsoleFactory;
import org.eclipse.codewind.core.internal.console.ProjectLogInfo;
import org.eclipse.codewind.core.internal.console.SocketConsole;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.navigator.ICommonViewerSite;

public class LogFileAction
extends Action {
    private final ProjectLogInfo logInfo;
    private final CodewindEclipseApplication app;

    public LogFileAction(CodewindEclipseApplication app, ProjectLogInfo logInfo, ICommonViewerSite viewSite) {
        super(logInfo.logName, 2);
        this.logInfo = logInfo;
        this.app = app;
        this.setChecked(app.getConsole(logInfo) != null);
    }

    public void run() {
        if (this.app == null) {
            Logger.logError((String)"LogFileAction ran but no application was selected");
            return;
        }
        try {
            if (this.isChecked()) {
                Job job = new Job(NLS.bind((String)Messages.ShowLogFileJobLabel, (Object[])new String[]{this.app.name, this.logInfo.logName})){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            SocketConsole console = CodewindConsoleFactory.createLogFileConsole((CodewindApplication)LogFileAction.this.app, (ProjectLogInfo)LogFileAction.this.logInfo);
                            ConsolePlugin.getDefault().getConsoleManager().showConsoleView((IConsole)console);
                            LogFileAction.this.app.addConsole(console);
                            return Status.OK_STATUS;
                        }
                        catch (Exception e) {
                            Logger.logError((String)("An error occurred opening the " + ((LogFileAction)LogFileAction.this).logInfo.logName + " log file for: " + ((LogFileAction)LogFileAction.this).app.name + ", with id: " + ((LogFileAction)LogFileAction.this).app.projectID), (Throwable)e);
                            return new Status(4, "org.eclipse.codewind.ui", NLS.bind((String)Messages.ShowLogFileError, (Object[])new String[]{((LogFileAction)LogFileAction.this).logInfo.logName, ((LogFileAction)LogFileAction.this).app.name}), (Throwable)e);
                        }
                    }
                };
                job.schedule();
            } else {
                Job job = new Job(NLS.bind((String)Messages.HideLogFileJobLabel, (Object[])new String[]{this.app.name, this.logInfo.logName})){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            SocketConsole console = LogFileAction.this.app.getConsole(LogFileAction.this.logInfo);
                            if (console != null) {
                                IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();
                                consoleManager.removeConsoles(new IConsole[]{console});
                                LogFileAction.this.app.removeConsole(console);
                            }
                            return Status.OK_STATUS;
                        }
                        catch (Exception e) {
                            Logger.logError((String)("An error occurred closing the " + ((LogFileAction)LogFileAction.this).logInfo.logName + " log file for: " + ((LogFileAction)LogFileAction.this).app.name + ", with id: " + ((LogFileAction)LogFileAction.this).app.projectID), (Throwable)e);
                            return new Status(4, "org.eclipse.codewind.ui", NLS.bind((String)Messages.HideLogFileError, (Object[])new String[]{((LogFileAction)LogFileAction.this).logInfo.logName, ((LogFileAction)LogFileAction.this).app.name}), (Throwable)e);
                        }
                    }
                };
                job.schedule();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

