/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.core.internal.connection;

import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.CodewindApplicationFactory;
import org.eclipse.codewind.core.internal.CoreUtil;
import org.eclipse.codewind.core.internal.FileUtil;
import org.eclipse.codewind.core.internal.HttpUtil;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.cli.AuthToken;
import org.eclipse.codewind.core.internal.cli.CLIUtil;
import org.eclipse.codewind.core.internal.connection.AuthManager;
import org.eclipse.codewind.core.internal.connection.CodewindConnectionException;
import org.eclipse.codewind.core.internal.connection.CodewindSocket;
import org.eclipse.codewind.core.internal.connection.ConnectionEnv;
import org.eclipse.codewind.core.internal.connection.ImagePushRegistryInfo;
import org.eclipse.codewind.core.internal.connection.ProjectTypeInfo;
import org.eclipse.codewind.core.internal.connection.RegistryInfo;
import org.eclipse.codewind.core.internal.console.ProjectLogInfo;
import org.eclipse.codewind.core.internal.messages.Messages;
import org.eclipse.codewind.filewatchers.core.IAuthTokenProvider;
import org.eclipse.codewind.filewatchers.eclipse.CodewindFilewatcherdConnection;
import org.eclipse.codewind.filewatchers.eclipse.ICodewindProjectTranslator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CodewindConnection {
    public static final String CODEWIND_WORKSPACE_PROPERTY = "org.eclipse.codewind.internal.workspace";
    private String name;
    private URI baseUri;
    private String conid;
    private ConnectionEnv env = null;
    private String connectionErrorMsg = null;
    private CodewindSocket socket;
    private CodewindFilewatcherdConnection filewatcher;
    private volatile boolean isConnected = false;
    private Map<String, CodewindApplication> appMap = new LinkedHashMap<String, CodewindApplication>();

    public CodewindConnection(String name, URI uri, String conid) {
        this.setName(name);
        this.setBaseURI(uri);
        this.conid = conid;
    }

    public void connect(IProgressMonitor monitor) throws IOException, URISyntaxException, JSONException {
        if (this.isConnected) {
            return;
        }
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        mon.setTaskName(NLS.bind((String)Messages.Connection_TaskLabel, (Object)this.baseUri));
        if (!this.waitForReady((IProgressMonitor)mon.split(20))) {
            if (mon.isCanceled()) {
                return;
            }
            Logger.logError("Timed out waiting for Codewind to go into ready state.");
            this.onInitFail(Messages.Connection_ErrConnection_CodewindNotReady);
        }
        mon.split(25);
        this.env = new ConnectionEnv(this.getEnvData(this.baseUri));
        Logger.log("Codewind version is: " + this.env.getVersion());
        if (!CodewindConnection.isSupportedVersion(this.env.getVersion())) {
            Logger.logError("The detected version of Codewind is not supported: " + this.env.getVersion() + ", url: " + this.baseUri);
            this.onInitFail(NLS.bind((String)Messages.Connection_ErrConnection_OldVersion, (Object)this.env.getVersion(), (Object)"0.9.0"));
        }
        if (mon.isCanceled()) {
            return;
        }
        this.socket = new CodewindSocket(this);
        if (!this.socket.blockUntilFirstConnection((IProgressMonitor)mon.split(35))) {
            Logger.logError("Socket failed to connect: " + this.socket.socketUri);
            this.disconnect();
            throw new CodewindConnectionException(this.socket.socketUri);
        }
        if (mon.isCanceled()) {
            this.socket.close();
            return;
        }
        File cwctl = new File(CLIUtil.getCWCTLExecutable());
        this.filewatcher = new CodewindFilewatcherdConnection(this.baseUri.toString(), cwctl, new ICodewindProjectTranslator(){

            public Optional<String> getProjectId(IProject project) {
                CodewindApplication app;
                if (project != null && (app = CodewindConnection.this.getAppByLocation(project.getLocation())) != null) {
                    return Optional.of(app.projectID);
                }
                return Optional.empty();
            }
        }, (IAuthTokenProvider)this.getAuthManager());
        if (mon.isCanceled()) {
            this.disconnect();
            return;
        }
        this.isConnected = true;
        Logger.log("Connected to: " + this);
        mon.split(20);
        this.refreshApps(null);
    }

    public String getSocketNamespace() {
        return this.env.getSocketNamespace();
    }

    public CodewindSocket getSocket() {
        return this.socket;
    }

    private void onInitFail(String msg) throws ConnectException {
        Logger.log("Initializing Codewind connection failed: " + msg);
        this.disconnect();
        throw new ConnectException(msg);
    }

    public void disconnect() {
        Logger.log("Disconnecting connection: " + this);
        this.isConnected = false;
        if (this.socket != null) {
            this.socket.close();
        }
        if (this.filewatcher != null) {
            this.filewatcher.dispose();
        }
        for (CodewindApplication app : this.appMap.values()) {
            app.dispose();
        }
        this.appMap.clear();
    }

    public String getName() {
        if (this.name == null) {
            return "";
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public URI getBaseURI() {
        return this.baseUri;
    }

    public void setBaseURI(URI uri) {
        this.baseUri = uri != null && !uri.toString().endsWith("/") ? uri.resolve("/") : uri;
    }

    public String getConid() {
        return this.conid;
    }

    public void setUsername(String username) {
    }

    public String getUsername() {
        return null;
    }

    public void setAuthToken(AuthToken authToken) {
    }

    AuthToken getAuthToken(boolean update) throws IOException, JSONException {
        return null;
    }

    AuthManager getAuthManager() {
        return null;
    }

    private JSONObject getEnvData(URI baseUrl) throws JSONException, IOException {
        URI envUrl = baseUrl.resolve("api/v1/environment");
        String envResponse = null;
        try {
            HttpUtil.HttpResult result = HttpUtil.get(envUrl, this.getAuthToken(false));
            if (this.hasAuthFailure(result)) {
                result = HttpUtil.get(envUrl, this.getAuthToken(true));
            }
            envResponse = result.response;
        }
        catch (IOException e) {
            Logger.logError("Error contacting Environment endpoint", e);
            throw e;
        }
        return new JSONObject(envResponse);
    }

    public String getVersion(URI baseURI) {
        try {
            ConnectionEnv env = new ConnectionEnv(this.getEnvData(baseURI));
            return env.getVersion();
        }
        catch (Exception e) {
            Logger.logError("An error occurred trying to get the Codewind version.", e);
            return null;
        }
    }

    public static int compareVersions(String versionA, String versionB) throws NumberFormatException {
        int i;
        if (versionA.equals(versionB)) {
            return 0;
        }
        if ("latest".equals(versionA) || "x.x.dev".equals(versionA) || "unknown".equals(versionB)) {
            return 1;
        }
        if ("latest".equals(versionB) || "x.x.dev".equals(versionB) || "unknown".equals(versionA)) {
            return -1;
        }
        String[] digitsA = versionA.split("\\.");
        String[] digitsB = versionB.split("\\.");
        for (i = 0; i < digitsA.length; ++i) {
            int valueA = Integer.parseInt(digitsA[i]);
            if (i >= digitsB.length) {
                if (valueA == 0) continue;
                return 1;
            }
            int valueB = Integer.parseInt(digitsB[i]);
            if (valueA > valueB) {
                return 1;
            }
            if (valueA >= valueB) continue;
            return -1;
        }
        if (digitsB.length > digitsA.length) {
            for (i = digitsA.length; i < digitsB.length; ++i) {
                int valueB = Integer.parseInt(digitsB[i]);
                if (valueB == 0) continue;
                return -1;
            }
        }
        return 0;
    }

    public static boolean isSupportedVersion(String versionStr) {
        try {
            return CodewindConnection.compareVersions(versionStr, "0.9.0") >= 0;
        }
        catch (NumberFormatException e) {
            Logger.logError("Invalid version: " + versionStr, e);
            return false;
        }
    }

    public String getConnectionErrorMsg() {
        return this.connectionErrorMsg;
    }

    public void refreshApps(String projectID) {
        URI projectsURL = this.baseUri.resolve("api/v1/projects");
        try {
            HttpUtil.HttpResult result = HttpUtil.get(projectsURL, this.getAuthToken(false));
            if (this.hasAuthFailure(result)) {
                result = HttpUtil.get(projectsURL, this.getAuthToken(true));
            }
            CodewindApplicationFactory.getAppsFromProjectsJson(this, result.response, projectID);
            Logger.log("App list update success");
        }
        catch (Exception e) {
            CoreUtil.openDialog(true, Messages.Connection_ErrGettingProjectListTitle, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addApp(CodewindApplication app) {
        Map<String, CodewindApplication> map = this.appMap;
        synchronized (map) {
            this.appMap.put(app.projectID, app);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CodewindApplication> getApps() {
        Map<String, CodewindApplication> map = this.appMap;
        synchronized (map) {
            return new ArrayList<CodewindApplication>(this.appMap.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getAppIds() {
        Map<String, CodewindApplication> map = this.appMap;
        synchronized (map) {
            return new HashSet<String>(this.appMap.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeApp(String projectID) {
        CodewindApplication app = null;
        Map<String, CodewindApplication> map = this.appMap;
        synchronized (map) {
            app = this.appMap.remove(projectID);
        }
        if (app != null) {
            Logger.log("Removing the " + app.name + " application with id: " + projectID);
            CoreUtil.removeApplication(app);
            app.dispose();
        } else {
            Logger.log("No application found for deleted project: " + projectID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CodewindApplication getAppByID(String projectID) {
        Map<String, CodewindApplication> map = this.appMap;
        synchronized (map) {
            return this.appMap.get(projectID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CodewindApplication getAppByName(String name) {
        Map<String, CodewindApplication> map = this.appMap;
        synchronized (map) {
            for (CodewindApplication app : this.getApps()) {
                if (!app.name.equals(name)) continue;
                return app;
            }
        }
        Logger.log("No application found for name " + name);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CodewindApplication getAppByLocation(IPath location) {
        if (location == null) {
            return null;
        }
        String canonicalLocation = FileUtil.getCanonicalPath(location.toOSString());
        Map<String, CodewindApplication> map = this.appMap;
        synchronized (map) {
            for (CodewindApplication app : this.getApps()) {
                if (!FileUtil.getCanonicalPath(app.fullLocalPath.toOSString()).equals(canonicalLocation)) continue;
                return app;
            }
        }
        Logger.log("No application found for location: " + location);
        return null;
    }

    public boolean waitForReady(IProgressMonitor monitor) throws IOException, JSONException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IOException exception = null;
        for (int i = 0; i < 10; ++i) {
            try {
                mon.split(10);
                if (this.requestCodewindReady(500, 500)) {
                    return true;
                }
                if (mon.isCanceled()) {
                    return false;
                }
                Thread.sleep(500L);
                if (!mon.isCanceled()) continue;
                return false;
            }
            catch (IOException e) {
                exception = e;
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (exception != null) {
            throw exception;
        }
        return false;
    }

    public boolean requestCodewindReady(int connectTimeoutMS, int readTimeoutMS) throws IOException, JSONException {
        String endpoint = "ready";
        URI uri = this.baseUri.resolve(endpoint);
        HttpUtil.HttpResult result = HttpUtil.get(uri, this.getAuthToken(false), connectTimeoutMS, readTimeoutMS);
        if (this.hasAuthFailure(result)) {
            result = HttpUtil.get(uri, this.getAuthToken(true), connectTimeoutMS, readTimeoutMS);
        }
        this.checkResult(result, uri, true);
        return "true".equals(result.response);
    }

    public void requestProjectRestart(CodewindApplication app, String launchMode) throws JSONException, IOException {
        String restartEndpoint = "api/v1/projects/" + app.projectID + "/" + "restart";
        URI url = this.baseUri.resolve(restartEndpoint);
        JSONObject restartProjectPayload = new JSONObject();
        restartProjectPayload.put("startMode", (Object)launchMode);
        HttpUtil.HttpResult result = HttpUtil.post(url, this.getAuthToken(false), restartProjectPayload);
        if (this.hasAuthFailure(result)) {
            result = HttpUtil.post(url, this.getAuthToken(true), restartProjectPayload);
        }
        if (!result.isGoodResponse) {
            String msg = String.format("Received bad response from server %d with error message %s", result.responseCode, result.error);
            throw new IOException(msg);
        }
        app.invalidatePorts();
    }

    public void requestProjectOpenClose(CodewindApplication app, boolean enable) throws JSONException, IOException {
        String action = enable ? "open" : "close";
        String restartEndpoint = "api/v1/projects/" + app.projectID + "/" + action;
        URI url = this.baseUri.resolve(restartEndpoint);
        HttpUtil.HttpResult result = HttpUtil.put(url, this.getAuthToken(false));
        if (this.hasAuthFailure(result)) {
            result = HttpUtil.put(url, this.getAuthToken(true));
        }
        if (!result.isGoodResponse) {
            String msg = String.format("Received bad response from server %d with error message %s", result.responseCode, result.error);
            throw new IOException(msg);
        }
    }

    public JSONObject requestProjectStatus(CodewindApplication app) throws IOException, JSONException {
        URI statusUrl = this.baseUri.resolve("api/v1/projects");
        HttpUtil.HttpResult result = HttpUtil.get(statusUrl, this.getAuthToken(false));
        if (this.hasAuthFailure(result)) {
            result = HttpUtil.get(statusUrl, this.getAuthToken(true));
        }
        if (!result.isGoodResponse) {
            String msg = String.format("Received bad response from server %d with error message %s", result.responseCode, result.error);
            throw new IOException(msg);
        }
        if (result.response == null) {
            throw new IOException("Server returned good response code, but null response when getting initial state");
        }
        JSONArray allProjectStatuses = new JSONArray(result.response);
        for (int i = 0; i < allProjectStatuses.length(); ++i) {
            JSONObject projectStatus = allProjectStatuses.getJSONObject(i);
            if (!projectStatus.getString("projectID").equals(app.projectID)) continue;
            return projectStatus;
        }
        Logger.log("Didn't find status info for project " + app.name);
        return null;
    }

    public JSONObject requestProjectMetricsStatus(CodewindApplication app) throws IOException, JSONException {
        String endpoint = "api/v1/projects/" + app.projectID + "/" + "metrics/status";
        URI uri = this.baseUri.resolve(endpoint);
        HttpUtil.HttpResult result = HttpUtil.get(uri, this.getAuthToken(false));
        if (this.hasAuthFailure(result)) {
            result = HttpUtil.get(uri, this.getAuthToken(true));
        }
        this.checkResult(result, uri, true);
        return new JSONObject(result.response);
    }

    public void requestProjectBuild(CodewindApplication app, String action) throws JSONException, IOException {
        String buildEndpoint = "api/v1/projects/" + app.projectID + "/" + "build";
        URI url = this.baseUri.resolve(buildEndpoint);
        JSONObject buildPayload = new JSONObject();
        buildPayload.put("action", (Object)action);
        HttpUtil.HttpResult result = HttpUtil.post(url, this.getAuthToken(false), buildPayload);
        if (this.hasAuthFailure(result)) {
            result = HttpUtil.post(url, this.getAuthToken(true), buildPayload);
        }
        this.checkResult(result, url, false);
    }

    public List<ProjectLogInfo> requestProjectLogs(CodewindApplication app) throws JSONException, IOException {
        ArrayList<ProjectLogInfo> logList = new ArrayList<ProjectLogInfo>();
        String endpoint = "api/v1/projects/" + app.projectID + "/" + "logs";
        URI uri = this.baseUri.resolve(endpoint);
        HttpUtil.HttpResult result = HttpUtil.get(uri, this.getAuthToken(false));
        if (this.hasAuthFailure(result)) {
            result = HttpUtil.get(uri, this.getAuthToken(true));
        }
        this.checkResult(result, uri, true);
        JSONObject logs = new JSONObject(result.response);
        JSONArray buildLogs = logs.getJSONArray("build");
        logList.addAll(CodewindConnection.getLogs(buildLogs, "build"));
        JSONArray appLogs = logs.getJSONArray("app");
        logList.addAll(CodewindConnection.getLogs(appLogs, "app"));
        return logList;
    }

    public static List<ProjectLogInfo> getLogs(JSONArray logs, String type) throws JSONException {
        ArrayList<ProjectLogInfo> logList = new ArrayList<ProjectLogInfo>();
        if (logs != null) {
            for (int i = 0; i < logs.length(); ++i) {
                JSONObject log = logs.getJSONObject(i);
                if (log.has("logName")) {
                    String logName = log.getString("logName");
                    if ("-".equals(logName)) continue;
                    String workspacePath = null;
                    if (log.has("workspaceLogPath")) {
                        workspacePath = log.getString("workspaceLogPath");
                    }
                    ProjectLogInfo logInfo = new ProjectLogInfo(type, logName, workspacePath);
                    logList.add(logInfo);
                    continue;
                }
                Logger.log("An item in the log list does not have the key: logName");
            }
        }
        return logList;
    }

    public void requestEnableLogStream(CodewindApplication app, ProjectLogInfo logInfo) throws IOException, JSONException {
        String endpoint = "api/v1/projects/" + app.projectID + "/" + "logs" + "/" + logInfo.type + "/" + logInfo.logName;
        URI uri = this.baseUri.resolve(endpoint);
        HttpUtil.HttpResult result = HttpUtil.post(uri, this.getAuthToken(false));
        if (this.hasAuthFailure(result)) {
            result = HttpUtil.post(uri, this.getAuthToken(true));
        }
        this.checkResult(result, uri, false);
    }

    public void requestDisableLogStream(CodewindApplication app, ProjectLogInfo logInfo) throws IOException, JSONException {
        String endpoint = "api/v1/projects/" + app.projectID + "/" + "logs" + "/" + logInfo.type + "/" + logInfo.logName;
        URI uri = this.baseUri.resolve(endpoint);
        HttpUtil.HttpResult result = HttpUtil.delete(uri, this.getAuthToken(false));
        if (this.hasAuthFailure(result)) {
            result = HttpUtil.delete(uri, this.getAuthToken(true));
        }
        this.checkResult(result, uri, false);
    }

    public void requestValidate(CodewindApplication app) throws JSONException, IOException {
        String endpoint = "api/v1/projects/" + app.projectID + "/" + "validate";
        URI url = this.baseUri.resolve(endpoint);
        JSONObject buildPayload = new JSONObject();
        buildPayload.put("projectType", (Object)app.projectType.getId());
        HttpUtil.HttpResult result = HttpUtil.post(url, this.getAuthToken(false), buildPayload);
        if (this.hasAuthFailure(result)) {
            result = HttpUtil.post(url, this.getAuthToken(true), buildPayload);
        }
        if (!result.isGoodResponse) {
            String msg = String.format("Received bad response from server %d with error message %s", result.responseCode, result.error);
            throw new IOException(msg);
        }
    }

    public void requestValidateGenerate(CodewindApplication app) throws JSONException, IOException {
        String endpoint = "api/v1/projects/" + app.projectID + "/" + "validate/generate";
        URI url = this.baseUri.resolve(endpoint);
        JSONObject buildPayload = new JSONObject();
        buildPayload.put("projectType", (Object)app.projectType.getId());
        buildPayload.put("autoGenerate", true);
        HttpUtil.HttpResult result = HttpUtil.post(url, this.getAuthToken(false), buildPayload);
        if (this.hasAuthFailure(result)) {
            result = HttpUtil.post(url, this.getAuthToken(true), buildPayload);
        }
        if (!result.isGoodResponse) {
            String msg = String.format("Received bad response from server %d with error message %s", result.responseCode, result.error);
            throw new IOException(msg);
        }
        this.requestValidate(app);
    }

    public JSONObject requestProjectCapabilities(CodewindApplication app) throws IOException, JSONException {
        URI statusUrl = this.baseUri.resolve("api/v1/projects/" + app.projectID + "/" + "capabilities");
        HttpUtil.HttpResult result = HttpUtil.get(statusUrl, this.getAuthToken(false));
        if (this.hasAuthFailure(result)) {
            result = HttpUtil.get(statusUrl, this.getAuthToken(true));
        }
        if (!result.isGoodResponse) {
            String msg = String.format("Received bad response from server %d with error message %s", result.responseCode, result.error);
            throw new IOException(msg);
        }
        if (result.response == null) {
            throw new IOException("Server returned good response code, but empty content when getting project capabilities");
        }
        JSONObject capabilities = new JSONObject(result.response);
        return capabilities;
    }

    public List<ProjectTypeInfo> requestProjectTypes() throws IOException, JSONException {
        ArrayList<ProjectTypeInfo> projectTypes = new ArrayList<ProjectTypeInfo>();
        URI uri = this.baseUri.resolve("api/v1/project-types");
        HttpUtil.HttpResult result = HttpUtil.get(uri, this.getAuthToken(false));
        if (this.hasAuthFailure(result)) {
            result = HttpUtil.get(uri, this.getAuthToken(true));
        }
        this.checkResult(result, uri, true);
        JSONArray array = new JSONArray(result.response);
        for (int i = 0; i < array.length(); ++i) {
            projectTypes.add(new ProjectTypeInfo(array.getJSONObject(i)));
        }
        return projectTypes;
    }

    public List<RegistryInfo> requestRegistryList() throws IOException, JSONException {
        ArrayList<RegistryInfo> regList = new ArrayList<RegistryInfo>();
        URI uri = this.baseUri.resolve("api/v1/registrysecrets");
        HttpUtil.HttpResult result = HttpUtil.get(uri, this.getAuthToken(false));
        if (this.hasAuthFailure(result)) {
            result = HttpUtil.get(uri, this.getAuthToken(true));
        }
        this.checkResult(result, uri, true);
        JSONArray array = new JSONArray(result.response);
        for (int i = 0; i < array.length(); ++i) {
            regList.add(new RegistryInfo(array.getJSONObject(i)));
        }
        return regList;
    }

    public void requestAddRegistry(String address, String username, String password) throws IOException, JSONException {
        URI uri = this.baseUri.resolve("api/v1/registrysecrets");
        JSONObject credentials = new JSONObject();
        credentials.put("username", (Object)username);
        credentials.put("password", (Object)password);
        String encoding = Base64.getEncoder().encodeToString(credentials.toString().getBytes("UTF-8"));
        JSONObject payload = new JSONObject();
        payload.put("address", (Object)address);
        payload.put("credentials", (Object)encoding);
        HttpUtil.HttpResult result = HttpUtil.post(uri, this.getAuthToken(false), payload);
        if (this.hasAuthFailure(result)) {
            result = HttpUtil.post(uri, this.getAuthToken(true), payload);
        }
        this.checkResult(result, uri, true);
    }

    public void requestRemoveRegistry(String address, String username) throws IOException, JSONException {
        URI uri = this.baseUri.resolve("api/v1/registrysecrets");
        JSONObject payload = new JSONObject();
        payload.put("address", (Object)address);
        HttpUtil.HttpResult result = HttpUtil.delete(uri, this.getAuthToken(false), payload);
        if (this.hasAuthFailure(result)) {
            result = HttpUtil.delete(uri, this.getAuthToken(true), payload);
        }
        this.checkResult(result, uri, true);
    }

    public void requestSetPushRegistry(String address, String namespace) throws IOException, JSONException {
        URI uri = this.baseUri.resolve("api/v1/imagepushregistry");
        JSONObject payload = new JSONObject();
        payload.put("address", (Object)address);
        payload.put("namespace", (Object)namespace);
        payload.put("operation", (Object)"set");
        HttpUtil.HttpResult result = HttpUtil.post(uri, this.getAuthToken(false), payload);
        if (this.hasAuthFailure(result)) {
            result = HttpUtil.post(uri, this.getAuthToken(true), payload);
        }
        this.checkResult(result, uri, false);
    }

    public ImagePushRegistryInfo requestGetPushRegistry() throws IOException, JSONException {
        URI uri = this.baseUri.resolve("api/v1/imagepushregistry");
        HttpUtil.HttpResult result = HttpUtil.get(uri, this.getAuthToken(false));
        if (this.hasAuthFailure(result)) {
            result = HttpUtil.get(uri, this.getAuthToken(true));
        }
        this.checkResult(result, uri, true);
        JSONObject obj = new JSONObject(result.response);
        if (obj.has("imagePushRegistry") && obj.getBoolean("imagePushRegistry")) {
            return new ImagePushRegistryInfo(obj);
        }
        return null;
    }

    public boolean requestHasPushRegistry() throws IOException, JSONException {
        return this.requestGetPushRegistry() != null;
    }

    public void requestDeletePushRegistry(String address) throws IOException, JSONException {
        URI uri = this.baseUri.resolve("api/v1/imagepushregistry");
        JSONObject payload = new JSONObject();
        payload.put("address", (Object)address);
        HttpUtil.HttpResult result = HttpUtil.delete(uri, this.getAuthToken(false), payload);
        if (this.hasAuthFailure(result)) {
            result = HttpUtil.delete(uri, this.getAuthToken(true), payload);
        }
        this.checkResult(result, uri, false);
    }

    public void requestInjectMetrics(String projectID, boolean enable) throws IOException, JSONException {
        String endpoint = "api/v1/projects/" + projectID + "/" + "metrics/inject";
        URI uri = this.baseUri.resolve(endpoint);
        JSONObject buildPayload = new JSONObject();
        buildPayload.put("enable", enable);
        HttpUtil.HttpResult result = HttpUtil.post(uri, this.getAuthToken(false), buildPayload);
        if (this.hasAuthFailure(result)) {
            result = HttpUtil.post(uri, this.getAuthToken(true), buildPayload);
        }
        this.checkResult(result, uri, false);
        CoreUtil.updateConnection(this);
    }

    private boolean hasAuthFailure(HttpUtil.HttpResult result) {
        return result.responseCode == 302;
    }

    private void checkResult(HttpUtil.HttpResult result, URI uri, boolean checkContent) throws IOException {
        if (!result.isGoodResponse) {
            String msg = String.format("Received bad response code %d for uri %s with error message %s", result.responseCode, uri, result.error);
            throw new IOException(msg);
        }
        if (checkContent && result.response == null) {
            throw new IOException("Server returned good response code, but the content of the result is null for uri: " + uri);
        }
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void onConnectionError() {
        Logger.log("Connection to " + this.baseUri + " lost");
        this.isConnected = false;
        Map<String, CodewindApplication> map = this.appMap;
        synchronized (map) {
            this.appMap.clear();
        }
        CoreUtil.updateAll();
    }

    public synchronized void clearConnectionError() {
        Logger.log("Connection to " + this.baseUri + " restored");
        try {
            String oldSocketNS = this.env.getSocketNamespace();
            this.env = new ConnectionEnv(this.getEnvData(this.baseUri));
            if (!CodewindConnection.isSupportedVersion(this.env.getVersion())) {
                Logger.logError("The detected version of Codewind after reconnect is not supported: " + this.env.getVersion());
                this.connectionErrorMsg = NLS.bind((String)Messages.Connection_ErrConnection_OldVersion, (Object)this.env.getVersion(), (Object)"0.9.0");
                CoreUtil.updateConnection(this);
                return;
            }
            String socketNS = this.env.getSocketNamespace();
            if (socketNS != null && !socketNS.equals(oldSocketNS) || oldSocketNS != null && !oldSocketNS.equals(socketNS)) {
                this.socket.close();
                this.socket = new CodewindSocket(this);
                if (!this.socket.blockUntilFirstConnection((IProgressMonitor)new NullProgressMonitor())) {
                    Logger.logError("Failed to create a new socket with updated URI: " + this.socket.socketUri);
                    this.connectionErrorMsg = null;
                    CoreUtil.updateAll();
                    return;
                }
            }
        }
        catch (Exception e) {
            Logger.logError("An exception occurred while trying to update the connection information", e);
            this.connectionErrorMsg = Messages.Connection_ErrConnection_UpdateCacheException;
            CoreUtil.updateAll();
            return;
        }
        this.connectionErrorMsg = null;
        this.isConnected = true;
        this.refreshApps(null);
        CoreUtil.updateAll();
    }

    public String toString() {
        return String.format("%s @ name=%s baseUrl=%s conid=%s", CodewindConnection.class.getSimpleName(), this.name, this.baseUri == null ? "unknown" : this.baseUri, this.conid == null ? "<none>" : this.conid);
    }

    public ConnectionEnv.TektonDashboard getTektonDashboard() {
        return this.env.getTektonDashboard();
    }

    public URI getNewProjectURI() {
        return this.getProjectURI("new-project");
    }

    public URI getImportProjectURI() {
        return this.getProjectURI("import-project");
    }

    private URI getProjectURI(String projectQuery) {
        try {
            URI uri = this.baseUri;
            String query = projectQuery + "=" + "true";
            uri = new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), query, uri.getFragment());
            return uri;
        }
        catch (Exception e) {
            Logger.logError("Failed to get the project URI for the query: " + projectQuery, e);
            return null;
        }
    }

    public boolean isLocal() {
        return false;
    }
}

