/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.core.internal;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeoutException;
import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.CodewindObjectFactory;
import org.eclipse.codewind.core.internal.CoreUtil;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.cli.InstallStatus;
import org.eclipse.codewind.core.internal.cli.InstallUtil;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.core.internal.connection.CodewindConnectionManager;
import org.eclipse.codewind.core.internal.messages.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.json.JSONException;

public class CodewindManager {
    private static CodewindManager codewindManager;
    CodewindConnection localConnection = null;
    InstallStatus installStatus = InstallStatus.UNKNOWN;
    InstallerStatus installerStatus = null;

    private CodewindManager() {
        this.localConnection = CodewindObjectFactory.createCodewindConnection(Messages.CodewindLocalConnectionName, null, true);
        CodewindConnectionManager.add(this.localConnection);
        this.refreshInstallStatus((IProgressMonitor)new NullProgressMonitor());
        if (this.installStatus.isStarted()) {
            Job job = new Job(NLS.bind((String)Messages.Connection_JobLabel, (Object)this.localConnection.getName())){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        CodewindManager.this.localConnection.connect(monitor);
                        return Status.OK_STATUS;
                    }
                    catch (Exception e) {
                        Logger.logError("An error occurred trying to connect to the local Codewind instance at:" + CodewindManager.this.localConnection.getBaseURI(), e);
                        return new Status(4, "org.eclipse.codewind.core", NLS.bind((String)Messages.Connection_JobError, (Object[])new String[]{CodewindManager.this.localConnection.getName(), CodewindManager.this.localConnection.getBaseURI().toString()}), (Throwable)e);
                    }
                }
            };
            job.schedule();
        }
    }

    public static synchronized CodewindManager getManager() {
        if (codewindManager == null) {
            codewindManager = new CodewindManager();
        }
        return codewindManager;
    }

    public InstallStatus getInstallStatus() {
        return this.installStatus;
    }

    public synchronized void refreshInstallStatus(IProgressMonitor monitor) {
        String urlStr = null;
        try {
            SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            this.installStatus = InstallUtil.getInstallStatus((IProgressMonitor)mon.split(60));
            if (this.installStatus.isStarted()) {
                urlStr = this.installStatus.getURL();
                if (!this.localConnection.isConnected()) {
                    URI uri = new URI(urlStr);
                    this.localConnection.setBaseURI(uri);
                    this.localConnection.connect((IProgressMonitor)mon.split(40));
                }
            } else {
                this.localConnection.close();
                this.localConnection.setBaseURI(null);
            }
            return;
        }
        catch (IOException e) {
            Logger.logError("An error occurred trying to get the installer status", e);
        }
        catch (TimeoutException e) {
            Logger.logError("Timed out trying to get the installer status", e);
        }
        catch (JSONException e) {
            Logger.logError("The Codewind installer status format is not recognized", e);
        }
        catch (URISyntaxException e) {
            Logger.logError("The Codewind installer status command returned an invalid url: " + urlStr, e);
        }
        this.installStatus = InstallStatus.UNKNOWN;
    }

    public InstallerStatus getInstallerStatus() {
        return this.installerStatus;
    }

    public void setInstallerStatus(InstallerStatus status) {
        this.installerStatus = status;
        CoreUtil.updateAll();
    }

    public boolean isSupportedVersion(String version) {
        return CodewindConnection.isSupportedVersion(version);
    }

    public synchronized CodewindConnection getLocalConnection() {
        return this.localConnection;
    }

    public void refresh(IProgressMonitor monitor) {
        this.refreshInstallStatus(monitor);
        for (CodewindConnection conn : CodewindConnectionManager.activeConnections()) {
            if (!conn.isConnected()) continue;
            conn.refreshApps(null);
        }
    }

    public boolean hasActiveApplications() {
        for (CodewindConnection conn : CodewindConnectionManager.activeConnections()) {
            for (CodewindApplication app : conn.getApps()) {
                if (!app.isAvailable()) continue;
                return true;
            }
        }
        return false;
    }

    public static enum InstallerStatus {
        INSTALLING,
        UNINSTALLING,
        STARTING,
        STOPPING;

    }
}

