/*******************************************************************************
* Copyright (c) 2020 IBM Corporation and others.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v2.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v20.html
*
* Contributors:
*     IBM Corporation - initial API and implementation
*******************************************************************************/
import { FileWatcher } from "./FileWatcher";
/**
 * This class is used to watch a small number of individual files, for example,
 * linked files defined in the 'refPaths' field of a watched project. For a
 * large number of files to watch, the watch service should be used instead.
 *
 * Files watched by this class do not need to exist
 *
 * A single instance of this class will exist per filewatcher (eg it is not per
 * project).
 *
 * This class was introduced as part of 'Project sync support for reference to
 * files outside of project folder' (codewind/1399).
 */
export declare class IndividualFileWatchService {
    private _filesToWatchMap;
    private _filewatcher;
    private _disposed;
    private _timer;
    constructor(filewatcher: FileWatcher);
    setFilesToWatch(projectId: string, pathsFromPtw: string[]): void;
    dispose(): void;
    private threadRun;
    private innerThreadRun;
}
