/*******************************************************************************
* Copyright (c) 2019 IBM Corporation and others.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v2.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v20.html
*
* Contributors:
*     IBM Corporation - initial API and implementation
*******************************************************************************/
import { ProjectToWatch } from "./ProjectToWatch";
import { WatchEventEntry } from "./WatchEventEntry";
import { ProjectToWatchFromWebSocket } from "./ProjectToWatchFromWebSocket";
import { AuthTokenWrapper } from "./AuthTokenWrapper";
import { IAuthTokenProvider } from "./IAuthTokenProvider";
import { IWatchService } from "./IWatchService";
/**
 * This class maintains information about the projects being watched, and is
 * otherwise the "glue" between the other components. The class maintains
 * references to the other utilities (post queue, WebSocket connection, watch
 * service, etc) and forwards communication between them.
 *
 * Only one instance of this object will exist per server.
 */
export declare class FileWatcher {
    private readonly _projectsMap;
    private readonly _baseUrl;
    private readonly _wsBaseUrl;
    private readonly _getStatusThread;
    private readonly _internalWatchService;
    private readonly _externalWatchService;
    private readonly _outputQueue;
    private readonly _webSocketManager;
    private readonly _clientUuid;
    private readonly _installerPath;
    private readonly _authTokenWrapper;
    private _disposed;
    constructor(urlParam: string, internalWatchService: IWatchService, externalWatchService: IWatchService, installerPath: string, clientUuid: string, authTokenProvider: IAuthTokenProvider);
    updateFileWatchStateFromGetRequest(projectsToWatch: ProjectToWatch[]): void;
    receiveNewWatchEventEntry(watchEntry: WatchEventEntry, receivedAtInEpochMsecs: number): void;
    sendBulkFileChanges(projectId: string, mostRecentEntryTimestamp: number, base64Compressed: string[]): void;
    updateFileWatchStateFromWebSocket(ptwList: ProjectToWatchFromWebSocket[]): void;
    refreshWatchStatus(): void;
    /**
     * Inform the Codewind server of the success or failure of the project watch. Issues a PUT request to the server,
     * and keeps trying until the request succeeds.
     */
    sendWatchResponseAsync(successParam: boolean, ptw: ProjectToWatch): Promise<void>;
    /** Called by sendWatchResponseAsync and FileChangeEventBatchUtil  */
    informCwctlOfFileChangesAsync(projectId: string): Promise<void>;
    dispose(): void;
    generateDebugString(): string;
    private removeSingleProjectToWatch;
    private createOrUpdateProjectToWatch;
    /** May return null if the installer path is not defined. */
    readonly installerPath: string;
    readonly authTokenWrapper: AuthTokenWrapper;
}
