/*******************************************************************************
 * Copyright (c) 2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.datatools.examples.podreader.cp;

import java.io.File;
import java.util.Properties;

import org.eclipse.datatools.connectivity.IConnection;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.Version;
import org.eclipse.datatools.connectivity.VersionProviderConnection;

public class PodConnection extends VersionProviderConnection implements
		IConnection {

	private final static String TECHNOLOGY_ROOT_KEY = "podreaderSample";

	private File podFile;
	private Exception connectException;

	public PodConnection(IConnectionProfile profile) {
		super(profile, PodConnectionFactory.class);
		Properties props = profile.getBaseProperties();
		final String path = props
				.getProperty(PodProfilePropertyConstants.POD_FILE_PATH);
		if (path == null) {
			podFile = null;
		}
		else {
			podFile = new File(path);
			if (!podFile.isDirectory() || !podFile.exists()) {
				podFile = null;
			}
		}
		if (podFile == null) {
			connectException = new Exception(
					"Specified directory does not exist.");
			clearVersionCache();
		}
		else {
			updateVersionCache();
		}
	}

	public Object getRawConnection() {
		return podFile;
	}

	public void close() {
		// Nothing to do here. We don't really open anything.
		podFile = null;
		connectException = null;
	}

	public Throwable getConnectException() {
		return connectException;
	}

	protected String getTechnologyRootKey() {
		return TECHNOLOGY_ROOT_KEY;
	}

	public String getProviderName() {
		// We'll use the OS name for the technology type
		return System.getProperty("os.name");
	}

	public Version getProviderVersion() {
		// We'll use the OS version for the technology version
		return Version.valueOf(System.getProperty("os.version"));
	}

	public String getTechnologyName() {
		// We'll use the JVM name for the provider name
		return System.getProperty("java.vendor");
	}

	public Version getTechnologyVersion() {
		// We'll use the JVM version for the provider version
		return Version.valueOf(System.getProperty("java.version"));
	}
}
