/*******************************************************************************
 * Copyright (c) 2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.datatools.examples.podreader.views;

import org.eclipse.datatools.examples.podreader.parser.Song;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;

public class ViewLabelProvider implements ITableLabelProvider {

	public Image getColumnImage(Object element, int columnIndex) {
		// No images for columns
		return null;
	}

	public String getColumnText(Object element, int columnIndex) {
		String res = null;
		if (element instanceof Song) {
			Song s = (Song)element;
			switch (columnIndex) {
			case 0:
				res = s.getName();
			break;
			case 1:
				res = s.getArtist();
			break;
			case 2:
				res = s.getAlbum();
			break;
			case 3:
				res = s.getGenre();
			break;
			}
		}
		return res == null?"":res;
	}

	public void addListener(ILabelProviderListener listener) {
		// Nothing to do here for this example
	}

	public void dispose() {
		// Nothing to do here for this example
	}

	public boolean isLabelProperty(Object element, String property) {
		return false;
	}

	public void removeListener(ILabelProviderListener listener) {
		// Nothing to do here for this example	
	}
}
