/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.impl;

import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.IComponent;
import org.eclipse.hyades.logging.adapter.IProcessUnit;
import org.eclipse.hyades.logging.adapter.impl.Status;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.CompletionException;
import org.eclipse.hyades.logging.events.cbe.ComponentIdentification;
import org.eclipse.hyades.logging.events.cbe.EventFactory;
import org.eclipse.hyades.logging.events.cbe.EventFactoryHome;
import org.eclipse.hyades.logging.events.cbe.MsgDataElement;
import org.eclipse.hyades.logging.events.cbe.Situation;
import org.eclipse.hyades.logging.events.cbe.impl.EventFactoryContext;
import org.w3c.dom.Element;

public class Component
implements IComponent {
    protected IProcessUnit logger = null;
    private short loggingLevel = 0;
    private String name = null;
    private String role = null;
    private String executableClassName = null;
    private String description = null;
    private String uniqueID = null;
    private String roleVersion = null;
    private String implVersion = null;
    private String roleVersionDescription = null;
    private String implVersionDescription = null;
    private String roleCreationDate = null;
    private String implCreationDate = null;
    private IComponent[] components = null;
    private IComponent parent = null;
    private EventFactory eventFactory = null;
    private static final short SEVERITY_TRACE = 5;
    protected Status status = new Status();
    protected boolean stopping = false;
    private Element configuration = null;
    private Element contextConfiguration = null;
    static /* synthetic */ Class class$0;

    public boolean init() {
        IComponent[] components;
        String loggingLevelAttrName;
        Element element = this.getContextConfiguration();
        if (element.hasAttribute(Messages.getString("HyadesGADescriptionAttributeName"))) {
            this.setDescription(element.getAttribute(Messages.getString("HyadesGADescriptionAttributeName")));
        }
        if (element.hasAttribute(Messages.getString("HyadesGARoleAttributeName"))) {
            this.setRole(element.getAttribute(Messages.getString("HyadesGARoleAttributeName")));
        }
        if (element.hasAttribute(loggingLevelAttrName = Messages.getString("HyadesGALoggingLevelAttributeName"))) {
            String logLvl = element.getAttribute(loggingLevelAttrName);
            try {
                this.setLoggingLevel(Short.valueOf(logLvl));
            }
            catch (NumberFormatException numberFormatException) {
                this.setLoggingLevel((short)30);
                CommonBaseEvent errorEvent = this.getEventFactory().createCommonBaseEvent();
                errorEvent.setMsg(Messages.getString("HyadesGAContextConfigurationWarning_Logging_Level_Incorrect_WARN_", logLvl, loggingLevelAttrName, this.getName()));
                errorEvent.setSeverity((short)30);
                this.log(errorEvent);
            }
        }
        if (element.hasAttribute(Messages.getString("HyadesGARoleVersionAttributeName"))) {
            this.setRoleVersion(element.getAttribute(Messages.getString("HyadesGARoleVersionAttributeName")));
        }
        if (element.hasAttribute(Messages.getString("HyadesGARoleCreationDateAttributeName"))) {
            this.setRoleCreationDate(element.getAttribute(Messages.getString("HyadesGARoleCreationDateAttributeName")));
        }
        if (element.hasAttribute(Messages.getString("HyadesGARoleVersionDescriptionAttributeName"))) {
            this.setRoleVersionDescription(element.getAttribute(Messages.getString("HyadesGARoleVersionDescriptionAttributeName")));
        }
        if (element.hasAttribute(Messages.getString("HyadesGAImplementationVersionAttributeName"))) {
            this.setImplementationVersion(element.getAttribute(Messages.getString("HyadesGAImplementationVersionAttributeName")));
        }
        if (element.hasAttribute(Messages.getString("HyadesGAImplemenationCreationDateAttributeName"))) {
            this.setImplemenationCreationDate(element.getAttribute(Messages.getString("HyadesGAImplemenationCreationDateAttributeName")));
        }
        if (element.hasAttribute(Messages.getString("HyadesGAImplemenationVersionDescriptionAttributeName"))) {
            this.setImplementationVersionDescription(element.getAttribute(Messages.getString("HyadesGAImplemenationVersionDescriptionAttributeName")));
        }
        if ((components = this.getComponents()) != null) {
            int i = 0;
            while (i < components.length) {
                components[i].setLogger(this.getLogger());
                if (!components[i].init()) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public void start() {
        this.status.setActive(true);
    }

    public void stop(int toStop) {
    }

    public void stop() {
        if (this.components != null) {
            int i = 0;
            while (i < this.components.length) {
                this.components[i].stop();
                ++i;
            }
        }
        this.stopping = true;
        this.status.setActive(false);
    }

    public void update(Element config) throws AdapterInvalidConfig {
        this.setConfiguration(config);
        this.update();
    }

    public void update() throws AdapterInvalidConfig {
        Element element = this.getConfiguration();
        this.status.setName(this.getName());
        this.setDescription(element.getAttribute(Messages.getString("HyadesGADescriptionAttributeName")));
        this.setUniqueID(element.getAttribute(Messages.getString("HyadesGAUniqueIDAttributeName")));
        IComponent[] components = this.getComponents();
        if (components != null) {
            int i = 0;
            while (i < components.length) {
                components[i].update();
                CommonBaseEvent configureEvent = this.getEventFactory().createCommonBaseEvent();
                configureEvent.setMsg(Messages.getString("HyadesGAComponent_ConfigurationComplete_INFO_", components[i].getName()));
                configureEvent.setSeverity((short)10);
                Situation configSituation = this.getEventFactory().createSituation();
                configSituation.setConfigureSituation("INTERNAL", "SUCCESSFUL");
                configureEvent.setSituation(configSituation);
                this.log(configureEvent);
                ++i;
            }
        }
    }

    public Element getContextConfiguration() {
        return this.contextConfiguration;
    }

    public void setContextConfiguration(Element newConfiguration) {
        this.contextConfiguration = newConfiguration;
    }

    public Element getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Element newConfiguration) {
        this.configuration = newConfiguration;
    }

    public IProcessUnit getLogger() {
        return this.logger;
    }

    public void setLogger(IProcessUnit logger) {
        this.logger = logger;
    }

    public EventFactory getEventFactory() {
        if (this.eventFactory == null) {
            EventFactoryHome eventFactoryHome;
            EventFactoryContext eventFactoryContext = EventFactoryContext.getInstance();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.hyades.logging.adapter.impl.Component");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((eventFactoryHome = eventFactoryContext.getEventFactoryHome("org.eclipse.hyades.logging.adapter.internal.util.RuntimeEventXMLFileEventFactoryHomeImpl", clazz.getClassLoader())) != null) {
                this.eventFactory = eventFactoryHome.getEventFactory("org.eclipse.hyades.logging.adapter.impl.Component");
                this.eventFactory.setCompleteEvent(true);
            } else {
                this.eventFactory = EventFactoryContext.getInstance().getSimpleEventFactoryHome().getAnonymousEventFactory();
            }
        }
        return this.eventFactory;
    }

    public short getLoggingLevel() {
        return this.loggingLevel;
    }

    public void setLoggingLevel(short newLevel) {
        this.loggingLevel = newLevel;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String newRole) {
        this.role = newRole;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String newDescription) {
        this.description = newDescription;
    }

    public String getUniqueID() {
        return this.uniqueID;
    }

    public void setUniqueID(String newUniqueID) {
        this.uniqueID = newUniqueID;
    }

    public String getExecutableClassName() {
        return this.executableClassName;
    }

    public void setExecutableClassName(String newExecutableClassName) {
        this.executableClassName = newExecutableClassName;
    }

    public String getRoleVersion() {
        return this.roleVersion;
    }

    public void setRoleVersion(String newRoleVersion) {
        this.roleVersion = newRoleVersion;
    }

    public String getRoleCreationDate() {
        return this.roleCreationDate;
    }

    public void setRoleCreationDate(String newCreationDate) {
        this.roleCreationDate = newCreationDate;
    }

    public String getRoleVersionDescription() {
        return this.roleVersionDescription;
    }

    public void setRoleVersionDescription(String newRoleVersionDescription) {
        this.roleVersionDescription = newRoleVersionDescription;
    }

    public String getImplementationVersion() {
        return this.implVersion;
    }

    public void setImplementationVersion(String newImplementationVersion) {
        this.implVersion = newImplementationVersion;
    }

    public String getImplementationCreationDate() {
        return this.implCreationDate;
    }

    public void setImplemenationCreationDate(String newImplementationCreationDate) {
        this.implCreationDate = newImplementationCreationDate;
    }

    public String getImplementationVersionDescription() {
        return this.implVersionDescription;
    }

    public void setImplementationVersionDescription(String newImplementationVersionDescription) {
        this.implVersionDescription = newImplementationVersionDescription;
    }

    public IComponent[] getComponents() {
        return this.components;
    }

    public void setComponents(IComponent[] newComponents) {
        this.components = newComponents;
        int i = 0;
        while (i < this.components.length) {
            this.components[i].setParent(this);
            ++i;
        }
    }

    public void clean() {
        if (this.components == null) {
            return;
        }
        int i = 0;
        while (i < this.components.length) {
            this.components[i] = null;
            ++i;
        }
        this.components = null;
    }

    public void trace(String msgKey, String sub) {
        if (msgKey != null && this.loggingLevel == 0) {
            String msg = sub != null ? Messages.getString(msgKey, sub) : Messages.getString(msgKey);
            this.trace(msg);
        }
    }

    public void trace(String msgKey, String sub1, String sub2) {
        if (msgKey != null && sub1 != null && sub2 != null && this.loggingLevel == 0) {
            this.trace(Messages.getString(msgKey, sub1, sub2), null);
        }
    }

    public void trace(String msgKey, String sub1, String sub2, String sub3) {
        if (msgKey != null && sub1 != null && sub2 != null && sub3 != null && this.loggingLevel == 0) {
            this.trace(Messages.getString(msgKey, sub1, sub2, sub3), null);
        }
    }

    private void trace(String msg) {
        if (msg != null) {
            CommonBaseEvent traceEvent = this.getEventFactory().createCommonBaseEvent();
            traceEvent.setMsg(msg);
            traceEvent.setSeverity((short)5);
            Situation reportSituation = this.getEventFactory().createSituation();
            reportSituation.setReportSituation("INTERNAL", "TRACE");
            traceEvent.setSituation(reportSituation);
            this.log(traceEvent);
        }
    }

    public void log(CommonBaseEvent event) {
        if (event != null && event.getSeverity() >= this.loggingLevel) {
            IProcessUnit glaLogger;
            ComponentIdentification sourceComponentId;
            String msgCatalogId;
            MsgDataElement msgDataElement;
            String msg = event.getMsg();
            if ((msg == null || msg.length() == 0) && (msgDataElement = event.getMsgDataElement()) != null && (msgCatalogId = msgDataElement.getMsgCatalogId()) != null) {
                String[] msgCatalogTokens = msgDataElement.getMsgCatalogTokensAsStrings();
                if (msgCatalogTokens == null || msgCatalogTokens.length == 0) {
                    event.setMsg(Messages.getString(msgCatalogId));
                } else {
                    event.setMsg(Messages.getString(msgCatalogId, msgCatalogTokens));
                }
            }
            if (!event.isComplete()) {
                try {
                    event.complete();
                }
                catch (CompletionException completionException) {}
            }
            if ((sourceComponentId = event.getSourceComponentId()) != null) {
                sourceComponentId.setComponent(this.getName());
                sourceComponentId.setSubComponent(this.getUniqueID());
                sourceComponentId.setComponentIdType(this.getRole());
            }
            if ((glaLogger = this.getLogger()) != null) {
                glaLogger.processEventItems(new CommonBaseEvent[]{event});
            }
        }
    }

    public void log(CommonBaseEvent event, short level) {
        if (event != null) {
            event.setSeverity(level);
            this.log(event);
        }
    }

    public void setParent(IComponent parent) {
        this.parent = parent;
    }

    public IComponent getParent() {
        return this.parent;
    }

    public boolean isStopping() {
        return this.stopping;
    }

    public void setStopping(boolean stopping) {
        this.stopping = stopping;
    }

    public int getItemsProcessedCount() {
        return this.status.getItemsProcessedCount();
    }

    public void incrementItemsProcessedCount() {
        this.status.setItemsProcessedCount(this.status.getItemsProcessedCount() + 1);
    }

    public void incrementItemsProcessedCount(int n) {
        this.status.setItemsProcessedCount(this.status.getItemsProcessedCount() + n);
    }

    public Status getComponentStatus() {
        return this.status;
    }
}

