/*******************************************************************************
 * Copyright (c) 2010 Engineering Group.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Marco Cortella (Engineering Group) - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.ebam.emf;

import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.Query;

import org.eclipse.ebam.emf.interfaces.IJournalTransactions;
import org.eclipse.ebam.model.entities.Journal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


public class JournalTransactions extends EMF implements IJournalTransactions{

	/**
	 * Logger.
	 */
	private static Logger logger = LoggerFactory
			.getLogger(JournalTransactions.class);

	/**Method that executes database query to extract 
	 * <code>ServiceInstance</code> by label.
	 * @param label to search
	 * @param serviceID service id
	 * @return <code>ServiceInstance</code>
	 * @throws Exception error
	 */

	public Journal getJornalForRecovery(final String sourceName) 
														throws Exception {
		Journal journal = null;
		EntityManager em = getEMF().createEntityManager();
		try {
			Query query = em
					.createQuery("select j from Journal j where j.jurnalId =( select max(e.jurnalId) from Journal "
			+ "e where e.sourceName = :sourceName )");
			query.setParameter("sourceName", sourceName);
			journal = (Journal) query.getSingleResult();
		} catch (NoResultException e) {
			//logger.debug(e.getMessage(), e);
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		} finally {
			em.close();
			return journal;
		}
	}
}
