/*******************************************************************************
 * Copyright (c) 2010 Engineering Group.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Marco Cortella (Engineering Group) - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.ebam.emf;

import java.util.List;

import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import javax.persistence.Query;

import org.eclipse.ebam.emf.interfaces.ISbiDomainTransactions;
import org.eclipse.ebam.model.entities.SbiAlarm;
import org.eclipse.ebam.model.entities.SbiDomain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;



public class SbiDomainTransactions extends EMF implements ISbiDomainTransactions {

	/**
	 * Logger.
	 */
	private static Logger logger = 
		LoggerFactory.getLogger(SbiDomainTransactions.class);


/** get domain by code and domainCd
 * 
 * @param code
 * @return
 * @throws Exception
 */

	public final SbiDomain getSbiDomainByCodeAndDomainCd(String code, String domainCd) throws Exception{
		SbiDomain sbiDomain=null;
		EntityManager em = getEMF().createEntityManager();
		try {
			Query query = em.createQuery("select d from "
					+ "SbiDomain d where d.valueCd = :code AND d.domainCd = :domainCd");
			query.setParameter("code", code);
			query.setParameter("domainCd", domainCd);
			sbiDomain=(SbiDomain)query.getSingleResult();
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
		} finally {			
			em.close();
			return sbiDomain;
		}
	}

	
	
	public final SbiDomain getSbiDomainByCode(String code) throws Exception{
		SbiDomain sbiDomain=null;
		EntityManager em = getEMF().createEntityManager();
		try {
			Query query = em.createQuery("select d from "
					+ "SbiDomain d where d.valueCd = :code");
			query.setParameter("code", code);
			sbiDomain=(SbiDomain)query.getSingleResult();
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
		} finally {			
			em.close();
			return sbiDomain;
		}
	}

/** geto domain by id.
 * 
 * @param id
 * @return
 * @throws Exception
 */
	
	public final SbiDomain getDomainById(Integer id) throws Exception{
		SbiDomain sbiDomain = null;
		EntityManager em = getEMF().createEntityManager();
		try {
			Query query = em.createQuery("select d from "
					+ "SbiDomain d where d.valueId = :id");
			query.setParameter("id", id);
			sbiDomain = (SbiDomain)query.getSingleResult();        

		} catch (Exception e) {
			logger.error(e.getMessage(), e);
		} finally {			
			em.close();
			return sbiDomain;
		}

	}


	/** get domains by domain cd.
	 * 
	 * @param id
	 * @return
	 * @throws Exception
	 */
		
		public final List getDomainByDomainCd(String domainCd) throws Exception{
			List<SbiDomain> sbiDomains = null;
			EntityManager em = getEMF().createEntityManager();
			try {
				Query query = em.createQuery("select d from "
						+ "SbiDomain d where d.domainCd = :domainCd");
				query.setParameter("domainCd", domainCd);
				sbiDomains = query.getResultList();        

			} catch (Exception e) {
				logger.error(e.getMessage(), e);
			} finally {			
				em.close();
				return sbiDomains;
			}

		}

		

	/**Method that persists <code>Domain</code> on database.
	 * @param alarm <code>Domain</code> to save
	 * @return operation result
	 * @throws Exception error on saving 
	 */
	public final boolean createNewAlarm(final SbiAlarm alarm) throws Exception {
		boolean isSaved = false;
		EntityManager em = getEMF().createEntityManager();
		try {
			em.getTransaction().begin();

			// Set the flush-mode so the manager query does not force a 
			// write before the read.
			em.setFlushMode(FlushModeType.COMMIT);

			em.persist(alarm);

			em.getTransaction().commit();
			//em.flush();
			isSaved = true;

		} catch (Exception e) {
			if (em.getTransaction() != null && em.getTransaction().isActive()) {
				em.getTransaction().rollback();
			}			
			logger.error(e.getMessage(), e);
			throw e;
		} finally {			
			em.close();
			return isSaved;
		}
	}





}
