/*******************************************************************************
 * Copyright (c) 2010 Engineering Group.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Marco Cortella (Engineering Group) - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.ebam.emf.interfaces;

import java.util.List;
import java.util.Map;

import javax.xml.namespace.QName;

import org.eclipse.ebam.model.entities.DataAttribute;
import org.eclipse.ebam.model.entities.Event;
import org.eclipse.ebam.model.entities.EventAttribute;
import org.eclipse.ebam.model.entities.Message;
import org.eclipse.ebam.model.entities.Rule;
import org.eclipse.ebam.model.entities.SbiDomain;

public interface ICEPTransaction {
	
	/**
	 * Logger.
	 */
	
	public String retrieveStatement(Integer idStatement);
	 	
	public String retrieveListener(Integer idStatement);
	
	public List<Message> retrieveEbamMessages();
	public Integer retrieveIdMessage(Integer i);
	
	
	public List <DataAttribute> retrieveEbamDataAttributes(Integer idEventMessage) ;
	public Map<String,String> retrieveAttributesPath(Integer idEventMessage);

	
	public Map<String,QName> retrieveAttributesType(Integer idEventMessage);
	public String retrieveNameEvent(Integer idEventMessage);
	
	public String retrieveRootNameElement(Integer idEventMessage);

	public List<Rule> retrieveCEPRules();
	public List<Rule> retrieveCEPRulesByType(SbiDomain domainType);
	
	public List<EventAttribute> getAttributesByEventId(Double EventId) throws Exception;

	public Event getEventbyId(Double idEvent) throws Exception;
	
	public Rule retrieveCEPRuleByEventId(Double eventId) throws Exception;

	public void storeOnEventContent(EventAttribute n, String value)throws Exception; 
}
