/*******************************************************************************
 * Copyright (c) 2010 Engineering Group.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Marco Cortella (Engineering Group) - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.ebam.model.entities;

import java.io.Serializable;
import java.util.List;
import java.util.Set;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;


/**
 * The persistent class for the sbi_domains database table.
 * 
 */
@Entity
@Table(name="SBI_DOMAINS")
public class SbiDomain implements Serializable {
	private static final long serialVersionUID = 1L;
	
	public static final Integer CEP_ENGINE = 18;
	public static final Integer BASE_ENGINE = 17;

	@Id
	@Column(name="VALUE_ID")
	private Integer valueId;

	@Column(name="DOMAIN_CD")
	private String domainCd;

	@Column(name="DOMAIN_NM")
	private String domainNm;

	@Column(name="VALUE_CD")
	private String valueCd;

	@Column(name="VALUE_DS")
	private String valueDs;

	@Column(name="VALUE_NM")
	private String valueNm;

	//bi-directional many-to-one association to SbiThreshold
	@OneToMany(mappedBy="sbiDomain",fetch=FetchType.LAZY)
	private Set<SbiThreshold> sbiThresholds;

	//bi-directional many-to-one association to SbiThresholdValue
	@OneToMany(mappedBy="sbiDomain",fetch=FetchType.LAZY)
	private Set<SbiThresholdValue> sbiThresholdValues;
	
	//bi-directional many-to-one association to Message
	@OneToMany(mappedBy="sbiDomain",fetch=FetchType.LAZY)
	private Set<Message> messages;
	
	//bi-directional many-to-one association to CepRule
	@OneToMany(mappedBy="sbiDomain",fetch=FetchType.LAZY)
	private Set<Rule> cepRules;
	
	//bi-directional many-to-one association to CepRule
	@OneToMany(mappedBy="sbiDomain",fetch=FetchType.LAZY)
	private Set<SbiResources> sbiResources;
	
	 //bi-directional one-to-many association to EbamMessageEngine
	@OneToMany(mappedBy="sbiDomain",fetch=FetchType.LAZY)
	@JoinColumn(name="VALUE_ID")
	private List<MessageEngine> messageEngines;

    public Set<SbiResources> getSbiResources() {
		return sbiResources;
	}

	public void setSbiResources(Set<SbiResources> sbiResources) {
		this.sbiResources = sbiResources;
	}

	public SbiDomain() {
    }

	public int getValueId() {
		return this.valueId;
	}

	public void setValueId(int valueId) {
		this.valueId = valueId;
	}

	public String getDomainCd() {
		return this.domainCd;
	}

	public void setDomainCd(String domainCd) {
		this.domainCd = domainCd;
	}

	public String getDomainNm() {
		return this.domainNm;
	}

	public void setDomainNm(String domainNm) {
		this.domainNm = domainNm;
	}

	public String getValueCd() {
		return this.valueCd;
	}

	public void setValueCd(String valueCd) {
		this.valueCd = valueCd;
	}

	public String getValueDs() {
		return this.valueDs;
	}

	public void setValueDs(String valueDs) {
		this.valueDs = valueDs;
	}

	public String getValueNm() {
		return this.valueNm;
	}

	public void setValueNm(String valueNm) {
		this.valueNm = valueNm;
	}

	public Set<SbiThreshold> getSbiThresholds() {
		return this.sbiThresholds;
	}

	public void setSbiThresholds(Set<SbiThreshold> sbiThresholds) {
		this.sbiThresholds = sbiThresholds;
	}
	
	public Set<SbiThresholdValue> getSbiThresholdValues() {
		return this.sbiThresholdValues;
	}

	public void setSbiThresholdValues(Set<SbiThresholdValue> sbiThresholdValues) {
		this.sbiThresholdValues = sbiThresholdValues;
	}
	public Set<Rule> getCepRules() {
		return this.cepRules;
	}

	public void setCepRules(Set<Rule> cepRules) {
		this.cepRules = cepRules;
	}
	
	public Set<Message> getMessages() {
		return this.messages;
	}

	
	public void setMessages(Set<Message> messages) {
		this.messages = messages;
	}

	public List<MessageEngine> getMessageEngine() {
		return messageEngines;
	}

	public void setMessageEngine(List<MessageEngine> messageEngine) {
		messageEngines = messageEngine;
	}

	public void setValueId(Integer valueId) {
		this.valueId = valueId;
	}
	
}