/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebam.customengine.rules.pingSco;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.ebam.customengine.IEbamBaseRule;
import org.eclipse.ebam.customengine.utils.MsgReadUtils;
import org.eclipse.ebam.event.EbamEvent;
import org.eclipse.ebam.event.IEbamEvent;
import org.eclipse.ebam.messages.IEbamMessage;
import org.eclipse.ebam.model.entities.Rule;
import org.eclipse.ebam.model.entities.SbiAlarm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PingScoErrorRule
implements IEbamBaseRule {
    private Rule rule = null;
    Map<String, TreeSet<Date>> aziendaErrors = new HashMap<String, TreeSet<Date>>();
    SbiAlarm sbiAlarm = null;
    String xPathFilter = null;
    int maxErrors = -1;
    private static Logger logger = LoggerFactory.getLogger(PingScoErrorRule.class);
    static final SimpleDateFormat startDateFormat = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss");
    public static final int MAX_ERROR_DEFAULT = 3;
    public static final long MIN_INTERVAL = 1000000L;

    public Rule getRule() {
        return this.rule;
    }

    public void setRule(Rule rule) {
        this.rule = rule;
    }

    public void init(String config) {
    }

    public IEbamEvent executeRule(IEbamMessage msg) {
        logger.debug("IN");
        IEbamEvent toReturn = null;
        String azienda = MsgReadUtils.extractByQuery(msg, "//*/DTL/AZND", null);
        boolean generateEvent = this.checkErrors(azienda, msg);
        if (generateEvent) {
            toReturn = this.createEvent();
        }
        logger.debug("OUT");
        return toReturn;
    }

    public boolean checkErrors(String azienda, IEbamMessage msg) {
        logger.debug("IN");
        boolean toReturn = false;
        String stato = MsgReadUtils.extractByQuery(msg, "//*/DTL/ERRORE", null);
        if (this.maxErrors == -1) {
            this.maxErrors = 3;
            if (this.sbiAlarm != null && this.sbiAlarm.getSbiThresholdValue() != null) {
                this.maxErrors = (int)this.sbiAlarm.getSbiThresholdValue().getMinValue();
            }
        }
        if (stato != null && !stato.equals("")) {
            logger.debug("It is an error for azienda " + azienda);
            String startDate = MsgReadUtils.extractByQuery(msg, "//*/HDR/START_TS", null);
            Date errorDate = null;
            try {
                errorDate = startDateFormat.parse(startDate);
                logger.debug("Error at date " + errorDate);
            }
            catch (ParseException parseException) {
                logger.error("Error in converting date " + startDate + ": will put actual as default!");
                errorDate = new Date();
            }
            TreeSet<Date> errors = this.aziendaErrors.get(azienda);
            if (errors == null) {
                errors = new TreeSet();
                this.aziendaErrors.put(azienda, errors);
                logger.debug("first error for azienda " + azienda + " cretae data structure TreeSet");
            }
            errors.add(errorDate);
            if (errors.size() >= this.maxErrors) {
                logger.debug("More than maxErrors number for azienda " + azienda);
                Date firstError = errors.first();
                Date lastError = errors.last();
                logger.debug("More than maxErrors number for azienda " + azienda + " between " + firstError + " and " + lastError);
                long interval = lastError.getTime() - firstError.getTime();
                if (interval < 1000000L) {
                    logger.debug("Exceeded maxErrors number " + this.maxErrors + ", Generate the alarm");
                    toReturn = true;
                }
                errors.remove(firstError);
            }
        }
        return toReturn;
    }

    public IEbamEvent createEvent() {
        EbamEvent ev = new EbamEvent();
        ev.setType("ALARM");
        if (this.sbiAlarm != null) {
            ev.setAlarmLabel(this.sbiAlarm.getLabel());
        } else {
            logger.warn("alarm not found");
        }
        return ev;
    }

    public SbiAlarm getSbiAlarm() {
        return this.sbiAlarm;
    }

    public void setSbiAlarm(SbiAlarm sbiAlarm) {
        this.sbiAlarm = sbiAlarm;
    }

    public String getXPathFilter() {
        return this.xPathFilter;
    }

    public void setXPathFilter(String xPathFilter) {
        this.xPathFilter = xPathFilter;
    }
}

