/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.util;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import org.eclipse.hyades.logging.adapter.util.BufferedPeriodicReader;
import org.eclipse.hyades.logging.adapter.util.Messages;

public class BufferedSinglePassReader
extends BufferedPeriodicReader {
    private FileInputStream logStream;
    private boolean endOfFile = false;
    private String eolCharacters = null;
    private char eolLastCharacter;
    private int logBufferInitialSize = 65536;
    private int bytesRead = 0;
    private byte[] logBuffer = new byte[this.logBufferInitialSize];
    private int lastOffset = 0;

    public BufferedSinglePassReader(String newFilename) {
        super(newFilename);
    }

    public BufferedSinglePassReader(String newFilename, String converter) {
        super(newFilename, converter);
    }

    public BufferedSinglePassReader(String newFilename, String converter, String shell) {
        super(newFilename, converter, shell);
    }

    public BufferedSinglePassReader(String newFilename, String[] convArray) {
        super(newFilename, convArray);
    }

    public void prepare() throws Exception {
        if (this.endOfFile) {
            return;
        }
        if (this.eolCharacters == null) {
            String OS = System.getProperty("os.name", "Windows");
            if (this.getCharset() == System.getProperty("file.encoding")) {
                this.eolCharacters = System.getProperty("line.separator");
                this.eolLastCharacter = this.eolCharacters.charAt(this.eolCharacters.length() - 1);
                if ((OS.equals("z/OS") || OS.equals("OS/390")) && this.eolLastCharacter != '\u0015') {
                    this.eolLastCharacter = (char)21;
                }
            } else {
                String encoding = this.getCharset();
                Charset cs = null;
                try {
                    cs = Charset.forName(encoding);
                }
                catch (Exception exception) {}
                if (encoding.indexOf("1047") != -1 || encoding.equals("Cp500") || encoding.equals("Cp037") || cs != null && cs.displayName().indexOf("EBCDIC") != -1) {
                    this.eolLastCharacter = (char)21;
                    char[] eolchars = new char[]{this.eolLastCharacter};
                    this.eolCharacters = new String(eolchars);
                } else if (cs != null && (cs.displayName().indexOf("windows") != -1 || cs.displayName().indexOf(" PC ") != -1)) {
                    this.eolLastCharacter = (char)10;
                    char[] eolchars = new char[]{'\r', this.eolLastCharacter};
                    this.eolCharacters = new String(eolchars);
                } else {
                    this.eolLastCharacter = (char)10;
                    char[] eolchars = new char[]{this.eolLastCharacter};
                    this.eolCharacters = new String(eolchars);
                }
            }
        }
        if (this.getConverter() != null && this.getConverter().length() > 0 || this.getConverterArray() != null && this.getConverterArray().length > 0) {
            this.runConverter();
        }
        try {
            File logFile = new File(this.getFilename());
            this.setLastSize(logFile.length());
            this.logStream = new FileInputStream(logFile);
        }
        catch (Exception e) {
            this.logStream = null;
            throw new Exception(Messages.getString("HyadesGABufferedPeriodicReader_Log_File_Open_Failed_ERROR_", this.getFilename(), e.toString()));
        }
        try {
            this.bytesRead = this.logStream.read(this.logBuffer);
            if (this.bytesRead <= 0) {
                throw new Exception(Messages.getString("HyadesGABufferedPeriodicReader_No_Records_Read_ERROR_", this.getFilename()));
            }
            this.lastOffset = 0;
        }
        catch (IOException ioe) {
            throw new Exception(Messages.getString("HyadesGABufferedPeriodicReader_Log_File_Read_Failed_ERROR_", this.getFilename(), ioe.toString()));
        }
    }

    public void close() {
        try {
            if (this.logStream != null) {
                this.logStream.close();
            }
        }
        catch (Exception exception) {}
        this.logStream = null;
    }

    public String readLine() throws IOException {
        if (this.logStream != null && !this.endOfFile) {
            String last = null;
            try {
                int lineSize = 0;
                byte singleByte = 0;
                boolean endOfLine = false;
                int offset = this.lastOffset;
                while (!this.endOfFile && !endOfLine) {
                    singleByte = this.logBuffer[offset];
                    if (singleByte == this.eolLastCharacter) {
                        if (this.eolCharacters.length() > 1 && lineSize > 0) {
                            int n = 1;
                            int k = this.eolCharacters.length() - 2;
                            while (k >= 0) {
                                if ((byte)this.eolCharacters.charAt(k) == this.logBuffer[offset - n]) {
                                    --lineSize;
                                    ++n;
                                    --k;
                                    continue;
                                }
                                break;
                            }
                        } else if (lineSize > 0 && this.eolLastCharacter == '\n' && this.logBuffer[offset - 1] == 13) {
                            --lineSize;
                        }
                        endOfLine = true;
                    }
                    ++offset;
                    if (!endOfLine) {
                        ++lineSize;
                    }
                    if (offset == this.logBuffer.length) {
                        if (lineSize == this.logBuffer.length) {
                            byte[] tempBuffer = new byte[this.logBuffer.length + this.logBufferInitialSize];
                            System.arraycopy(this.logBuffer, 0, tempBuffer, 0, lineSize);
                            this.logBuffer = tempBuffer;
                        } else {
                            System.arraycopy(this.logBuffer, this.lastOffset, this.logBuffer, 0, lineSize);
                        }
                        this.bytesRead = this.logStream.read(this.logBuffer, lineSize, this.logBuffer.length - lineSize);
                        if (this.bytesRead == -1) {
                            this.endOfFile = true;
                        } else if (this.bytesRead == 0) {
                            return null;
                        }
                        offset = lineSize;
                        this.lastOffset = 0;
                        this.bytesRead += lineSize;
                        continue;
                    }
                    if (offset != this.bytesRead) continue;
                    int newBytesRead = this.logStream.read(this.logBuffer, offset, this.logBuffer.length - offset);
                    if (newBytesRead == -1) {
                        this.endOfFile = true;
                        endOfLine = true;
                        continue;
                    }
                    if (newBytesRead == 0) {
                        endOfLine = true;
                        continue;
                    }
                    this.bytesRead += newBytesRead;
                }
                if (lineSize == 0 && this.endOfFile) {
                    last = null;
                } else {
                    last = new String(this.logBuffer, this.lastOffset, lineSize, this.getCharset());
                    this.lastOffset = offset;
                }
            }
            catch (EOFException eOFException) {
                last = null;
            }
            catch (NullPointerException nullPointerException) {
                last = null;
            }
            if (this.endOfFile && !this.isMultiFile()) {
                this.close();
            }
            return last;
        }
        return null;
    }
}

