/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.soap.bindings.soap.interceptors;

import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.eclipse.ebpm.core.ExchangeUtils;
import org.eclipse.ebpm.messaging.api.Exchange;
import org.eclipse.ebpm.soap.api.Fault;
import org.eclipse.ebpm.soap.api.Message;
import org.eclipse.ebpm.soap.bindings.soap.SoapConstants;
import org.eclipse.ebpm.soap.bindings.soap.SoapFault;
import org.eclipse.ebpm.soap.bindings.soap.SoapVersion;
import org.eclipse.ebpm.soap.bindings.soap.SoapVersionFactory;
import org.eclipse.ebpm.soap.core.AbstractInterceptor;
import org.eclipse.ebpm.soap.util.stax.StaxUtil;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;

public class SoapInInterceptor
extends AbstractInterceptor {
    private final SoapVersion soapVersion;

    public SoapInInterceptor() {
        this(null);
    }

    public SoapInInterceptor(SoapVersion soapVersion) {
        this.soapVersion = soapVersion;
    }

    @Override
    public void handleMessage(Message message) {
        XMLStreamReader xmlReader = message.getContent(XMLStreamReader.class);
        if (xmlReader == null) {
            if (((Boolean)message.get("sendFaultsToTarget")).booleanValue()) {
                Exchange exchange = message.getContent(Exchange.class);
                org.eclipse.ebpm.messaging.api.Message out = exchange.getOut(true);
                out.setBody("<ERROR>" + new String(ExchangeUtils.getStringFromException((Throwable)new NullPointerException("No xml reader found"))) + "</ERROR>");
                exchange.setOut(out);
                message.setContent(Exchange.class, exchange);
                return;
            }
            throw new NullPointerException("No xml reader found");
        }
        try {
            QName name = xmlReader.getName();
            SoapVersion soapVersion = this.soapVersion;
            if (soapVersion == null) {
                soapVersion = message.get(SoapVersion.class);
            }
            if ((soapVersion = soapVersion == null ? SoapVersionFactory.getInstance().getSoapVersion(name) : soapVersion.getDerivedVersion(name.getPrefix())) == null) {
                if (((Boolean)message.get("sendFaultsToTarget")).booleanValue()) {
                    Exchange exchange = message.getContent(Exchange.class);
                    org.eclipse.ebpm.messaging.api.Message out = exchange.getOut(true);
                    out.setBody("<ERROR>" + new String(String.valueOf(ExchangeUtils.getStringFromException((Throwable)new SoapFault(SoapConstants.SOAP_12_CODE_VERSIONMISMATCH, "Unrecognized namespace: " + xmlReader.getNamespaceURI() + " at [" + xmlReader.getLocation().getLineNumber() + "," + xmlReader.getLocation().getColumnNumber() + "]. Expecting a Soap 1.1 or 1.2 namespace."))) + "</ERROR>"));
                    exchange.setOut(out);
                    message.setContent(Exchange.class, exchange);
                    return;
                }
                throw new SoapFault(SoapConstants.SOAP_12_CODE_VERSIONMISMATCH, "Unrecognized namespace: " + xmlReader.getNamespaceURI() + " at [" + xmlReader.getLocation().getLineNumber() + "," + xmlReader.getLocation().getColumnNumber() + "]. Expecting a Soap 1.1 or 1.2 namespace.");
            }
            message.put(SoapVersion.class, soapVersion);
            if (!name.equals(soapVersion.getEnvelope())) {
                if (name.getLocalPart().equals(soapVersion.getEnvelope().getLocalPart())) {
                    if (((Boolean)message.get("sendFaultsToTarget")).booleanValue()) {
                        Exchange exchange = message.getContent(Exchange.class);
                        org.eclipse.ebpm.messaging.api.Message out = exchange.getOut(true);
                        out.setBody("<ERROR>" + new String(String.valueOf(ExchangeUtils.getStringFromException((Throwable)new SoapFault(SoapConstants.SOAP_12_CODE_VERSIONMISMATCH, "Expected a SOAP " + soapVersion.getVersion() + " request"))) + "</ERROR>"));
                        exchange.setOut(out);
                        message.setContent(Exchange.class, exchange);
                        return;
                    }
                    throw new SoapFault(SoapConstants.SOAP_12_CODE_VERSIONMISMATCH, "Expected a SOAP " + soapVersion.getVersion() + " request");
                }
                if (((Boolean)message.get("sendFaultsToTarget")).booleanValue()) {
                    Exchange exchange = message.getContent(Exchange.class);
                    org.eclipse.ebpm.messaging.api.Message out = exchange.getOut(true);
                    out.setBody("<ERROR>" + new String(String.valueOf(ExchangeUtils.getStringFromException((Throwable)new SoapFault(SoapConstants.SOAP_12_CODE_VERSIONMISMATCH, "Unrecognized element: " + xmlReader.getName() + " at [" + xmlReader.getLocation().getLineNumber() + "," + xmlReader.getLocation().getColumnNumber() + "]. Expecting 'Envelope'."))) + "</ERROR>"));
                    exchange.setOut(out);
                    message.setContent(Exchange.class, exchange);
                    return;
                }
                throw new SoapFault(SoapConstants.SOAP_12_CODE_VERSIONMISMATCH, "Unrecognized element: " + xmlReader.getName() + " at [" + xmlReader.getLocation().getLineNumber() + "," + xmlReader.getLocation().getColumnNumber() + "]. Expecting 'Envelope'.");
            }
            xmlReader.nextTag();
            if (xmlReader.getName().equals(soapVersion.getHeader())) {
                Map<QName, DocumentFragment> headers = message.getSoapHeaders();
                while (xmlReader.nextTag() != 2) {
                    QName hn = xmlReader.getName();
                    Element e = StaxUtil.createElement(xmlReader);
                    DocumentFragment df = headers.get(hn);
                    if (df == null) {
                        df = e.getOwnerDocument().createDocumentFragment();
                    }
                    e = (Element)df.getOwnerDocument().importNode(e, true);
                    df.appendChild(e);
                    headers.put(hn, df);
                }
                xmlReader.nextTag();
            }
            if (!xmlReader.getName().equals(soapVersion.getBody())) {
                if (((Boolean)message.get("sendFaultsToTarget")).booleanValue()) {
                    Exchange exchange = message.getContent(Exchange.class);
                    org.eclipse.ebpm.messaging.api.Message out = exchange.getOut(true);
                    out.setBody("<ERROR>" + new String(String.valueOf(ExchangeUtils.getStringFromException((Throwable)new SoapFault(SoapFault.SENDER, "Unrecognized element: " + xmlReader.getName() + ". Expecting 'Body'."))) + "</ERROR>"));
                    exchange.setOut(out);
                    message.setContent(Exchange.class, exchange);
                    return;
                }
                throw new SoapFault(SoapFault.SENDER, "Unrecognized element: " + xmlReader.getName() + ". Expecting 'Body'.");
            }
            if (xmlReader.nextTag() == 2) {
                message.setContent(XMLStreamReader.class, null);
            }
        }
        catch (XMLStreamException e) {
            if (((Boolean)message.get("sendFaultsToTarget")).booleanValue()) {
                Exchange exchange = message.getContent(Exchange.class);
                org.eclipse.ebpm.messaging.api.Message out = exchange.getOut(true);
                out.setBody("<ERROR>" + new String(ExchangeUtils.getStringFromException((Throwable)e)) + "</ERROR>");
                exchange.setOut(out);
                message.setContent(Exchange.class, exchange);
                return;
            }
            throw new Fault(e);
        }
    }
}

