/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.soap.interceptors.nmr;

import java.net.URI;
import java.util.Map;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.eclipse.ebpm.constants.SpagicConstants;
import org.eclipse.ebpm.core.ExchangeUtils;
import org.eclipse.ebpm.messaging.api.Exchange;
import org.eclipse.ebpm.messaging.api.Pattern;
import org.eclipse.ebpm.soap.api.Fault;
import org.eclipse.ebpm.soap.api.Message;
import org.eclipse.ebpm.soap.api.model.Binding;
import org.eclipse.ebpm.soap.api.model.Operation;
import org.eclipse.ebpm.soap.core.AbstractInterceptor;
import org.eclipse.ebpm.soap.util.QNameUtil;
import org.w3c.dom.DocumentFragment;

public class NmrOutInterceptor
extends AbstractInterceptor {
    private final boolean server;

    public NmrOutInterceptor(boolean server) {
        this.server = server;
    }

    @Override
    public void handleMessage(Message message) {
        try {
            org.eclipse.ebpm.messaging.api.Message nm = message.getContent(org.eclipse.ebpm.messaging.api.Message.class);
            Document doc = DocumentHelper.parseText((String)nm.getBodyText());
            message.setContent(Document.class, doc);
            this.fromNMSAttachments(message, nm);
            this.fromNMSHeaders(message, nm);
            if (!this.server) {
                Exchange me = message.getContent(Exchange.class);
                Binding binding = message.get(Binding.class);
                Object operation = binding.getOperation(me.getOperation());
                if (operation != null) {
                    if (!this.areMepsEquals(me.getPattern(), operation.getMep())) {
                        throw new Fault("Received incorrect exchange mep.  Received " + me.getPattern() + " but expected " + operation.getMep() + " for operation " + operation.getName());
                    }
                    message.put(Operation.class, operation);
                    message.put(org.eclipse.ebpm.soap.api.model.Message.class, this.server ? operation.getOutput() : operation.getInput());
                }
            }
        }
        catch (Exception e) {
            if (message.get("sendFaultsToTarget") != null && ((Boolean)message.get("sendFaultsToTarget")).booleanValue()) {
                Exchange exchange = message.getContent(Exchange.class);
                org.eclipse.ebpm.messaging.api.Message out = exchange.getOut(true);
                out.setBody("<ERROR>" + new String(ExchangeUtils.getStringFromException((Throwable)e)) + "</ERROR>");
                exchange.setOut(out);
                message.setContent(Exchange.class, exchange);
                return;
            }
            throw new RuntimeException(e);
        }
    }

    private URI getURIMep(Pattern mepPattern) {
        if (mepPattern == Pattern.InOnly) {
            return SpagicConstants.IN_ONLY_URI;
        }
        if (mepPattern == Pattern.InOut) {
            return SpagicConstants.IN_OUT_URI;
        }
        return null;
    }

    private boolean areMepsEquals(Pattern mepPattern, URI mep2) {
        URI mep1 = this.getURIMep(mepPattern);
        if (mep1 == null) {
            return false;
        }
        String s1 = mep1 != null ? mep1.toString() : "";
        String s2 = mep2 != null ? mep2.toString() : "";
        int i1 = s1.lastIndexOf(47);
        int i2 = s2.lastIndexOf(47);
        if (i1 >= 0 && i2 >= 0) {
            return s1.substring(i1).equals(s2.substring(i2));
        }
        return false;
    }

    private void fromNMSAttachments(Message message, org.eclipse.ebpm.messaging.api.Message normalizedMessage) {
        Map attachmentMap = normalizedMessage.getAttachments();
        for (String attachmentId : attachmentMap.keySet()) {
            DataHandler handler = (DataHandler)attachmentMap.get(attachmentId);
            message.getAttachments().put(attachmentId, handler);
        }
    }

    private void fromNMSHeaders(Message message, org.eclipse.ebpm.messaging.api.Message normalizedMessage) {
        Map protocolHeaders = (Map)normalizedMessage.getHeader("nmr.messaging.protocol.headers");
        Map soapHeaders = (Map)normalizedMessage.getHeader("soap.headers");
        if (protocolHeaders != null) {
            for (Map.Entry entry : protocolHeaders.entrySet()) {
                if (((String)entry.getKey()).equalsIgnoreCase("Host")) continue;
                message.getTransportHeaders().put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        for (Map.Entry entry : soapHeaders.entrySet()) {
            QName name = QNameUtil.parse((String)entry.getKey());
            if (name == null || !(entry.getValue() instanceof DocumentFragment)) continue;
            message.getSoapHeaders().put(name, (DocumentFragment)entry.getValue());
        }
    }
}

