/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.core;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.eclipse.ebpm.core.SpagicNode;
import org.eclipse.ebpm.messaging.api.Exchange;
import org.eclipse.ebpm.messaging.api.Message;
import org.eclipse.ebpm.messaging.api.Pattern;
import org.eclipse.ebpm.messaging.api.Status;
import org.eclipse.ebpm.messaging.core.ExchangeImpl;
import org.eclipse.ebpm.messaging.core.MessageImpl;
import org.osgi.service.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class ExchangeUtils {
    public static Logger logger = LoggerFactory.getLogger(ExchangeUtils.class);
    public static SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss.SSS");

    public static boolean isInAndOut(Exchange exchange) {
        return exchange.getPattern() == Pattern.InOut || exchange.getPattern() == Pattern.InOptionalOut;
    }

    public static boolean isInOnly(Exchange exchange) {
        return exchange.getPattern() == Pattern.InOnly || exchange.getPattern() == Pattern.RobustInOnly;
    }

    public static Exchange createExchange(Pattern pattern) {
        return new ExchangeImpl(pattern);
    }

    public static Exchange createExchange(String id, Pattern pattern) {
        return new ExchangeImpl(id, pattern);
    }

    public static Exchange createExchange(String sender, String target, Pattern pattern) {
        Exchange e = ExchangeUtils.createExchange(pattern);
        e.setProperty("SPAGIC_SENDER", (Object)sender);
        if (target != null) {
            e.setProperty("SPAGIC_TARGET", (Object)target);
        }
        return e;
    }

    public static Exchange fromEvent(Event event) {
        String faultBody;
        String outBody;
        String mep = (String)event.getProperty("MEP");
        String exId = (String)event.getProperty("EXCHANGE_ID");
        String status = (String)event.getProperty("STATUS");
        Exchange exchange = null;
        if (mep.equalsIgnoreCase("in-only")) {
            exchange = ExchangeUtils.createExchange(exId, Pattern.InOnly);
        } else if (mep.equalsIgnoreCase("in-out")) {
            exchange = ExchangeUtils.createExchange(exId, Pattern.InOut);
        }
        String inBody = (String)event.getProperty("INBODY");
        Message in = null;
        Message out = null;
        Message fault = null;
        if (inBody != null) {
            in = exchange.getIn();
            in.setBody(inBody);
        }
        if ((outBody = (String)event.getProperty("OUTBODY")) != null) {
            out = exchange.getOut();
            out.setBody(outBody);
        }
        if ((faultBody = (String)event.getProperty("FAULTBODY")) != null) {
            fault = exchange.getFault();
            fault.setBody(faultBody);
        }
        String[] pNames = event.getPropertyNames();
        String realPropertyName = null;
        int i = 0;
        while (i < pNames.length) {
            if (pNames[i].startsWith("INP")) {
                realPropertyName = pNames[i].substring(pNames[i].indexOf(".") + 1);
                if (in != null) {
                    in.setHeader(realPropertyName, event.getProperty(pNames[i]));
                }
            } else if (pNames[i].startsWith("OUTP")) {
                realPropertyName = pNames[i].substring(pNames[i].indexOf(".") + 1);
                if (out != null) {
                    out.setHeader(realPropertyName, event.getProperty(pNames[i]));
                }
            } else if (pNames[i].startsWith("FAULTP")) {
                realPropertyName = pNames[i].substring(pNames[i].indexOf(".") + 1);
                if (fault != null) {
                    fault.setHeader(realPropertyName, event.getProperty(pNames[i]));
                }
            } else if (pNames[i].startsWith("EP")) {
                realPropertyName = pNames[i].substring(pNames[i].indexOf(".") + 1);
                if (!realPropertyName.startsWith("WF_VARIABLE")) {
                    realPropertyName = pNames[i].substring(pNames[i].lastIndexOf(".") + 1);
                }
                if (exchange != null) {
                    exchange.setProperty(realPropertyName, event.getProperty(pNames[i]));
                }
            } else if (pNames[i].equals("OUTA")) {
                if (out != null) {
                    ((MessageImpl)out)._decodeAttachments((String)event.getProperty(pNames[i]));
                }
            } else if (pNames[i].equals("INA")) {
                ((MessageImpl)in)._decodeAttachments((String)event.getProperty(pNames[i]));
            }
            ++i;
        }
        if (in != null) {
            exchange.setIn(in);
        }
        if (out != null) {
            exchange.setOut(out);
        }
        if (fault != null) {
            exchange.setFault(fault);
        }
        if (status.equalsIgnoreCase("ACTIVE")) {
            exchange.setStatus(Status.Active);
        }
        if (status.equalsIgnoreCase("DONE")) {
            exchange.setStatus(Status.Done);
        }
        if (status.equalsIgnoreCase("ERROR")) {
            exchange.setStatus(Status.Error);
        }
        if (exchange.getStatus().equals((Object)Status.Error)) {
            String excMessage = (String)event.getProperty("ERROR");
            exchange.setError(new Exception(excMessage));
        }
        return exchange;
    }

    public static String buildEventTopicFromExchange(Exchange exchange) {
        String target = (String)exchange.getProperties().get("SPAGIC_TARGET");
        String targetNode = (String)exchange.getProperties().get("EXCHANGE_TARGET_NODE");
        String senderNode = (String)exchange.getProperties().get("EXCHANGE_SENDER_NODE");
        exchange.getProperties().put("EXCHANGE_SENDER_NODE", SpagicNode.id());
        if (senderNode != null) {
            targetNode = senderNode;
        }
        return SpagicNode.topicForServiceAndExternalNode(target, targetNode);
    }

    public static Event toEvent(Exchange exchange) {
        Message fault;
        Message out;
        String cfr_ignored_0 = (String)exchange.getProperties().get("SPAGIC_SENDER");
        String cfr_ignored_1 = (String)exchange.getProperties().get("SPAGIC_TARGET");
        String eventTopic = ExchangeUtils.buildEventTopicFromExchange(exchange);
        HashMap<String, String> properties = new HashMap<String, String>();
        if (exchange.getPattern() == Pattern.InOnly) {
            properties.put("MEP", "in-only");
        } else if (exchange.getPattern() == Pattern.InOut) {
            properties.put("MEP", "in-out");
        }
        properties.put("EXCHANGE_ID", exchange.getId());
        if (exchange.getStatus() == Status.Active) {
            properties.put("STATUS", "ACTIVE");
        } else if (exchange.getStatus() == Status.Done) {
            properties.put("STATUS", "DONE");
        } else if (exchange.getStatus() == Status.Error) {
            properties.put("STATUS", "ERROR");
        }
        Map exchangeProperties = exchange.getProperties();
        String destPropertyName = null;
        for (String exProp : exchangeProperties.keySet()) {
            destPropertyName = "EP." + exProp;
            properties.put(destPropertyName, (String)exchangeProperties.get(exProp));
        }
        Message in = exchange.getIn(false);
        if (in != null) {
            properties.put("INBODY", in.getBodyText());
            Map inProperties = in.getHeaders();
            for (String inProperty : inProperties.keySet()) {
                destPropertyName = "INP." + inProperty;
                properties.put(destPropertyName, (String)inProperties.get(inProperty));
            }
            String encodedAtts = ((MessageImpl)in)._encodeAttachments();
            if (encodedAtts != null) {
                properties.put("INA", encodedAtts);
            }
        }
        if ((out = exchange.getOut(false)) != null) {
            properties.put("OUTBODY", out.getBodyText());
            Map outProperties = out.getHeaders();
            for (String outProperty : outProperties.keySet()) {
                destPropertyName = "OUTP." + outProperty;
                properties.put(destPropertyName, (String)outProperties.get(outProperty));
            }
            String encodedAtts = ((MessageImpl)out)._encodeAttachments();
            if (encodedAtts != null) {
                properties.put("OUTA", encodedAtts);
            }
        }
        if ((fault = exchange.getFault(false)) != null) {
            properties.put("FAULTBODY", fault.getBodyText());
            Map faultProperties = fault.getHeaders();
            for (String faultProperty : faultProperties.keySet()) {
                destPropertyName = "FAULTP." + faultProperty;
                properties.put(destPropertyName, (String)faultProperties.get(faultProperty));
            }
        }
        if (exchange.getError() != null) {
            properties.put("ERROR", ExchangeUtils.getStringFromException(exchange.getError()));
        }
        Event ev = new Event(eventTopic, properties);
        return ev;
    }

    public static String getStringFromException(Throwable e) {
        if (e.getMessage() != null) {
            return e.getMessage();
        }
        if (e.getCause() != null) {
            if (e.getCause().getMessage() != null) {
                return e.getCause().getMessage();
            }
            return e.getCause().toString();
        }
        return " Generic Error ";
    }

    public static boolean isSync(Exchange exchange) {
        String syncExchange = (String)exchange.getProperty("SYNC_EXCHANGE");
        if (syncExchange != null) {
            return Boolean.valueOf(syncExchange);
        }
        return false;
    }

    public static void setSync(Exchange exchange) {
        exchange.setProperty("SYNC_EXCHANGE", (Object)"true");
    }

    public static String headerAsXML(Message message) {
        Map hdrs = message.getHeaders();
        if (hdrs == null || hdrs.size() == 0) {
            return null;
        }
        Document doc = DocumentHelper.createDocument();
        Element headersRoot = doc.addElement("HEADERS");
        for (String id : hdrs.keySet()) {
            Object hdrValue = hdrs.get(id);
            if (hdrValue == null) continue;
            Element aHeader = headersRoot.addElement("HEADER").addAttribute("id", id);
            ExchangeUtils.fillHdrValue(aHeader, hdrValue);
        }
        return doc.asXML();
    }

    public static void fillHdrValue(Element hdrElement, Object hdrValue) {
        if (hdrValue instanceof Map) {
            Map stringMap = (Map)hdrValue;
            hdrElement.addAttribute("type", "Map");
            for (String key : stringMap.keySet()) {
                Object elementMapValue = stringMap.get(key);
                String stringValue = null;
                if (elementMapValue instanceof String) {
                    stringValue = (String)elementMapValue;
                } else if (elementMapValue instanceof Node) {
                    stringValue = ((Node)elementMapValue).getTextContent();
                } else {
                    logger.error("Unsupported type in fillHdrValue. Type: " + elementMapValue.getClass().getName() + " for attribute: " + key);
                }
                hdrElement.addElement("ENTRY").addAttribute("entryKey", key).addText(stringValue);
            }
        } else if (hdrValue instanceof Date) {
            hdrElement.addAttribute("type", "Date");
            hdrElement.setText(df.format((Date)hdrValue));
        } else if (hdrValue instanceof String) {
            hdrElement.addAttribute("type", "String");
            hdrElement.setText((String)hdrValue);
        } else if (hdrValue instanceof Boolean) {
            hdrElement.addAttribute("type", "Boolean");
            hdrElement.setText(String.valueOf(hdrValue));
        } else if (hdrValue instanceof Float) {
            hdrElement.addAttribute("type", "Float");
            hdrElement.setText(String.valueOf(hdrValue));
        } else if (hdrValue instanceof Double) {
            hdrElement.addAttribute("type", "Double");
            hdrElement.setText(String.valueOf(hdrValue));
        } else if (hdrValue instanceof Integer) {
            hdrElement.addAttribute("type", "Integer");
            hdrElement.setText(String.valueOf(hdrValue));
        } else if (hdrValue instanceof Long) {
            hdrElement.addAttribute("type", "Long");
            hdrElement.setText(String.valueOf(hdrValue));
        }
    }

    public static String getTextValue(Element hdrValueNode) {
        return hdrValueNode.getText() != null ? hdrValueNode.getText() : "";
    }

    public static Object getHdrValue(Element hdrValueNode) {
        String hdrType = hdrValueNode.attributeValue("type");
        if (hdrType.equalsIgnoreCase("Map")) {
            HashMap<String, String> stringMap = new HashMap<String, String>();
            List entries = hdrValueNode.elements("ENTRY");
            for (Element entry : entries) {
                stringMap.put(entry.attribute("entryKey").getValue(), entry.getText());
            }
            return stringMap;
        }
        if (hdrType.equalsIgnoreCase("Date")) {
            try {
                return df.parse(hdrValueNode.getText());
            }
            catch (Exception exception) {
                return null;
            }
        }
        if (hdrType.equalsIgnoreCase("String")) {
            return ExchangeUtils.getTextValue(hdrValueNode);
        }
        if (hdrType.equalsIgnoreCase("Boolean")) {
            return Boolean.valueOf(ExchangeUtils.getTextValue(hdrValueNode));
        }
        if (hdrType.equalsIgnoreCase("Float")) {
            return Float.valueOf(ExchangeUtils.getTextValue(hdrValueNode));
        }
        if (hdrType.equalsIgnoreCase("Double")) {
            return Double.valueOf(ExchangeUtils.getTextValue(hdrValueNode));
        }
        if (hdrType.equalsIgnoreCase("Integer")) {
            return Integer.valueOf(ExchangeUtils.getTextValue(hdrValueNode));
        }
        if (hdrType.equalsIgnoreCase("Long")) {
            return Long.valueOf(ExchangeUtils.getTextValue(hdrValueNode));
        }
        return hdrValueNode.getText();
    }

    public static void fillHeaders(Message message, String headersAsXML) {
        if (headersAsXML == null || headersAsXML.trim().length() == 0) {
            message.setHeaders(new HashMap());
            return;
        }
        try {
            Document doc = DocumentHelper.parseText((String)headersAsXML);
            HashMap<String, Object> hdrs = new HashMap<String, Object>();
            List nl = doc.getRootElement().elements("HEADER");
            for (Element n : nl) {
                String id = n.attributeValue("id");
                Object objValue = ExchangeUtils.getHdrValue(n);
                hdrs.put(id, objValue);
            }
            message.setHeaders(hdrs);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

