/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.connectors.jms.endpoints;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import org.eclipse.ebpm.connectors.jms.endpoints.JmsConsumerEndpoint;
import org.eclipse.ebpm.connectors.jms.marshaler.JmsConsumerMarshaler;
import org.eclipse.ebpm.core.AbstractSpagicConnector;
import org.eclipse.ebpm.messaging.api.Exchange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextListener
implements MessageListener {
    protected Logger logger = LoggerFactory.getLogger(JmsConsumerEndpoint.class);
    private final AbstractSpagicConnector connector;
    private final JmsConsumerMarshaler marshaler;

    public TextListener(AbstractSpagicConnector connector, JmsConsumerMarshaler marshaler) {
        this.connector = connector;
        this.marshaler = marshaler;
    }

    public void onMessage(Message message) {
        Exchange exchange = null;
        try {
            if (message instanceof TextMessage) {
                this.logger.info("Received message");
                TextMessage cfr_ignored_0 = (TextMessage)message;
                exchange = this.marshaler.createExchange(message);
                this.connector.configureExchangeTarget(exchange);
                this.connector.send(exchange);
            } else {
                this.logger.error("Message of wrong type: " + message.getClass().getName());
            }
        }
        catch (JMSException e) {
            this.logger.error("JMSException in onMessage(): ", (Throwable)e);
        }
        catch (Throwable t) {
            this.logger.error("Exception in onMessage():", t);
        }
    }
}

