/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.connectors.http.adapters;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import org.eclipse.ebpm.connectors.http.adapters.IHTTPOutputProtocolAdapter;
import org.eclipse.ebpm.connectors.http.adapters.SpagicJettyHTTPExchange;
import org.eclipse.ebpm.connectors.http.adapters.util.HTTPConnectorUtil;
import org.eclipse.ebpm.messaging.api.Exchange;
import org.eclipse.ebpm.messaging.api.Message;
import org.eclipse.ebpm.messaging.api.Pattern;
import org.eclipse.ebpm.messaging.api.Status;
import org.eclipse.ebpm.messaging.core.util.SourceTransformer;
import org.eclipse.ebpm.util.properties.PropertyConfigurator;
import org.eclipse.ebpm.xmlutil.EXMLUtils;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeaders;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ExtendedPlainHTTPOutputProtocolAdapter
implements IHTTPOutputProtocolAdapter {
    protected Logger logger = LoggerFactory.getLogger(ExtendedPlainHTTPOutputProtocolAdapter.class);
    private static final String prmPrefix = "HTTP-PRM-";
    private static final String _MULTIPART_RELATED = "multipart/related";
    private static final String _MULTIPART_FORM = "multipart/form-data";
    private static final String _JBI = "JBI";
    private static final String _QUERYSTRING = "QueryString";
    private static final String _HTTPHEADER = "HTTPHeader";
    public static final String MULTIPART_PREFIX = "multipart/";

    @Override
    public String getAdapterId() {
        return "ExtendedPlainHTTP";
    }

    protected String getLocationUri(Exchange exchange, Message inMsg, PropertyConfigurator pc) {
        if (inMsg.getHeader("locationURI") != null) {
            return (String)inMsg.getHeader("locationURI");
        }
        return pc.getString("locationURI");
    }

    protected String getMethod(Exchange exchange, Message inMsg, PropertyConfigurator pc) {
        if (inMsg.getHeader("method") != null) {
            return (String)inMsg.getHeader("method");
        }
        return pc.getString("method");
    }

    protected String getContentType(Exchange exchange, Message inMsg, PropertyConfigurator pc) {
        if (inMsg.getHeader("contentType") != null) {
            return (String)inMsg.getHeader("contentType");
        }
        return pc.getString("contentType");
    }

    protected String getParams(Exchange exchange, Message inMsg, PropertyConfigurator pc) {
        if (inMsg.getHeader("params") != null) {
            return (String)inMsg.getHeader("params");
        }
        return pc.getString("params");
    }

    protected String getMultipartPolicy(Exchange exchange, Message inMsg, PropertyConfigurator pc) {
        if (inMsg.getHeader("multipartPolicy") != null) {
            return (String)inMsg.getHeader("multipartPolicy");
        }
        return pc.getString("multipartPolicy", _MULTIPART_RELATED);
    }

    public String getErrorPolicy(PropertyConfigurator pc) {
        return pc.getString("errorPolicy", "FLOW");
    }

    @Override
    public void fillJettyExchange(Exchange exchange, SpagicJettyHTTPExchange httpExchange, PropertyConfigurator pc, Object binding) {
        byte[] byteBuffer = null;
        boolean isAttachmentPresent = false;
        try {
            Message inMsg = exchange.getIn(false);
            if (inMsg.getAttachments() != null && inMsg.getAttachments().size() > 0) {
                isAttachmentPresent = true;
            }
            String msgLocationUri = this.getLocationUri(exchange, inMsg, pc);
            String msgMethod = this.getMethod(exchange, inMsg, pc);
            String msgContentType = this.getContentType(exchange, inMsg, pc);
            String msgParams = this.getParams(exchange, inMsg, pc);
            String msgMultipartPolicy = this.getMultipartPolicy(exchange, inMsg, pc);
            httpExchange.setURL(msgLocationUri);
            httpExchange.addRequestHeader(HttpHeaders.HOST_BUFFER, (Buffer)new ByteArrayBuffer(new URI(msgLocationUri).getHost()));
            httpExchange.setMethod(msgMethod);
            Map headers = inMsg.getHeaders();
            Map<String, String> httpParameters = null;
            if (headers != null) {
                httpParameters = ExtendedPlainHTTPOutputProtocolAdapter.manageHeadersFromNMR(headers, httpExchange);
            }
            if (httpParameters != null) {
                byteBuffer = ExtendedPlainHTTPOutputProtocolAdapter.setParametersFromNMR(httpParameters, httpExchange, msgLocationUri, msgParams, msgMultipartPolicy, msgMethod, isAttachmentPresent);
            }
            if (byteBuffer == null && inMsg.getBody() != null) {
                String inMsgBodyText = inMsg.getBodyText();
                if (inMsgBodyText.indexOf("HTTP-BODY") == -1) {
                    byteBuffer = inMsgBodyText.getBytes("UTF-8");
                } else {
                    EXMLUtils eXMLUtils = new EXMLUtils();
                    Document bodyAsDOM = new SourceTransformer().toDOMDocument(inMsg);
                    Element httpBodyNode = eXMLUtils.selectNode((Node)bodyAsDOM, "//HTTP-BODY");
                    String tmpCDATA = eXMLUtils.getText((Node)httpBodyNode);
                    byteBuffer = tmpCDATA.getBytes("UTF-8");
                }
            }
            if (msgParams.equals(_QUERYSTRING) && (msgMethod.equals("PUT") || msgMethod.equals("DELETE"))) {
                msgContentType = "application/x-www-form-urlencoded";
            }
            if (msgParams.equals(_QUERYSTRING) && msgMethod.equals("POST") && !isAttachmentPresent) {
                msgContentType = "application/x-www-form-urlencoded";
            }
            ExtendedPlainHTTPOutputProtocolAdapter.prepareHttpJettyExchange(httpParameters, httpExchange, msgParams, msgMultipartPolicy, msgMethod, msgContentType, inMsg, byteBuffer);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void handleResponse(Exchange exchange, SpagicJettyHTTPExchange httpExchange, PropertyConfigurator pc, Object binding) {
        String xmlBody = null;
        HttpFields httpHeaders = null;
        HashMap<String, Object> headerFromMultipartFormData = null;
        try {
            int responseStatus = httpExchange.getResponseStatus();
            if (responseStatus != 200 && responseStatus != 202 && this.getErrorPolicy(pc).equals(_JBI)) {
                if (exchange.getPattern() == Pattern.InOnly) {
                    exchange.setError(new Exception("Invalid status response: " + responseStatus));
                }
                if (exchange.getPattern() == Pattern.InOut) {
                    Message fault = exchange.getFault(true);
                    fault.setBody(new String(httpExchange.getResponse()));
                    exchange.setFault(fault);
                }
            } else {
                if (exchange.getPattern() == Pattern.InOut) {
                    httpHeaders = httpExchange.getResponseFields();
                    String contentType = httpHeaders.getStringField("Content-Type");
                    if (contentType != null && contentType.toLowerCase().startsWith(MULTIPART_PREFIX)) {
                        InputStream is = new ByteArrayInputStream(httpExchange.getResponse());
                        Session session = Session.getDefaultInstance((Properties)new Properties());
                        is = new SequenceInputStream(new ByteArrayInputStream(new byte[]{13, 10}), is);
                        MimeMessage mime = new MimeMessage(session, is);
                        mime.setHeader("Content-Type", contentType);
                        String multipartType = contentType.substring(MULTIPART_PREFIX.length());
                        if (multipartType.startsWith("form-data")) {
                            headerFromMultipartFormData = new HashMap<String, Object>();
                            xmlBody = ExtendedPlainHTTPOutputProtocolAdapter.readMultipartFormData(exchange.getOut(), mime, headerFromMultipartFormData);
                        } else if (multipartType.startsWith("related")) {
                            xmlBody = ExtendedPlainHTTPOutputProtocolAdapter.readMultipartRelated(exchange.getOut(), mime);
                        }
                    } else {
                        byte[] tmpArray = httpExchange.getResponse();
                        xmlBody = tmpArray == null || tmpArray.length == 0 ? "" : new String(tmpArray);
                    }
                }
                if (exchange.getPattern() == Pattern.InOut) {
                    ByteArrayInputStream bais = new ByteArrayInputStream(xmlBody.getBytes("UTF-8"));
                    if (responseStatus == 200 || responseStatus == 202) {
                        if (!HTTPConnectorUtil.isXML(bais)) {
                            xmlBody = HTTPConnectorUtil.createXMLBody(xmlBody);
                        }
                        bais.close();
                    } else {
                        xmlBody = HTTPConnectorUtil.createXMLError(responseStatus, xmlBody);
                    }
                }
                if (exchange.getPattern() == Pattern.InOut) {
                    Message out = exchange.getOut();
                    out.setBody(xmlBody);
                    if (responseStatus == 200 || responseStatus == 202) {
                        httpHeaders = httpExchange.getResponseFields();
                        Enumeration e = httpHeaders.getFieldNames();
                        while (e.hasMoreElements()) {
                            String aKey = (String)e.nextElement();
                            if (aKey == null) continue;
                            out.setHeader(aKey, (Object)httpHeaders.getStringField(aKey));
                        }
                        if (headerFromMultipartFormData != null && headerFromMultipartFormData.size() > 0) {
                            for (Map.Entry e1 : headerFromMultipartFormData.entrySet()) {
                                String aKey = (String)e1.getKey();
                                if (aKey == null) continue;
                                out.setHeader(aKey, e1.getValue());
                            }
                        }
                    }
                    exchange.setOut(out);
                } else {
                    exchange.setStatus(Status.Done);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void handleException(Exchange exchange, SpagicJettyHTTPExchange httpExchange, Throwable ex, PropertyConfigurator pc, Object binding) {
        exchange.setError((Exception)ex);
    }

    public static void writeMultipartAttachments(Message message, OutputStream out, byte[] data) throws MessagingException, IOException {
        MimeMultipart parts = new MimeMultipart("related; type=\"text/xml\"; start=\"<body-part>\"");
        Session session = Session.getDefaultInstance((Properties)new Properties(), null);
        MimeMessage mime = new MimeMessage(session);
        MimeBodyPart soapPart = new MimeBodyPart();
        soapPart.setContentID("<body-part>");
        soapPart.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(data, "text/xml")));
        soapPart.setHeader("Content-Transfer-Encoding", "binary");
        soapPart.setHeader("Content-Type", "text/xml; charset=UTF-8");
        parts.addBodyPart((BodyPart)soapPart);
        for (Map.Entry entry : message.getAttachments().entrySet()) {
            String id = (String)entry.getKey();
            DataHandler dh = (DataHandler)entry.getValue();
            MimeBodyPart part = new MimeBodyPart();
            part.setDataHandler(dh);
            part.setContentID("<" + id + ">");
            part.setHeader("Content-Transfer-Encoding", "binary");
            part.setHeader("Content-Type", "application/octet-stream");
            parts.addBodyPart((BodyPart)part);
        }
        mime.setContent((Multipart)parts);
        mime.setHeader("Content-Type", parts.getContentType());
        message.setHeader("Content-Type", (Object)parts.getContentType());
        mime.saveChanges();
        Enumeration headersEnum = mime.getAllHeaders();
        ArrayList<String> headersList = new ArrayList<String>();
        while (headersEnum.hasMoreElements()) {
            String tmp = ((Header)headersEnum.nextElement()).getName();
            headersList.add(tmp);
        }
        String[] headers = headersList.toArray(new String[0]);
        FilterOutputStream os = new FilterOutputStream(out){
            private int nb = 0;

            @Override
            public void write(int b) throws IOException {
                if (++this.nb > 2) {
                    super.write(b);
                }
            }
        };
        mime.writeTo((OutputStream)os, headers);
    }

    public static void writeMultipartForm(Message message, Map<String, String> aMap, OutputStream out, byte[] data) throws MessagingException, IOException {
        MimeBodyPart part;
        DataHandler dh;
        String id;
        MimeMultipart parts = new MimeMultipart("form-data");
        Session session = Session.getDefaultInstance((Properties)new Properties(), null);
        MimeMessage mime = new MimeMessage(session);
        if (data != null && data.length > 0) {
            MimeBodyPart soapPart = new MimeBodyPart();
            soapPart.setHeader("Content-Disposition", "form-data");
            soapPart.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(data, "text/xml")));
            soapPart.setHeader("Content-Transfer-Encoding", "8bit");
            soapPart.setHeader("Content-Type", "text/xml; charset=UTF-8");
            parts.addBodyPart((BodyPart)soapPart);
        }
        if (aMap != null && aMap.size() > 0) {
            for (Map.Entry<String, String> e : aMap.entrySet()) {
                id = e.getKey();
                dh = new DataHandler((DataSource)new ByteArrayDataSource(e.getValue().getBytes("UTF-8"), "text/xml"));
                part = new MimeBodyPart();
                part.setDataHandler(dh);
                part.setHeader("Content-Disposition", "form-data; name=\"" + id + "\"");
                part.setHeader("Content-Type", "text/xml; charset=UTF-8");
                part.setHeader("Content-Transfer-Encoding", "8bit");
                parts.addBodyPart((BodyPart)part);
            }
        }
        if (message.getAttachments() != null && message.getAttachments().size() > 0) {
            for (Map.Entry entry : message.getAttachments().entrySet()) {
                id = (String)entry.getKey();
                dh = (DataHandler)entry.getValue();
                part = new MimeBodyPart();
                part.setDataHandler(dh);
                part.setHeader("Content-Disposition", "form-data; name=\"" + id + "\"; filename=\"" + id + "\"");
                String headerAttachContentType = (String)message.getHeader(String.valueOf(id) + "-content_type");
                if (headerAttachContentType != null && !headerAttachContentType.equals("")) {
                    part.setHeader("Content-Type", headerAttachContentType);
                }
                part.setHeader("Content-Transfer-Encoding", "binary");
                parts.addBodyPart((BodyPart)part);
            }
        }
        mime.setContent((Multipart)parts);
        String contentType = parts.getContentType().replaceAll("(\r\n\t)+", "");
        mime.setHeader("Content-Type", contentType);
        message.setHeader("Content-Type", (Object)contentType);
        mime.saveChanges();
        Enumeration headersEnum = mime.getAllHeaders();
        ArrayList<String> headersList = new ArrayList<String>();
        while (headersEnum.hasMoreElements()) {
            String tmp = ((Header)headersEnum.nextElement()).getName();
            headersList.add(tmp);
        }
        String[] headers = headersList.toArray(new String[0]);
        FilterOutputStream os = new FilterOutputStream(out){
            private int nb = 0;

            @Override
            public void write(int b) throws IOException {
                if (++this.nb > 2) {
                    super.write(b);
                }
            }
        };
        mime.writeTo((OutputStream)os, headers);
    }

    public static String getEncodedQueryString(Map<String, String> aMap) {
        StringBuffer qsb = null;
        if (aMap != null && aMap.size() > 0) {
            for (Map.Entry<String, String> entry : aMap.entrySet()) {
                try {
                    String tmp1 = URLEncoder.encode(entry.getKey(), "UTF-8");
                    String tmp2 = URLEncoder.encode(entry.getValue(), "UTF-8");
                    if (qsb == null) {
                        qsb = new StringBuffer();
                    } else {
                        qsb.append("&");
                    }
                    qsb.append(tmp1).append("=").append(tmp2);
                }
                catch (Exception exception) {}
            }
            return qsb.toString();
        }
        return null;
    }

    public static Map<String, String> manageHeadersFromNMR(Map<String, Object> nmrh, SpagicJettyHTTPExchange httpEx) {
        HashMap<String, String> httpParameters = new HashMap<String, String>();
        for (Map.Entry<String, Object> e : nmrh.entrySet()) {
            String aKey = e.getKey();
            if (aKey == null) continue;
            if (aKey.startsWith(prmPrefix)) {
                String tmpPrmName = aKey.substring(prmPrefix.length());
                httpParameters.put(tmpPrmName, (String)e.getValue());
                continue;
            }
            httpEx.setRequestHeader(e.getKey(), (String)e.getValue());
        }
        return httpParameters.size() > 0 ? httpParameters : null;
    }

    public static byte[] setParametersFromNMR(Map<String, String> prms, SpagicJettyHTTPExchange httpEx, String uri, String prmStrategy, String multipartStrategy, String httpMethod, boolean isAttPresent) throws UnsupportedEncodingException {
        byte[] bb = null;
        if (prmStrategy.equals(_HTTPHEADER)) {
            for (Map.Entry<String, String> e : prms.entrySet()) {
                e.getKey();
                httpEx.setRequestHeader(e.getKey(), e.getValue());
            }
        }
        if (prmStrategy.equals(_QUERYSTRING) && httpMethod.equals("GET")) {
            httpEx.setURL(String.valueOf(uri) + "?" + ExtendedPlainHTTPOutputProtocolAdapter.getEncodedQueryString(prms));
        }
        if (prmStrategy.equals(_QUERYSTRING) && (httpMethod.equals("PUT") || httpMethod.equals("DELETE"))) {
            bb = ExtendedPlainHTTPOutputProtocolAdapter.getEncodedQueryString(prms).getBytes("UTF-8");
        }
        if (prmStrategy.equals(_QUERYSTRING) && httpMethod.equals("POST") && !isAttPresent) {
            bb = ExtendedPlainHTTPOutputProtocolAdapter.getEncodedQueryString(prms).getBytes("UTF-8");
        }
        if (prmStrategy.equals(_QUERYSTRING) && httpMethod.equals("POST") && isAttPresent) {
            multipartStrategy.equals(_MULTIPART_FORM);
        }
        if (prmStrategy.equals(_QUERYSTRING) && httpMethod.equals("POST") && isAttPresent && multipartStrategy.equals(_MULTIPART_RELATED)) {
            bb = ExtendedPlainHTTPOutputProtocolAdapter.getEncodedQueryString(prms).getBytes("UTF-8");
        }
        return bb;
    }

    public static void prepareHttpJettyExchange(Map<String, String> prms, SpagicJettyHTTPExchange httpEx, String prmStrategy, String multipartStrategy, String httpMethod, String contentType, Message msg, byte[] buf) throws MessagingException, IOException {
        boolean isAttPresent = false;
        if (msg.getAttachments() != null && msg.getAttachments().size() > 0) {
            isAttPresent = true;
        }
        if (isAttPresent && httpMethod.equals("POST") && multipartStrategy.equals(_MULTIPART_RELATED)) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                ExtendedPlainHTTPOutputProtocolAdapter.writeMultipartAttachments(msg, baos, buf);
                httpEx.setRequestHeader("Content-Type", (String)msg.getHeader("Content-Type"));
                httpEx.setRequestContent((Buffer)new ByteArrayBuffer(baos.toByteArray()));
            }
            finally {
                baos.close();
            }
        } else if ((isAttPresent || prms != null) && httpMethod.equals("POST") && multipartStrategy.equals(_MULTIPART_FORM)) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                ExtendedPlainHTTPOutputProtocolAdapter.writeMultipartForm(msg, prms, baos, buf);
                httpEx.setRequestHeader("Content-Type", (String)msg.getHeader("Content-Type"));
                httpEx.setRequestContent((Buffer)new ByteArrayBuffer(baos.toByteArray()));
            }
            finally {
                baos.close();
            }
        } else {
            httpEx.setRequestHeader("Content-Type", contentType);
            if (buf != null) {
                httpEx.setRequestContent((Buffer)new ByteArrayBuffer(buf));
            }
        }
    }

    public static String readMultipartFormData(Message message, MimeMessage mime, Map<String, Object> paramToHeader) throws MessagingException, IOException {
        String bodyMessage = "";
        InputStream content = mime.getInputStream();
        if (!(content instanceof InputStream)) {
            throw new UnsupportedOperationException("Expected a InputStream object but found a " + content.getClass());
        }
        InputStream inputStream = content;
        ByteArrayDataSource inboundDataSource = new ByteArrayDataSource(inputStream, mime.getContentType());
        MimeMultipart multipart = new MimeMultipart((DataSource)inboundDataSource);
        int i = 0;
        while (i < multipart.getCount()) {
            MimeBodyPart part = (MimeBodyPart)multipart.getBodyPart(i);
            Header tmp = null;
            String name = "";
            String value = "";
            Enumeration enu1 = part.getAllHeaders();
            String partName = "";
            while (enu1.hasMoreElements()) {
                tmp = (Header)enu1.nextElement();
                name = tmp.getName();
                value = tmp.getValue();
                if (!name.toLowerCase().equals("content-disposition")) continue;
                int idx1 = value.indexOf("name=\"");
                String subStr = value.substring(idx1 + 6);
                int idx2 = subStr.indexOf("\"");
                partName = subStr.substring(0, idx2);
            }
            if (part.getFileName() != null) {
                message.addAttachment(partName, (Object)part.getDataHandler());
            } else {
                InputStream isPart = part.getInputStream();
                String valuePart = HTTPConnectorUtil.convertStreamToString(isPart);
                if (valuePart == null || valuePart.equals("")) {
                    isPart = new ByteArrayInputStream(valuePart.getBytes());
                }
                if (partName.equals("")) {
                    bodyMessage = HTTPConnectorUtil.isXML(isPart) ? valuePart : HTTPConnectorUtil.createXMLBody(valuePart);
                } else {
                    paramToHeader.put(partName, valuePart);
                }
            }
            ++i;
        }
        if (bodyMessage.equals("")) {
            bodyMessage = HTTPConnectorUtil.createXMLBody("");
        }
        return bodyMessage;
    }

    public static String readMultipartRelated(Message message, MimeMessage mime) throws MessagingException, IOException {
        int i;
        Object content = mime.getContent();
        String tmpXmlBody = null;
        if (!(content instanceof MimeMultipart)) {
            throw new UnsupportedOperationException("Expected a javax.mail.internet.MimeMultipart object but found a " + content.getClass());
        }
        MimeMultipart multipart = (MimeMultipart)content;
        ContentType type = new ContentType(mime.getContentType());
        String contentId = type.getParameter("start");
        MimeBodyPart contentPart = null;
        if (contentId != null) {
            contentPart = (MimeBodyPart)multipart.getBodyPart(contentId);
        } else {
            i = 0;
            while (i < multipart.getCount()) {
                MimeBodyPart contentPart2 = (MimeBodyPart)multipart.getBodyPart(i);
                String contentType = contentPart2.getContentType();
                if (contentType.indexOf("xml") >= 0) {
                    contentPart = contentPart2;
                    break;
                }
                ++i;
            }
        }
        tmpXmlBody = HTTPConnectorUtil.convertStreamToString(contentPart.getInputStream());
        i = 0;
        while (i < multipart.getCount()) {
            MimeBodyPart part = (MimeBodyPart)multipart.getBodyPart(i);
            if (part != contentPart) {
                String id = part.getContentID();
                if (id == null) {
                    id = "Part" + i;
                } else if (id.startsWith("<")) {
                    id = id.substring(1, id.length() - 1);
                }
                message.addAttachment(id, (Object)part.getDataHandler());
            }
            ++i;
        }
        return tmpXmlBody;
    }

    @Override
    public void setProperty(Map<String, String> map) {
    }
}

