/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.client.api;

import java.io.File;
import org.eclipse.ebpm.client.api.IAttachment;

public class MessageAttachment
implements IAttachment {
    private File file;
    private byte[] byteArray;
    private String mimeType;

    @Override
    public String getMimeType() {
        if (this.file == null && this.byteArray == null) {
            throw new Error("No data was set for this attachment, no mime type available");
        }
        return this.mimeType == null || this.mimeType.trim().equals("") ? "application/octet-stream" : this.mimeType;
    }

    @Override
    public void setData(File data, String mimeType) {
        if (this.byteArray != null || this.file != null) {
            throw new Error("Yon can not set again the data for this attachment!");
        }
        this.file = data;
        this.mimeType = mimeType;
    }

    @Override
    public void setData(byte[] data, String mimeType) {
        if (this.byteArray != null || this.file != null) {
            throw new Error("Yon can not set again the data for this attachment!");
        }
        this.byteArray = data;
        this.mimeType = mimeType;
    }

    @Override
    public byte[] getDataAsByteArray() throws Error {
        if (this.byteArray == null) {
            throw new Error("This attachment was not built with a byte array!");
        }
        return this.byteArray;
    }

    @Override
    public File getDataAsFile() throws Error {
        if (this.file == null) {
            throw new Error("This attachment was not built with a File!");
        }
        return this.file;
    }

    @Override
    public boolean isDataAFile() {
        return this.file != null && this.byteArray == null;
    }
}

