/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.nodemanager.hazelcast;

import com.hazelcast.config.Config;
import com.hazelcast.core.Cluster;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.Member;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import java.util.ArrayList;
import org.eclipse.ebpm.nodemanager.api.INodeManager;
import org.eclipse.ebpm.nodemanager.api.INodeManagerListener;

public class HazelCastNodeManager
implements INodeManager,
MembershipListener {
    private HazelcastInstance hazelCastInstance = null;
    private INodeManagerListener listener = null;

    public void disconnet() {
    }

    public void join(String cluster, String nodeId) {
        Config config = new Config();
        config.getGroupConfig().setName(cluster);
        this.hazelCastInstance = Hazelcast.newHazelcastInstance((Config)config);
        Cluster hzCluster = this.hazelCastInstance.getCluster();
        IMap memberIds = Hazelcast.getMap((String)"member-ids");
        memberIds.put(hzCluster.getLocalMember(), nodeId);
        this.hazelCastInstance.getCluster().addMembershipListener((MembershipListener)this);
    }

    public void registerListener(INodeManagerListener nodeManagerList) {
    }

    public void memberAdded(MembershipEvent event) {
        this.notifyChange();
    }

    public void memberRemoved(MembershipEvent event) {
        this.notifyChange();
    }

    protected void notifyChange() {
        IMap memberIds = Hazelcast.getMap((String)"member-ids");
        ArrayList<String> viewMembersAsString = new ArrayList<String>();
        for (Member member : this.hazelCastInstance.getCluster().getMembers()) {
            String newViewNode = (String)memberIds.get(member);
            viewMembersAsString.add(newViewNode);
        }
        this.listener.onClusterChange(viewMembersAsString);
    }
}

