/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.graph.util;

public class GraphNode {
    private String id;
    private String title;
    private String URL;
    private String comment;
    private String tooltip = "Detail";
    private int fontSize = 6;
    private String fontName = "Tahoma";
    private String shape = "box";
    private String color = "gray";
    private String style = "rounded";
    private String fillColor = null;

    public GraphNode(String id, String title) {
        this.id = id;
        this.title = title;
        this.setFillColor("white");
    }

    public GraphNode(String id, String title, String url, String comment, String tooltip) {
        this.id = id;
        this.title = title;
        this.URL = url;
        this.comment = comment;
        this.tooltip = tooltip;
        this.setFillColor("white");
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public String getURL() {
        return this.URL;
    }

    public void setURL(String url) {
        this.URL = url;
    }

    public String toString() {
        StringBuffer dotStringBuffer = new StringBuffer();
        dotStringBuffer.append(String.valueOf(this.id) + " [label=\"" + this.title + "\"");
        dotStringBuffer.append(", fontname=\"" + this.fontName + "\"");
        dotStringBuffer.append(", fontsize=\"" + this.fontSize + "\"");
        dotStringBuffer.append(", tooltip=\"" + this.tooltip + "\"");
        dotStringBuffer.append(", URL=\"" + this.URL + "\"");
        dotStringBuffer.append(", color=" + this.color);
        dotStringBuffer.append(", shape=" + this.shape);
        if (this.fillColor != null) {
            dotStringBuffer.append(", fillcolor=" + this.fillColor);
        }
        if (this.style != null) {
            dotStringBuffer.append(", style=" + this.style);
        }
        dotStringBuffer.append(" ]");
        return dotStringBuffer.toString();
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public String getShape() {
        return this.shape;
    }

    public void setShape(String shape) {
        this.shape = shape;
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(String fillColor) {
        this.fillColor = fillColor;
        if (this.style != null) {
            String oldStyle = this.getStyle();
            if (oldStyle.startsWith("\"")) {
                oldStyle = oldStyle.substring(0, oldStyle.length() - 1);
                oldStyle = String.valueOf(oldStyle) + ",filled\"";
                this.setStyle(oldStyle);
            } else {
                this.setStyle("\"" + this.style + ",filled\"");
            }
        } else {
            this.setStyle("filled");
        }
    }
}

