/*******************************************************************************
 * Copyright (c) 2010 Engineering Group.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 * 			Andrea Zoppello (Engineering Group) - initial API and implementation and/or initial documentation
 * 			Gianfranco Boccalon (Engineering Group) - initial API and implementation and/or initial documentation
 *          Luca Rossato ( Engineering Group ) - initial API and implementation and/or initial documentation
 *          Luca Barozzi ( Engineering Group ) - initial API and implementation and/or initial documentation
 *  		Antonietta Miele ( Engineering Group ) - initial API and implementation and/or initial documentation
 *******************************************************************************/

package org.eclipse.ebpm.connectors.http.ssl;


/**
 * @author Andrea Zoppello 
 */
public class SslBean {

 
	// Certificate Parameter 
    private String keyAlias;
    private String keyPassword;
    
    
    private String provider;
	private String protocol = "TLS";
    
    private boolean wantClientAuth;
    private boolean needClientAuth;
    
    private KeyStoreBean keyStore = null;
	private KeyStoreBean trustStore = null;
	

    public SslBean() {
    	keyStore = new KeyStoreBean("ssl.KeyManagerFactory.algorithm");
        trustStore = new KeyStoreBean("ssl.TrustManagerFactory.algorithm");
    }

    public String getProvider() {
		return provider;
	}

	public void setProvider(String provider) {
		this.provider = provider;
	}

   

    /**
     * @return the keyAlias
     */
    public String getKeyAlias() {
        return keyAlias;
    }

   
    public void setKeyAlias(String keyAlias) {
        this.keyAlias = keyAlias;
    }


    public String getKeyPassword() {
        return keyPassword;
    }

    
    public void setKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
    }

    public boolean isNeedClientAuth() {
        return needClientAuth;
    }

   
    public void setNeedClientAuth(boolean needClientAuth) {
        this.needClientAuth = needClientAuth;
    }

    
    public String getProtocol() {
        return protocol;
    }

   
    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    
    public boolean isWantClientAuth() {
        return wantClientAuth;
    }

   
    public void setWantClientAuth(boolean wantClientAuth) {
        this.wantClientAuth = wantClientAuth;
    }

    

//    public boolean equals(Object o) {
//        if (o == this) {
//            return true;
//        }
//        if (!(o instanceof SslBean)) {
//            return false;
//        }
//        SslBean s = (SslBean) o;
//        return (  protocol.equalsIgnoreCase(s.protocol)
//        	   && ( keyAlias.equals(s.keyAlias) )
//        	   && ( keyPassword.equals(s.keyPassword) )
//        	   && ( keyStore.equals(s.keyStore) )
//        	   && ( trustStore.equals(s.trustStore) )
//        	   && ( wantClientAuth == s.wantClientAuth )
//        	   && ( needClientAuth == s.needClientAuth));
//        	   
//      
//    }

   

	
	
    // UTILITIES METHOD THAT DELEGATES TO keyStoreBean and TrustStore Bean
    
    public String getKeyStore(){
    	return ( this.keyStore != null ? keyStore.getUri() : null );
    }
    

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		SslBean other = (SslBean) obj;
		if (keyAlias == null) {
			if (other.keyAlias != null)
				return false;
		} else if (!keyAlias.equals(other.keyAlias))
			return false;
		if (keyPassword == null) {
			if (other.keyPassword != null)
				return false;
		} else if (!keyPassword.equals(other.keyPassword))
			return false;
		if (keyStore == null) {
			if (other.keyStore != null)
				return false;
		} else if (!keyStore.equals(other.keyStore))
			return false;
		if (needClientAuth != other.needClientAuth)
			return false;
		if (protocol == null) {
			if (other.protocol != null)
				return false;
		} else if (!protocol.equals(other.protocol))
			return false;
		if (provider == null) {
			if (other.provider != null)
				return false;
		} else if (!provider.equals(other.provider))
			return false;
		if (trustStore == null) {
			if (other.trustStore != null)
				return false;
		} else if (!trustStore.equals(other.trustStore))
			return false;
		if (wantClientAuth != other.wantClientAuth)
			return false;
		return true;
	}

	public String getTrustStore(){
    	return ( this.trustStore != null ? trustStore.getUri() : null );
    }
    
    public String getKeyStorePassword(){
    	return ( this.keyStore != null ? keyStore.getPassword() : null );
    }
    
    public String getTrustStorePassword(){
    	return ( this.trustStore != null ? trustStore.getPassword() : null );
    }
    
    public String getKeyStoreType(){
    	return ( this.keyStore != null ? keyStore.getType() : null );
    }
    
    public String getTrustStoreType(){
    	return ( this.trustStore != null ? trustStore.getType() : null );
    }
    
    public String getKeyManagerFactoryAlgorithm(){
    	return ( this.keyStore != null ? keyStore.getKeyManagerFactoryAlgorithm() : null );
    }
    
    public String getTrustManagerFactoryAlgorithm(){
    	return ( this.trustStore != null ? keyStore.getKeyManagerFactoryAlgorithm() : null );
    }

    
    public void setKeyStore(String keyStore){
    	this.keyStore.setUri(keyStore);
    }
    
    public void setKeyStorePassword(String password){
    	this.keyStore.setPassword(password);
    }
    
    public void setKeyStoreType(String type){
    	this.keyStore.setType(type);
    }
    
    public void setTrustStore(String trustSore){
    	this.trustStore.setUri(trustSore);
    }
    
    public void setTrustStorePassword(String password){
    	this.trustStore.setPassword(password);
    }
    
    public void setTrustStoreType(String type){
    	this.trustStore.setType(type);
    }

}
