/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.util.introspection;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.introspection.ClassUtils;
import org.assertj.core.util.introspection.MemberUtils;

public class FieldUtils {
    static Field getField(Class<?> cls, String fieldName, boolean forceAccess) throws IllegalAccessException {
        Preconditions.checkArgument(cls != null, "The class must not be null", new Object[0]);
        Preconditions.checkArgument(fieldName != null, "The field name must not be null", new Object[0]);
        for (Class<?> acls = cls; acls != null; acls = acls.getSuperclass()) {
            try {
                Field field = acls.getDeclaredField(fieldName);
                if (!Modifier.isPublic(field.getModifiers())) {
                    if (forceAccess) {
                        field.setAccessible(true);
                    } else {
                        throw new IllegalAccessException("can not access" + fieldName + " because it is not public");
                    }
                }
                return field;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        Field match = null;
        for (Class<?> class1 : ClassUtils.getAllInterfaces(cls)) {
            try {
                Field test = class1.getField(fieldName);
                Preconditions.checkArgument(match == null, "Reference to field " + fieldName + " is ambiguous relative to " + cls + "; a matching field exists on two or more implemented interfaces.", new Object[0]);
                match = test;
            }
            catch (NoSuchFieldException noSuchFieldException) {}
        }
        return match;
    }

    private static Object readField(Field field, Object target) throws IllegalAccessException {
        return FieldUtils.readField(field, target, false);
    }

    private static Object readField(Field field, Object target, boolean forceAccess) throws IllegalAccessException {
        Preconditions.checkArgument(field != null, "The field must not be null", new Object[0]);
        if (forceAccess && !field.isAccessible()) {
            field.setAccessible(true);
        } else {
            MemberUtils.setAccessibleWorkaround(field);
        }
        return field.get(target);
    }

    static Object readField(Object target, String fieldName, boolean forceAccess) throws IllegalAccessException {
        Preconditions.checkArgument(target != null, "target object must not be null", new Object[0]);
        Class<?> cls = target.getClass();
        Field field = FieldUtils.getField(cls, fieldName, forceAccess);
        Preconditions.checkArgument(field != null, "Cannot locate field " + fieldName + " on " + cls, new Object[0]);
        return FieldUtils.readField(field, target);
    }
}

